/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulatorUpdatesTest;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class GenericBlockBasedIndexPopulatorUpdatesTest<KEY extends GenericKey<KEY>>
extends BlockBasedIndexPopulatorUpdatesTest<KEY> {
    GenericBlockBasedIndexPopulatorUpdatesTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleEntriesOfMaxSize() throws IndexEntryConflictException, IOException {
        BlockBasedIndexPopulator populator = this.instantiatePopulator(this.INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(populator.layout, maxKeyValueSize)});
            Set<ValueIndexEntryUpdate> updates = Collections.singleton(update);
            populator.add(updates, CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            this.assertHasEntry(populator, update.values()[0], 1);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldThrowForEntriesLargerThanMaxSize() throws IOException {
        BlockBasedIndexPopulator populator = this.instantiatePopulator(this.INDEX_DESCRIPTOR);
        try {
            int maxKeyValueSize = populator.tree.keyValueSizeCap();
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(populator.layout, maxKeyValueSize + 1)});
            IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
                Set<ValueIndexEntryUpdate> updates = Collections.singleton(update);
                populator.add(updates, CursorContext.NULL);
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            });
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("Property value is too large to index, please see index documentation for limitations. Index: Index( id=1, name='index', type='GENERAL " + this.indexType() + "', schema=(:Label1 {property1}), indexProvider='Undecided-0' ), entity id: 1, property size: 8176, value: [String(\"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA....")));
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    @Override
    Value supportedValue(int identifier) {
        return Values.stringValue((String)("StringValue " + identifier));
    }
}

