/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.neo4j.kernel.impl.locking.DumpLocksVisitor;
import org.neo4j.kernel.impl.locking.LockWorker;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.logging.Log;
import org.neo4j.logging.log4j.Log4jLogProvider;

public class LockWorkFailureDump {
    private final Path file;

    public LockWorkFailureDump(Path file) {
        this.file = file;
    }

    public Path dumpState(Locks lm, LockWorker ... workers) throws IOException {
        try (OutputStream out = Files.newOutputStream(this.file, new OpenOption[0]);){
            Log4jLogProvider logProvider = new Log4jLogProvider(out);
            lm.accept((Locks.Visitor)new DumpLocksVisitor(logProvider.getLog(LockWorkFailureDump.class)));
            Log log = logProvider.getLog(this.getClass());
            for (LockWorker worker : workers) {
                log.info("Worker %s", new Object[]{worker});
            }
            Path path = this.file;
            return path;
        }
    }
}

