/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.forseti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.forseti.ForsetiLockManager;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.time.Clocks;
import org.neo4j.util.concurrent.BinaryLatch;

@ExtendWith(value={RandomExtension.class})
class ForsetiLockManagerTest {
    @Inject
    RandomSupport random;
    Config config;
    ForsetiLockManager manager;

    ForsetiLockManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.config = Config.defaults((Setting)GraphDatabaseInternalSettings.lock_manager_verbose_deadlocks, (Object)true);
        this.manager = new ForsetiLockManager(this.config, Clocks.nanoClock(), (ResourceType[])ResourceTypes.values());
    }

    @AfterEach
    void tearDown() {
        this.manager.close();
    }

    @Test
    void testMultipleClientsSameTxId() throws Throwable {
        boolean TX_ID = false;
        Race race = new Race();
        race.addContestants(3, Race.throwing(() -> {
            try (Locks.Client client = this.manager.newClient();){
                client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
                if (this.random.nextBoolean()) {
                    client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{0L});
                } else {
                    client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{0L});
                }
            }
        }));
        race.go(3L, TimeUnit.MINUTES);
    }

    @Test
    void lockClientsShouldNotHaveMutatingEqualsAndHashCode() {
        int i;
        int uniqueClients = 10000;
        HashSet<Locks.Client> allClientsSet = new HashSet<Locks.Client>(uniqueClients);
        ArrayList<Locks.Client> allClientsList = new ArrayList<Locks.Client>(uniqueClients);
        for (i = 0; i < uniqueClients; ++i) {
            Locks.Client client2 = this.manager.newClient();
            allClientsSet.add(client2);
            allClientsList.add(client2);
            client2.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, (long)i, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
        }
        for (i = 0; i < 100; ++i) {
            allClientsSet.forEach(client -> client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, this.random.nextLong(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config));
        }
        allClientsList.forEach(o -> org.junit.jupiter.api.Assertions.assertTrue((boolean)allClientsSet.remove(o)));
        Assertions.assertThat(allClientsSet).isEmpty();
    }

    @Test
    void shouldHaveCorrectActiveLocks() {
        try (Locks.Client client = this.manager.newClient();){
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 0L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
            this.takeAndAssertActiveLocks(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHaveCorrectActiveLocksConcurrently() throws Throwable {
        Race race = new Race();
        AtomicLong tx = new AtomicLong();
        AtomicBoolean done = new AtomicBoolean();
        BinaryLatch start = new BinaryLatch();
        race.addContestants(5, Race.throwing(() -> {
            start.release();
            while (!done.get()) {
                try {
                    Locks.Client client = this.manager.newClient();
                    try {
                        client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, tx.incrementAndGet(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
                        long id = this.random.nextLong(10L);
                        if (this.random.nextBoolean()) {
                            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{id});
                        } else {
                            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{id});
                        }
                        Thread.sleep(1L);
                    }
                    finally {
                        if (client == null) continue;
                        client.close();
                    }
                }
                catch (Exception exception) {}
            }
        }));
        Race.Async async = race.goAsync();
        try (Locks.Client client = this.manager.newClient();){
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, tx.incrementAndGet(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, this.config);
            start.await();
            this.takeAndAssertActiveLocks(client);
        }
        finally {
            done.set(true);
        }
        async.await(1L, TimeUnit.MINUTES);
    }

    @Test
    void shouldBeAbleToTrackMemoryCorrectlyWhenTerminatingFromDifferentThread() {
        AtomicBoolean terminated = new AtomicBoolean();
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        try (OtherThreadExecutor executor = new OtherThreadExecutor("test");
             Locks.Client client = this.manager.newClient();){
            client.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, (MemoryTracker)memoryTracker, this.config);
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{1L});
            executor.executeDontWait(() -> {
                Thread.sleep(10L);
                client.stop();
                terminated.set(true);
                return null;
            });
            while (!terminated.get()) {
                int memory = this.random.nextInt(10000);
                memoryTracker.allocateHeap((long)memory);
                memoryTracker.releaseHeap((long)memory);
            }
        }
        Assertions.assertThat((long)memoryTracker.estimatedHeapMemory()).isZero();
    }

    private void takeAndAssertActiveLocks(Locks.Client client) {
        HashMap<Long, Integer> exclusiveLocks = new HashMap<Long, Integer>();
        HashMap<Long, Integer> sharedLocks = new HashMap<Long, Integer>();
        for (int i = 0; i < 10000; ++i) {
            boolean takeLock;
            boolean bl = takeLock = exclusiveLocks.isEmpty() && sharedLocks.isEmpty() || this.random.nextBoolean();
            if (takeLock) {
                long id = this.random.nextLong(10L);
                if (this.random.nextBoolean()) {
                    client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{id});
                    exclusiveLocks.compute(id, (key, count) -> count == null ? 1 : count + 1);
                } else {
                    client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{id});
                    sharedLocks.compute(id, (key, count) -> count == null ? 1 : count + 1);
                }
            } else if (sharedLocks.isEmpty() || !exclusiveLocks.isEmpty() && this.random.nextBoolean()) {
                Long toRemove = (Long)this.random.among((Object[])exclusiveLocks.keySet().toArray(new Long[0]));
                client.releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP, new long[]{toRemove});
                exclusiveLocks.compute(toRemove, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
            } else {
                Long toRemove = (Long)this.random.among((Object[])sharedLocks.keySet().toArray(new Long[0]));
                client.releaseShared((ResourceType)ResourceTypes.RELATIONSHIP, new long[]{toRemove});
                sharedLocks.compute(toRemove, (key, count) -> count == 1 ? null : Integer.valueOf(count - 1));
            }
            int totalLocks = Sets.mutable.withAll(exclusiveLocks.keySet()).withAll(sharedLocks.keySet()).size();
            List<ActiveLock> activeLocks = client.activeLocks().collect(Collectors.toList());
            Assertions.assertThat((long)client.activeLockCount()).isEqualTo((long)totalLocks);
            Assertions.assertThat((int)activeLocks.size()).isEqualTo(client.activeLockCount());
            activeLocks.forEach(lock -> Assertions.assertThat((Map)(lock.lockType().equals((Object)LockType.EXCLUSIVE) ? exclusiveLocks : sharedLocks)).containsKey((Object)lock.resourceId()));
        }
    }
}

