/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.EagerlyReversedTransactionCursor;

class EagerlyReversedTransactionCursorTest {
    EagerlyReversedTransactionCursorTest() {
    }

    @Test
    void shouldReverseTransactionsFromSource() throws Exception {
        CommittedTransactionRepresentation tx1 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        CommittedTransactionRepresentation tx2 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        CommittedTransactionRepresentation tx3 = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        TransactionCursor source = GivenTransactionCursor.given(tx1, tx2, tx3);
        EagerlyReversedTransactionCursor cursor = new EagerlyReversedTransactionCursor(source);
        Object[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        Assertions.assertArrayEquals((Object[])Iterators.array((Object[])new CommittedTransactionRepresentation[]{tx3, tx2, tx1}), (Object[])reversed);
    }

    @Test
    void shouldHandleEmptySource() throws Exception {
        TransactionCursor source = GivenTransactionCursor.given(new CommittedTransactionRepresentation[0]);
        EagerlyReversedTransactionCursor cursor = new EagerlyReversedTransactionCursor(source);
        CommittedTransactionRepresentation[] reversed = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
        Assertions.assertEquals((int)0, (int)reversed.length);
    }
}

