/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.exceptions.index.FlipFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.ContractCheckingIndexProxy;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.MockIndexProviderMap;
import org.neo4j.kernel.impl.api.index.OnlineIndexProxy;
import org.neo4j.kernel.impl.api.index.TentativeConstraintIndexProxy;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.InMemoryTokens;

class IndexProxyCreatorTest {
    private final int LABEL_ID = 7;
    private final int PROPERTY_KEY_ID = 15;
    private final IndexPrototype UNIQUE_INDEX = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)7, (int[])new int[]{15})).withIndexProvider(TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("constraint");

    IndexProxyCreatorTest() {
    }

    @Test
    void onlineUniquenessIndexProxyWithOwningConstraintShouldBeOnline() {
        IndexProvider provider = this.newProvider();
        IndexProxyCreator creator = this.newCreator(provider);
        ContractCheckingIndexProxy proxy = (ContractCheckingIndexProxy)creator.createOnlineIndexProxy(this.UNIQUE_INDEX.materialise(10L).withOwningConstraintId(4L));
        Assertions.assertThat((Object)proxy.getDelegate()).isExactlyInstanceOf(OnlineIndexProxy.class);
    }

    @Test
    void onlineUniquenessIndexProxyWithoutOwningConstraintShouldBeTentative() throws IndexActivationFailedKernelException {
        IndexProvider provider = this.newProvider();
        IndexProxyCreator creator = this.newCreator(provider);
        ContractCheckingIndexProxy proxy = (ContractCheckingIndexProxy)creator.createOnlineIndexProxy(this.UNIQUE_INDEX.materialise(10L));
        FlippableIndexProxy flipper = (FlippableIndexProxy)proxy.getDelegate();
        Assertions.assertThat((Object)flipper.getDelegate()).isExactlyInstanceOf(TentativeConstraintIndexProxy.class);
        proxy.activate();
        Assertions.assertThat((Object)flipper.getDelegate()).isExactlyInstanceOf(OnlineIndexProxy.class);
    }

    @Test
    void populatingUniquenessIndexProxyWithOwningConstraintShouldFlipToOnline() throws FlipFailedKernelException {
        FlippableIndexProxy proxy = this.proxyAfterCompletedPopulation(this.UNIQUE_INDEX.materialise(10L).withOwningConstraintId(4L));
        Assertions.assertThat((Object)proxy.getDelegate()).isExactlyInstanceOf(OnlineIndexProxy.class);
    }

    @Test
    void populatingUniquenessIndexProxyWithoutOwningConstraintShouldFlipToTentative() throws FlipFailedKernelException, IndexActivationFailedKernelException {
        FlippableIndexProxy proxy = this.proxyAfterCompletedPopulation(this.UNIQUE_INDEX.materialise(10L));
        Assertions.assertThat((Object)proxy.getDelegate()).isExactlyInstanceOf(TentativeConstraintIndexProxy.class);
        proxy.activate();
        Assertions.assertThat((Object)proxy.getDelegate()).isExactlyInstanceOf(OnlineIndexProxy.class);
    }

    private FlippableIndexProxy proxyAfterCompletedPopulation(IndexDescriptor descriptor) throws FlipFailedKernelException {
        IndexProvider provider = this.newProvider();
        IndexProxyCreator creator = this.newCreator(provider);
        IndexPopulationJob job = this.newJob();
        ContractCheckingIndexProxy proxy = (ContractCheckingIndexProxy)creator.createPopulatingIndexProxy(descriptor, IndexMonitor.NO_MONITOR, job);
        FlippableIndexProxy flipper = (FlippableIndexProxy)proxy.getDelegate();
        flipper.flip(() -> true, (FailedIndexProxyFactory)Mockito.mock(FailedIndexProxyFactory.class));
        return flipper;
    }

    private IndexProvider newProvider() {
        IndexProvider provider = (IndexProvider)Mockito.mock(IndexProvider.class);
        Mockito.when((Object)provider.getProviderDescriptor()).thenReturn((Object)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR);
        try {
            Mockito.when((Object)provider.getOnlineAccessor((IndexDescriptor)ArgumentMatchers.any(), (IndexSamplingConfig)ArgumentMatchers.any(), (TokenNameLookup)ArgumentMatchers.any())).thenReturn((Object)((IndexAccessor)Mockito.mock(IndexAccessor.class)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return provider;
    }

    private IndexProxyCreator newCreator(IndexProvider provider) {
        return new IndexProxyCreator((IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class), (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), (IndexProviderMap)new MockIndexProviderMap(provider), (TokenNameLookup)new InMemoryTokens(), (LogProvider)Mockito.mock(LogProvider.class));
    }

    private IndexPopulationJob newJob() {
        return (IndexPopulationJob)Mockito.mock(IndexPopulationJob.class);
    }
}

