/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.neo4j.kernel.impl.index.schema.PhysicalToLogicalTokenChanges;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;

@Execution(value=ExecutionMode.CONCURRENT)
class PhysicalToLogicalTokenChangesTest {
    PhysicalToLogicalTokenChangesTest() {
    }

    @Test
    void shouldSeeSimpleAddition() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L));
    }

    @Test
    void shouldSeeSimpleRemoval() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L), PhysicalToLogicalTokenChangesTest.ids(new long[0]));
    }

    @Test
    void shouldSeeSomeAdded() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 5L), PhysicalToLogicalTokenChangesTest.ids(1L, 2L, 3L, 4L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(2L, 4L, 6L));
    }

    @Test
    void shouldSeeSomeRemoved() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 2L, 3L, 4L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 5L), PhysicalToLogicalTokenChangesTest.ids(2L, 4L, 6L), PhysicalToLogicalTokenChangesTest.ids(new long[0]));
    }

    @Test
    void shouldSeeSomeAddedAndSomeRemoved() {
        PhysicalToLogicalTokenChangesTest.convertAndAssert(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 4L, 6L), PhysicalToLogicalTokenChangesTest.ids(0L, 2L, 3L, 5L, 6L), PhysicalToLogicalTokenChangesTest.ids(1L, 4L), PhysicalToLogicalTokenChangesTest.ids(0L, 2L, 5L));
    }

    @Test
    void shouldFailOnNegativeInput() {
        this.assertIAE(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, -1L, 6L), PhysicalToLogicalTokenChangesTest.ids(new long[0]));
        this.assertIAE(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, -1L, 6L), PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 4L));
        this.assertIAE(PhysicalToLogicalTokenChangesTest.ids(new long[0]), PhysicalToLogicalTokenChangesTest.ids(1L, 3L, -1L, 6L));
        this.assertIAE(PhysicalToLogicalTokenChangesTest.ids(1L, 3L, 4L), PhysicalToLogicalTokenChangesTest.ids(1L, 3L, -1L, 6L));
    }

    private static void convertAndAssert(long[] before, long[] after, long[] expectedRemoved, long[] expectedAdded) {
        TokenIndexEntryUpdate update = TokenIndexEntryUpdate.change((long)0L, null, (long[])before, (long[])after);
        PhysicalToLogicalTokenChanges.LogicalTokenUpdates logicalTokenUpdates = PhysicalToLogicalTokenChanges.convertToAdditionsAndRemovals((TokenIndexEntryUpdate)update);
        Assertions.assertThat((long[])PhysicalToLogicalTokenChangesTest.truncate(logicalTokenUpdates.removals())).containsExactly(expectedRemoved);
        Assertions.assertThat((long[])PhysicalToLogicalTokenChangesTest.truncate(logicalTokenUpdates.additions())).containsExactly(expectedAdded);
    }

    private void assertIAE(long[] before, long[] after) {
        TokenIndexEntryUpdate update = TokenIndexEntryUpdate.change((long)0L, null, (long[])before, (long[])after);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> PhysicalToLogicalTokenChanges.convertToAdditionsAndRemovals((TokenIndexEntryUpdate)update)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected non-negative long value");
    }

    private static long[] truncate(long[] tokenIds) {
        int length = PhysicalToLogicalTokenChangesTest.actualLength(tokenIds);
        return length == tokenIds.length ? tokenIds : Arrays.copyOf(tokenIds, length);
    }

    private static int actualLength(long[] labels) {
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i] != -1L) continue;
            return i;
        }
        return labels.length;
    }

    private static long[] ids(long ... ids) {
        return ids;
    }
}

