/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.IndexKeyStateTest;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.RangeLayout;

public class RangeKeyStateTest
extends IndexKeyStateTest<RangeKey> {
    @Override
    boolean includePointTypesForComparisons() {
        return true;
    }

    @Override
    int getPointSerialisedSize(int dimensions) {
        if (dimensions == 2) {
            return 20;
        }
        if (dimensions == 3) {
            return 28;
        }
        throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
    }

    @Override
    int getArrayPointSerialisedSize(int dimensions) {
        if (dimensions == 2) {
            return 16;
        }
        if (dimensions == 3) {
            return 24;
        }
        throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
    }

    @Override
    IndexKeyStateTest.Layout<RangeKey> newLayout(int numberOfSlots) {
        final RangeLayout rangeLayout = new RangeLayout(numberOfSlots);
        return new IndexKeyStateTest.Layout<RangeKey>(){

            @Override
            public RangeKey newKey() {
                return rangeLayout.newKey();
            }

            @Override
            public void minimalSplitter(RangeKey left, RangeKey right, RangeKey into) {
                rangeLayout.minimalSplitter(left, right, into);
            }

            @Override
            public int compare(RangeKey k1, RangeKey k2) {
                return rangeLayout.compare((NativeIndexKey)k1, (NativeIndexKey)k2);
            }
        };
    }
}

