/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.IntSupplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ExtendWith(value={SoftAssertionsExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
abstract class SupportPartitionedScanTestSuite {
    protected static final Map<Query, Boolean> NO_SUPPORT = SupportPartitionedScanTestSuite.createNoSupport();
    @InjectSoftAssertions
    SoftAssertions softly;
    private final IndexCapability capability;
    private final Map<Query, Boolean> supported;

    SupportPartitionedScanTestSuite(IndexCapability capability, Map<Query, Boolean> supported) {
        this.capability = capability;
        this.supported = supported;
    }

    @Test
    final void throwOnEmptyQueries() {
        ((AbstractThrowableAssert)this.softly.assertThatThrownBy(() -> this.capability.supportPartitionedScan(new IndexQuery[0]), "require non empty queries", new Object[0]).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected non empty array");
    }

    @Test
    final void throwOnNullQueries() {
        ((AbstractThrowableAssert)this.softly.assertThatThrownBy(() -> this.capability.supportPartitionedScan(new IndexQuery[]{null, null}), "require all non-null queries", new Object[0]).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected array without null elements");
    }

    @Test
    final void testSupported() {
        this.supported.forEach((query, expected) -> ((BooleanAssert)this.softly.assertThat(this.capability.supportPartitionedScan(query.queries(SupportPartitionedScanTestSuite.idGenerator()))).as("PartitionedScan with query '%s', is %s expected to be supported", new Object[]{query, expected != false ? "" : "not"})).isEqualTo(expected));
    }

    protected static IntSupplier idGenerator() {
        return new IntSupplier(){
            private int i = 128;

            @Override
            public int getAsInt() {
                return ++this.i;
            }
        };
    }

    protected static Map<Query, Boolean> supports(Query ... queries) {
        EnumMap<Query, Boolean> supported = new EnumMap<Query, Boolean>(NO_SUPPORT);
        for (Query query : queries) {
            supported.put(query, true);
        }
        return supported;
    }

    private static Map<Query, Boolean> createNoSupport() {
        EnumMap<Query, Boolean> noSupport = new EnumMap<Query, Boolean>(Query.class);
        for (Query query : Query.values()) {
            noSupport.put(query, false);
        }
        return Collections.unmodifiableMap(noSupport);
    }

    protected static enum Query {
        TOKEN_LOOKUP(TokenPredicate::new),
        ALL_ENTRIES(id -> PropertyIndexQuery.allEntries()),
        EXISTS(PropertyIndexQuery::exists),
        EXACT_NUMBER(id -> PropertyIndexQuery.exact((int)id, (Object)999)),
        EXACT_NUMBER_ARRAY(id -> PropertyIndexQuery.exact((int)id, (Object)new int[]{-999, 999})),
        EXACT_TEXT(id -> PropertyIndexQuery.exact((int)id, (Object)"foo")),
        EXACT_TEXT_ARRAY(id -> PropertyIndexQuery.exact((int)id, (Object)new String[]{"foo", "bar"})),
        EXACT_GEOMETRY(id -> PropertyIndexQuery.exact((int)id, (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994807, 55.612088}))),
        EXACT_GEOMETRY_ARRAY(id -> PropertyIndexQuery.exact((int)id, (Object)new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.994807, 55.612088}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{-0.101008, 51.503773})})),
        EXACT_TEMPORAL(id -> PropertyIndexQuery.exact((int)id, (Object)ZonedDateTime.now())),
        EXACT_TEMPORAL_ARRAY(id -> PropertyIndexQuery.exact((int)id, (Object)new ZonedDateTime[]{ZonedDateTime.now(), ZonedDateTime.now().plusWeeks(2L)})),
        EXACT_BOOLEAN(id -> PropertyIndexQuery.exact((int)id, (Object)true)),
        EXACT_BOOLEAN_ARRAY(id -> PropertyIndexQuery.exact((int)id, (Object)new boolean[]{false, true})),
        RANGE_NUMBER(id -> PropertyIndexQuery.range((int)id, (Number)-1073741824, (boolean)true, (Number)0x3FFFFFFF, (boolean)false)),
        RANGE_NUMBER_ARRAY(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)new int[]{-999, -999}), (boolean)true, (Value)Values.of((Object)new int[]{999, 999}), (boolean)false)),
        RANGE_TEXT(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)"abc"), (boolean)true, (Value)Values.of((Object)"xyz"), (boolean)false)),
        RANGE_TEXT_ARRAY(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)new String[]{"abc", "def"}), (boolean)true, (Value)Values.of((Object)new String[]{"xyz", "uvw"}), (boolean)false)),
        RANGE_GEOMETRY(id -> PropertyIndexQuery.range((int)id, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), (boolean)true, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 90.0}), (boolean)true)),
        RANGE_GEOMETRY_ARRAY(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, 0.0})}), (boolean)true, (Value)Values.of((Object)new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 90.0}), Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{180.0, -90.0})}), (boolean)true)),
        RANGE_TEMPORAL(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC)), (boolean)false, (Value)Values.of((Object)ZonedDateTime.now()), (boolean)true)),
        RANGE_TEMPORAL_ARRAY(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)new ZonedDateTime[]{ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC), ZonedDateTime.now().minusWeeks(1L)}), (boolean)false, (Value)Values.of((Object)new ZonedDateTime[]{ZonedDateTime.now(), ZonedDateTime.now().plusWeeks(1L)}), (boolean)true)),
        RANGE_BOOLEAN(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)false), (boolean)true, (Value)Values.of((Object)true), (boolean)true)),
        RANGE_BOOLEAN_ARRAY(id -> PropertyIndexQuery.range((int)id, (Value)Values.of((Object)new boolean[]{false, true}), (boolean)true, (Value)Values.of((Object)new boolean[]{true, true}), (boolean)true)),
        STRING_PREFIX(id -> PropertyIndexQuery.stringPrefix((int)id, (TextValue)Values.utf8Value((String)"prefix"))),
        STRING_SUFFIX(id -> PropertyIndexQuery.stringSuffix((int)id, (TextValue)Values.utf8Value((String)"suffix"))),
        STRING_CONTAINS(id -> PropertyIndexQuery.stringContains((int)id, (TextValue)Values.utf8Value((String)"contains"))),
        COMPOSITE_TOKEN_LOOKUP_TOKEN_LOOKUP(TOKEN_LOOKUP, TOKEN_LOOKUP),
        COMPOSITE_TOKEN_LOOKUP_ALL_ENTRIES(TOKEN_LOOKUP, ALL_ENTRIES),
        COMPOSITE_TOKEN_LOOKUP_EXISTS(TOKEN_LOOKUP, EXISTS),
        COMPOSITE_TOKEN_LOOKUP_EXACT_NUMBER(TOKEN_LOOKUP, EXACT_NUMBER),
        COMPOSITE_TOKEN_LOOKUP_EXACT_NUMBER_ARRAY(TOKEN_LOOKUP, EXACT_NUMBER_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_EXACT_TEXT(TOKEN_LOOKUP, EXACT_TEXT),
        COMPOSITE_TOKEN_LOOKUP_EXACT_TEXT_ARRAY(TOKEN_LOOKUP, EXACT_TEXT_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_EXACT_GEOMETRY(TOKEN_LOOKUP, EXACT_GEOMETRY),
        COMPOSITE_TOKEN_LOOKUP_EXACT_GEOMETRY_ARRAY(TOKEN_LOOKUP, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_EXACT_TEMPORAL(TOKEN_LOOKUP, EXACT_TEMPORAL),
        COMPOSITE_TOKEN_LOOKUP_EXACT_TEMPORAL_ARRAY(TOKEN_LOOKUP, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_EXACT_BOOLEAN(TOKEN_LOOKUP, EXACT_BOOLEAN),
        COMPOSITE_TOKEN_LOOKUP_EXACT_BOOLEAN_ARRAY(TOKEN_LOOKUP, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_NUMBER(TOKEN_LOOKUP, RANGE_NUMBER),
        COMPOSITE_TOKEN_LOOKUP_RANGE_NUMBER_ARRAY(TOKEN_LOOKUP, RANGE_NUMBER_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_TEXT(TOKEN_LOOKUP, RANGE_TEXT),
        COMPOSITE_TOKEN_LOOKUP_RANGE_TEXT_ARRAY(TOKEN_LOOKUP, RANGE_TEXT_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_GEOMETRY(TOKEN_LOOKUP, RANGE_GEOMETRY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_GEOMETRY_ARRAY(TOKEN_LOOKUP, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_TEMPORAL(TOKEN_LOOKUP, RANGE_TEMPORAL),
        COMPOSITE_TOKEN_LOOKUP_RANGE_TEMPORAL_ARRAY(TOKEN_LOOKUP, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_RANGE_BOOLEAN(TOKEN_LOOKUP, RANGE_BOOLEAN),
        COMPOSITE_TOKEN_LOOKUP_RANGE_BOOLEAN_ARRAY(TOKEN_LOOKUP, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_TOKEN_LOOKUP_STRING_PREFIX(TOKEN_LOOKUP, STRING_PREFIX),
        COMPOSITE_TOKEN_LOOKUP_STRING_SUFFIX(TOKEN_LOOKUP, STRING_SUFFIX),
        COMPOSITE_ALL_ENTRIES_TOKEN_LOOKUP(ALL_ENTRIES, TOKEN_LOOKUP),
        COMPOSITE_ALL_ENTRIES_ALL_ENTRIES(ALL_ENTRIES, ALL_ENTRIES),
        COMPOSITE_ALL_ENTRIES_EXISTS(ALL_ENTRIES, EXISTS),
        COMPOSITE_ALL_ENTRIES_EXACT_NUMBER(ALL_ENTRIES, EXACT_NUMBER),
        COMPOSITE_ALL_ENTRIES_EXACT_NUMBER_ARRAY(ALL_ENTRIES, EXACT_NUMBER_ARRAY),
        COMPOSITE_ALL_ENTRIES_EXACT_TEXT(ALL_ENTRIES, EXACT_TEXT),
        COMPOSITE_ALL_ENTRIES_EXACT_TEXT_ARRAY(ALL_ENTRIES, EXACT_TEXT_ARRAY),
        COMPOSITE_ALL_ENTRIES_EXACT_GEOMETRY(ALL_ENTRIES, EXACT_GEOMETRY),
        COMPOSITE_ALL_ENTRIES_EXACT_GEOMETRY_ARRAY(ALL_ENTRIES, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_ALL_ENTRIES_EXACT_TEMPORAL(ALL_ENTRIES, EXACT_TEMPORAL),
        COMPOSITE_ALL_ENTRIES_EXACT_TEMPORAL_ARRAY(ALL_ENTRIES, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_ALL_ENTRIES_EXACT_BOOLEAN(ALL_ENTRIES, EXACT_BOOLEAN),
        COMPOSITE_ALL_ENTRIES_EXACT_BOOLEAN_ARRAY(ALL_ENTRIES, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_ALL_ENTRIES_RANGE_NUMBER(ALL_ENTRIES, RANGE_NUMBER),
        COMPOSITE_ALL_ENTRIES_RANGE_NUMBER_ARRAY(ALL_ENTRIES, RANGE_NUMBER_ARRAY),
        COMPOSITE_ALL_ENTRIES_RANGE_TEXT(ALL_ENTRIES, RANGE_TEXT),
        COMPOSITE_ALL_ENTRIES_RANGE_TEXT_ARRAY(ALL_ENTRIES, RANGE_TEXT_ARRAY),
        COMPOSITE_ALL_ENTRIES_RANGE_GEOMETRY(ALL_ENTRIES, RANGE_GEOMETRY),
        COMPOSITE_ALL_ENTRIES_RANGE_GEOMETRY_ARRAY(ALL_ENTRIES, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_ALL_ENTRIES_RANGE_TEMPORAL(ALL_ENTRIES, RANGE_TEMPORAL),
        COMPOSITE_ALL_ENTRIES_RANGE_TEMPORAL_ARRAY(ALL_ENTRIES, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_ALL_ENTRIES_RANGE_BOOLEAN(ALL_ENTRIES, RANGE_BOOLEAN),
        COMPOSITE_ALL_ENTRIES_RANGE_BOOLEAN_ARRAY(ALL_ENTRIES, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_ALL_ENTRIES_STRING_PREFIX(ALL_ENTRIES, STRING_PREFIX),
        COMPOSITE_ALL_ENTRIES_STRING_SUFFIX(ALL_ENTRIES, STRING_SUFFIX),
        COMPOSITE_ALL_ENTRIES_STRING_CONTAINS(ALL_ENTRIES, STRING_CONTAINS),
        COMPOSITE_TOKEN_LOOKUP_STRING_CONTAINS(TOKEN_LOOKUP, STRING_CONTAINS),
        COMPOSITE_EXISTS_TOKEN_LOOKUP(EXISTS, TOKEN_LOOKUP),
        COMPOSITE_EXISTS_ALL_ENTRIES(EXISTS, ALL_ENTRIES),
        COMPOSITE_EXISTS_EXISTS(EXISTS, EXISTS),
        COMPOSITE_EXISTS_EXACT_NUMBER(EXISTS, EXACT_NUMBER),
        COMPOSITE_EXISTS_EXACT_NUMBER_ARRAY(EXISTS, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXISTS_EXACT_TEXT(EXISTS, EXACT_TEXT),
        COMPOSITE_EXISTS_EXACT_TEXT_ARRAY(EXISTS, EXACT_TEXT_ARRAY),
        COMPOSITE_EXISTS_EXACT_GEOMETRY(EXISTS, EXACT_GEOMETRY),
        COMPOSITE_EXISTS_EXACT_GEOMETRY_ARRAY(EXISTS, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXISTS_EXACT_TEMPORAL(EXISTS, EXACT_TEMPORAL),
        COMPOSITE_EXISTS_EXACT_TEMPORAL_ARRAY(EXISTS, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXISTS_EXACT_BOOLEAN(EXISTS, EXACT_BOOLEAN),
        COMPOSITE_EXISTS_EXACT_BOOLEAN_ARRAY(EXISTS, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXISTS_RANGE_NUMBER(EXISTS, RANGE_NUMBER),
        COMPOSITE_EXISTS_RANGE_NUMBER_ARRAY(EXISTS, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXISTS_RANGE_TEXT(EXISTS, RANGE_TEXT),
        COMPOSITE_EXISTS_RANGE_TEXT_ARRAY(EXISTS, RANGE_TEXT_ARRAY),
        COMPOSITE_EXISTS_RANGE_GEOMETRY(EXISTS, RANGE_GEOMETRY),
        COMPOSITE_EXISTS_RANGE_GEOMETRY_ARRAY(EXISTS, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXISTS_RANGE_TEMPORAL(EXISTS, RANGE_TEMPORAL),
        COMPOSITE_EXISTS_RANGE_TEMPORAL_ARRAY(EXISTS, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXISTS_RANGE_BOOLEAN(EXISTS, RANGE_BOOLEAN),
        COMPOSITE_EXISTS_RANGE_BOOLEAN_ARRAY(EXISTS, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXISTS_STRING_PREFIX(EXISTS, STRING_PREFIX),
        COMPOSITE_EXISTS_STRING_SUFFIX(EXISTS, STRING_SUFFIX),
        COMPOSITE_EXISTS_STRING_CONTAINS(EXISTS, STRING_CONTAINS),
        COMPOSITE_EXACT_NUMBER_TOKEN_LOOKUP(EXACT_NUMBER, TOKEN_LOOKUP),
        COMPOSITE_EXACT_NUMBER_ALL_ENTRIES(EXACT_NUMBER, ALL_ENTRIES),
        COMPOSITE_EXACT_NUMBER_EXISTS(EXACT_NUMBER, EXISTS),
        COMPOSITE_EXACT_NUMBER_EXACT_NUMBER(EXACT_NUMBER, EXACT_NUMBER),
        COMPOSITE_EXACT_NUMBER_EXACT_NUMBER_ARRAY(EXACT_NUMBER, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_NUMBER_EXACT_TEXT(EXACT_NUMBER, EXACT_TEXT),
        COMPOSITE_EXACT_NUMBER_EXACT_TEXT_ARRAY(EXACT_NUMBER, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_NUMBER_EXACT_GEOMETRY(EXACT_NUMBER, EXACT_GEOMETRY),
        COMPOSITE_EXACT_NUMBER_EXACT_GEOMETRY_ARRAY(EXACT_NUMBER, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_NUMBER_EXACT_TEMPORAL(EXACT_NUMBER, EXACT_TEMPORAL),
        COMPOSITE_EXACT_NUMBER_EXACT_TEMPORAL_ARRAY(EXACT_NUMBER, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_NUMBER_EXACT_BOOLEAN(EXACT_NUMBER, EXACT_BOOLEAN),
        COMPOSITE_EXACT_NUMBER_EXACT_BOOLEAN_ARRAY(EXACT_NUMBER, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_NUMBER_RANGE_NUMBER(EXACT_NUMBER, RANGE_NUMBER),
        COMPOSITE_EXACT_NUMBER_RANGE_NUMBER_ARRAY(EXACT_NUMBER, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_NUMBER_RANGE_TEXT(EXACT_NUMBER, RANGE_TEXT),
        COMPOSITE_EXACT_NUMBER_RANGE_TEXT_ARRAY(EXACT_NUMBER, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_NUMBER_RANGE_GEOMETRY(EXACT_NUMBER, RANGE_GEOMETRY),
        COMPOSITE_EXACT_NUMBER_RANGE_GEOMETRY_ARRAY(EXACT_NUMBER, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_NUMBER_RANGE_TEMPORAL(EXACT_NUMBER, RANGE_TEMPORAL),
        COMPOSITE_EXACT_NUMBER_RANGE_TEMPORAL_ARRAY(EXACT_NUMBER, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_NUMBER_RANGE_BOOLEAN(EXACT_NUMBER, RANGE_BOOLEAN),
        COMPOSITE_EXACT_NUMBER_RANGE_BOOLEAN_ARRAY(EXACT_NUMBER, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_NUMBER_STRING_PREFIX(EXACT_NUMBER, STRING_PREFIX),
        COMPOSITE_EXACT_NUMBER_STRING_SUFFIX(EXACT_NUMBER, STRING_SUFFIX),
        COMPOSITE_EXACT_NUMBER_STRING_CONTAINS(EXACT_NUMBER, STRING_CONTAINS),
        COMPOSITE_EXACT_NUMBER_ARRAY_TOKEN_LOOKUP(EXACT_NUMBER_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_NUMBER_ARRAY_ALL_ENTRIES(EXACT_NUMBER_ARRAY, ALL_ENTRIES),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXISTS(EXACT_NUMBER_ARRAY, EXISTS),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_NUMBER(EXACT_NUMBER_ARRAY, EXACT_NUMBER),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_NUMBER_ARRAY(EXACT_NUMBER_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_TEXT(EXACT_NUMBER_ARRAY, EXACT_TEXT),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_TEXT_ARRAY(EXACT_NUMBER_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_GEOMETRY(EXACT_NUMBER_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_GEOMETRY_ARRAY(EXACT_NUMBER_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_TEMPORAL(EXACT_NUMBER_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_TEMPORAL_ARRAY(EXACT_NUMBER_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_BOOLEAN(EXACT_NUMBER_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_NUMBER_ARRAY_EXACT_BOOLEAN_ARRAY(EXACT_NUMBER_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_NUMBER(EXACT_NUMBER_ARRAY, RANGE_NUMBER),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_NUMBER_ARRAY(EXACT_NUMBER_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_TEXT(EXACT_NUMBER_ARRAY, RANGE_TEXT),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_TEXT_ARRAY(EXACT_NUMBER_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_GEOMETRY(EXACT_NUMBER_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_GEOMETRY_ARRAY(EXACT_NUMBER_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_TEMPORAL(EXACT_NUMBER_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_TEMPORAL_ARRAY(EXACT_NUMBER_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_BOOLEAN(EXACT_NUMBER_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_NUMBER_ARRAY_RANGE_BOOLEAN_ARRAY(EXACT_NUMBER_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_NUMBER_ARRAY_STRING_PREFIX(EXACT_NUMBER_ARRAY, STRING_PREFIX),
        COMPOSITE_EXACT_NUMBER_ARRAY_STRING_SUFFIX(EXACT_NUMBER_ARRAY, STRING_SUFFIX),
        COMPOSITE_EXACT_NUMBER_ARRAY_STRING_CONTAINS(EXACT_NUMBER_ARRAY, STRING_CONTAINS),
        COMPOSITE_EXACT_TEXT_TOKEN_LOOKUP(EXACT_TEXT, TOKEN_LOOKUP),
        COMPOSITE_EXACT_TEXT_ALL_ENTRIES(EXACT_TEXT, ALL_ENTRIES),
        COMPOSITE_EXACT_TEXT_EXISTS(EXACT_TEXT, EXISTS),
        COMPOSITE_EXACT_TEXT_EXACT_NUMBER(EXACT_TEXT, EXACT_NUMBER),
        COMPOSITE_EXACT_TEXT_EXACT_NUMBER_ARRAY(EXACT_TEXT, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEXT_EXACT_TEXT(EXACT_TEXT, EXACT_TEXT),
        COMPOSITE_EXACT_TEXT_EXACT_TEXT_ARRAY(EXACT_TEXT, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_TEXT_EXACT_GEOMETRY(EXACT_TEXT, EXACT_GEOMETRY),
        COMPOSITE_EXACT_TEXT_EXACT_GEOMETRY_ARRAY(EXACT_TEXT, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEXT_EXACT_TEMPORAL(EXACT_TEXT, EXACT_TEMPORAL),
        COMPOSITE_EXACT_TEXT_EXACT_TEMPORAL_ARRAY(EXACT_TEXT, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEXT_EXACT_BOOLEAN(EXACT_TEXT, EXACT_BOOLEAN),
        COMPOSITE_EXACT_TEXT_EXACT_BOOLEAN_ARRAY(EXACT_TEXT, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEXT_RANGE_NUMBER(EXACT_TEXT, RANGE_NUMBER),
        COMPOSITE_EXACT_TEXT_RANGE_NUMBER_ARRAY(EXACT_TEXT, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEXT_RANGE_TEXT(EXACT_TEXT, RANGE_TEXT),
        COMPOSITE_EXACT_TEXT_RANGE_TEXT_ARRAY(EXACT_TEXT, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_TEXT_RANGE_GEOMETRY(EXACT_TEXT, RANGE_GEOMETRY),
        COMPOSITE_EXACT_TEXT_RANGE_GEOMETRY_ARRAY(EXACT_TEXT, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEXT_RANGE_TEMPORAL(EXACT_TEXT, RANGE_TEMPORAL),
        COMPOSITE_EXACT_TEXT_RANGE_TEMPORAL_ARRAY(EXACT_TEXT, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEXT_RANGE_BOOLEAN(EXACT_TEXT, RANGE_BOOLEAN),
        COMPOSITE_EXACT_TEXT_RANGE_BOOLEAN_ARRAY(EXACT_TEXT, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEXT_STRING_PREFIX(EXACT_TEXT, STRING_PREFIX),
        COMPOSITE_EXACT_TEXT_STRING_SUFFIX(EXACT_TEXT, STRING_SUFFIX),
        COMPOSITE_EXACT_TEXT_STRING_CONTAINS(EXACT_TEXT, STRING_CONTAINS),
        COMPOSITE_EXACT_TEXT_ARRAY_TOKEN_LOOKUP(EXACT_TEXT_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_TEXT_ARRAY_ALL_ENTRIES(EXACT_TEXT_ARRAY, ALL_ENTRIES),
        COMPOSITE_EXACT_TEXT_ARRAY_EXISTS(EXACT_TEXT_ARRAY, EXISTS),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_NUMBER(EXACT_TEXT_ARRAY, EXACT_NUMBER),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_NUMBER_ARRAY(EXACT_TEXT_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_TEXT(EXACT_TEXT_ARRAY, EXACT_TEXT),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_TEXT_ARRAY(EXACT_TEXT_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_GEOMETRY(EXACT_TEXT_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_GEOMETRY_ARRAY(EXACT_TEXT_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_TEMPORAL(EXACT_TEXT_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_TEMPORAL_ARRAY(EXACT_TEXT_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_BOOLEAN(EXACT_TEXT_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_TEXT_ARRAY_EXACT_BOOLEAN_ARRAY(EXACT_TEXT_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_NUMBER(EXACT_TEXT_ARRAY, RANGE_NUMBER),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_NUMBER_ARRAY(EXACT_TEXT_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_TEXT(EXACT_TEXT_ARRAY, RANGE_TEXT),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_TEXT_ARRAY(EXACT_TEXT_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_GEOMETRY(EXACT_TEXT_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_GEOMETRY_ARRAY(EXACT_TEXT_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_TEMPORAL(EXACT_TEXT_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_TEMPORAL_ARRAY(EXACT_TEXT_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_BOOLEAN(EXACT_TEXT_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_TEXT_ARRAY_RANGE_BOOLEAN_ARRAY(EXACT_TEXT_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEXT_ARRAY_STRING_PREFIX(EXACT_TEXT_ARRAY, STRING_PREFIX),
        COMPOSITE_EXACT_TEXT_ARRAY_STRING_SUFFIX(EXACT_TEXT_ARRAY, STRING_SUFFIX),
        COMPOSITE_EXACT_TEXT_ARRAY_STRING_CONTAINS(EXACT_TEXT_ARRAY, STRING_CONTAINS),
        COMPOSITE_EXACT_GEOMETRY_TOKEN_LOOKUP(EXACT_GEOMETRY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_GEOMETRY_ALL_ENTRIES(EXACT_GEOMETRY, ALL_ENTRIES),
        COMPOSITE_EXACT_GEOMETRY_EXISTS(EXACT_GEOMETRY, EXISTS),
        COMPOSITE_EXACT_GEOMETRY_EXACT_NUMBER(EXACT_GEOMETRY, EXACT_NUMBER),
        COMPOSITE_EXACT_GEOMETRY_EXACT_NUMBER_ARRAY(EXACT_GEOMETRY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_EXACT_TEXT(EXACT_GEOMETRY, EXACT_TEXT),
        COMPOSITE_EXACT_GEOMETRY_EXACT_TEXT_ARRAY(EXACT_GEOMETRY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_EXACT_GEOMETRY(EXACT_GEOMETRY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_GEOMETRY_EXACT_GEOMETRY_ARRAY(EXACT_GEOMETRY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_EXACT_TEMPORAL(EXACT_GEOMETRY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_GEOMETRY_EXACT_TEMPORAL_ARRAY(EXACT_GEOMETRY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_EXACT_BOOLEAN(EXACT_GEOMETRY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_GEOMETRY_EXACT_BOOLEAN_ARRAY(EXACT_GEOMETRY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_NUMBER(EXACT_GEOMETRY, RANGE_NUMBER),
        COMPOSITE_EXACT_GEOMETRY_RANGE_NUMBER_ARRAY(EXACT_GEOMETRY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_TEXT(EXACT_GEOMETRY, RANGE_TEXT),
        COMPOSITE_EXACT_GEOMETRY_RANGE_TEXT_ARRAY(EXACT_GEOMETRY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_GEOMETRY(EXACT_GEOMETRY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_GEOMETRY_ARRAY(EXACT_GEOMETRY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_TEMPORAL(EXACT_GEOMETRY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_GEOMETRY_RANGE_TEMPORAL_ARRAY(EXACT_GEOMETRY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_RANGE_BOOLEAN(EXACT_GEOMETRY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_GEOMETRY_RANGE_BOOLEAN_ARRAY(EXACT_GEOMETRY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_STRING_PREFIX(EXACT_GEOMETRY, STRING_PREFIX),
        COMPOSITE_EXACT_GEOMETRY_STRING_SUFFIX(EXACT_GEOMETRY, STRING_SUFFIX),
        COMPOSITE_EXACT_GEOMETRY_STRING_CONTAINS(EXACT_GEOMETRY, STRING_CONTAINS),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_TOKEN_LOOKUP(EXACT_GEOMETRY_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_ALL_ENTRIES(EXACT_GEOMETRY_ARRAY, ALL_ENTRIES),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXISTS(EXACT_GEOMETRY_ARRAY, EXISTS),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_NUMBER(EXACT_GEOMETRY_ARRAY, EXACT_NUMBER),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_NUMBER_ARRAY(EXACT_GEOMETRY_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_TEXT(EXACT_GEOMETRY_ARRAY, EXACT_TEXT),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_TEXT_ARRAY(EXACT_GEOMETRY_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_GEOMETRY(EXACT_GEOMETRY_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_GEOMETRY_ARRAY(EXACT_GEOMETRY_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_TEMPORAL(EXACT_GEOMETRY_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_TEMPORAL_ARRAY(EXACT_GEOMETRY_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_BOOLEAN(EXACT_GEOMETRY_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_EXACT_BOOLEAN_ARRAY(EXACT_GEOMETRY_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_NUMBER(EXACT_GEOMETRY_ARRAY, RANGE_NUMBER),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_NUMBER_ARRAY(EXACT_GEOMETRY_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_TEXT(EXACT_GEOMETRY_ARRAY, RANGE_TEXT),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_TEXT_ARRAY(EXACT_GEOMETRY_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_GEOMETRY(EXACT_GEOMETRY_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_GEOMETRY_ARRAY(EXACT_GEOMETRY_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_TEMPORAL(EXACT_GEOMETRY_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_TEMPORAL_ARRAY(EXACT_GEOMETRY_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_BOOLEAN(EXACT_GEOMETRY_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_RANGE_BOOLEAN_ARRAY(EXACT_GEOMETRY_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_STRING_PREFIX(EXACT_GEOMETRY_ARRAY, STRING_PREFIX),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_STRING_SUFFIX(EXACT_GEOMETRY_ARRAY, STRING_SUFFIX),
        COMPOSITE_EXACT_GEOMETRY_ARRAY_STRING_CONTAINS(EXACT_GEOMETRY_ARRAY, STRING_CONTAINS),
        COMPOSITE_EXACT_TEMPORAL_TOKEN_LOOKUP(EXACT_TEMPORAL, TOKEN_LOOKUP),
        COMPOSITE_EXACT_TEMPORAL_ALL_ENTRIES(EXACT_TEMPORAL, ALL_ENTRIES),
        COMPOSITE_EXACT_TEMPORAL_EXISTS(EXACT_TEMPORAL, EXISTS),
        COMPOSITE_EXACT_TEMPORAL_EXACT_NUMBER(EXACT_TEMPORAL, EXACT_NUMBER),
        COMPOSITE_EXACT_TEMPORAL_EXACT_NUMBER_ARRAY(EXACT_TEMPORAL, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_EXACT_TEXT(EXACT_TEMPORAL, EXACT_TEXT),
        COMPOSITE_EXACT_TEMPORAL_EXACT_TEXT_ARRAY(EXACT_TEMPORAL, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_EXACT_GEOMETRY(EXACT_TEMPORAL, EXACT_GEOMETRY),
        COMPOSITE_EXACT_TEMPORAL_EXACT_GEOMETRY_ARRAY(EXACT_TEMPORAL, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_EXACT_TEMPORAL(EXACT_TEMPORAL, EXACT_TEMPORAL),
        COMPOSITE_EXACT_TEMPORAL_EXACT_TEMPORAL_ARRAY(EXACT_TEMPORAL, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_EXACT_BOOLEAN(EXACT_TEMPORAL, EXACT_BOOLEAN),
        COMPOSITE_EXACT_TEMPORAL_EXACT_BOOLEAN_ARRAY(EXACT_TEMPORAL, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_NUMBER(EXACT_TEMPORAL, RANGE_NUMBER),
        COMPOSITE_EXACT_TEMPORAL_RANGE_NUMBER_ARRAY(EXACT_TEMPORAL, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_TEXT(EXACT_TEMPORAL, RANGE_TEXT),
        COMPOSITE_EXACT_TEMPORAL_RANGE_TEXT_ARRAY(EXACT_TEMPORAL, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_GEOMETRY(EXACT_TEMPORAL, RANGE_GEOMETRY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_GEOMETRY_ARRAY(EXACT_TEMPORAL, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_TEMPORAL(EXACT_TEMPORAL, RANGE_TEMPORAL),
        COMPOSITE_EXACT_TEMPORAL_RANGE_TEMPORAL_ARRAY(EXACT_TEMPORAL, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_RANGE_BOOLEAN(EXACT_TEMPORAL, RANGE_BOOLEAN),
        COMPOSITE_EXACT_TEMPORAL_RANGE_BOOLEAN_ARRAY(EXACT_TEMPORAL, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_STRING_PREFIX(EXACT_TEMPORAL, STRING_PREFIX),
        COMPOSITE_EXACT_TEMPORAL_STRING_SUFFIX(EXACT_TEMPORAL, STRING_SUFFIX),
        COMPOSITE_EXACT_TEMPORAL_STRING_CONTAINS(EXACT_TEMPORAL, STRING_CONTAINS),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_TOKEN_LOOKUP(EXACT_TEMPORAL_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_ALL_ENTRIES(EXACT_TEMPORAL_ARRAY, ALL_ENTRIES),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXISTS(EXACT_TEMPORAL_ARRAY, EXISTS),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_NUMBER(EXACT_TEMPORAL_ARRAY, EXACT_NUMBER),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_NUMBER_ARRAY(EXACT_TEMPORAL_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_TEXT(EXACT_TEMPORAL_ARRAY, EXACT_TEXT),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_TEXT_ARRAY(EXACT_TEMPORAL_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_GEOMETRY(EXACT_TEMPORAL_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_GEOMETRY_ARRAY(EXACT_TEMPORAL_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_TEMPORAL(EXACT_TEMPORAL_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_TEMPORAL_ARRAY(EXACT_TEMPORAL_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_BOOLEAN(EXACT_TEMPORAL_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_EXACT_BOOLEAN_ARRAY(EXACT_TEMPORAL_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_NUMBER(EXACT_TEMPORAL_ARRAY, RANGE_NUMBER),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_NUMBER_ARRAY(EXACT_TEMPORAL_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_TEXT(EXACT_TEMPORAL_ARRAY, RANGE_TEXT),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_TEXT_ARRAY(EXACT_TEMPORAL_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_GEOMETRY(EXACT_TEMPORAL_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_GEOMETRY_ARRAY(EXACT_TEMPORAL_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_TEMPORAL(EXACT_TEMPORAL_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_TEMPORAL_ARRAY(EXACT_TEMPORAL_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_BOOLEAN(EXACT_TEMPORAL_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_RANGE_BOOLEAN_ARRAY(EXACT_TEMPORAL_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_STRING_PREFIX(EXACT_TEMPORAL_ARRAY, STRING_PREFIX),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_STRING_SUFFIX(EXACT_TEMPORAL_ARRAY, STRING_SUFFIX),
        COMPOSITE_EXACT_TEMPORAL_ARRAY_STRING_CONTAINS(EXACT_TEMPORAL_ARRAY, STRING_CONTAINS),
        COMPOSITE_EXACT_BOOLEAN_TOKEN_LOOKUP(EXACT_BOOLEAN, TOKEN_LOOKUP),
        COMPOSITE_EXACT_BOOLEAN_ALL_ENTRIES(EXACT_BOOLEAN, ALL_ENTRIES),
        COMPOSITE_EXACT_BOOLEAN_EXISTS(EXACT_BOOLEAN, EXISTS),
        COMPOSITE_EXACT_BOOLEAN_EXACT_NUMBER(EXACT_BOOLEAN, EXACT_NUMBER),
        COMPOSITE_EXACT_BOOLEAN_EXACT_NUMBER_ARRAY(EXACT_BOOLEAN, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_EXACT_TEXT(EXACT_BOOLEAN, EXACT_TEXT),
        COMPOSITE_EXACT_BOOLEAN_EXACT_TEXT_ARRAY(EXACT_BOOLEAN, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_EXACT_GEOMETRY(EXACT_BOOLEAN, EXACT_GEOMETRY),
        COMPOSITE_EXACT_BOOLEAN_EXACT_GEOMETRY_ARRAY(EXACT_BOOLEAN, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_EXACT_TEMPORAL(EXACT_BOOLEAN, EXACT_TEMPORAL),
        COMPOSITE_EXACT_BOOLEAN_EXACT_TEMPORAL_ARRAY(EXACT_BOOLEAN, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_EXACT_BOOLEAN(EXACT_BOOLEAN, EXACT_BOOLEAN),
        COMPOSITE_EXACT_BOOLEAN_EXACT_BOOLEAN_ARRAY(EXACT_BOOLEAN, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_NUMBER(EXACT_BOOLEAN, RANGE_NUMBER),
        COMPOSITE_EXACT_BOOLEAN_RANGE_NUMBER_ARRAY(EXACT_BOOLEAN, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_TEXT(EXACT_BOOLEAN, RANGE_TEXT),
        COMPOSITE_EXACT_BOOLEAN_RANGE_TEXT_ARRAY(EXACT_BOOLEAN, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_GEOMETRY(EXACT_BOOLEAN, RANGE_GEOMETRY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_GEOMETRY_ARRAY(EXACT_BOOLEAN, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_TEMPORAL(EXACT_BOOLEAN, RANGE_TEMPORAL),
        COMPOSITE_EXACT_BOOLEAN_RANGE_TEMPORAL_ARRAY(EXACT_BOOLEAN, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_RANGE_BOOLEAN(EXACT_BOOLEAN, RANGE_BOOLEAN),
        COMPOSITE_EXACT_BOOLEAN_RANGE_BOOLEAN_ARRAY(EXACT_BOOLEAN, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_STRING_PREFIX(EXACT_BOOLEAN, STRING_PREFIX),
        COMPOSITE_EXACT_BOOLEAN_STRING_SUFFIX(EXACT_BOOLEAN, STRING_SUFFIX),
        COMPOSITE_EXACT_BOOLEAN_STRING_CONTAINS(EXACT_BOOLEAN, STRING_CONTAINS),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_TOKEN_LOOKUP(EXACT_BOOLEAN_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_ALL_ENTRIES(EXACT_BOOLEAN_ARRAY, ALL_ENTRIES),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXISTS(EXACT_BOOLEAN_ARRAY, EXISTS),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_NUMBER(EXACT_BOOLEAN_ARRAY, EXACT_NUMBER),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_NUMBER_ARRAY(EXACT_BOOLEAN_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_TEXT(EXACT_BOOLEAN_ARRAY, EXACT_TEXT),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_TEXT_ARRAY(EXACT_BOOLEAN_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_GEOMETRY(EXACT_BOOLEAN_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_GEOMETRY_ARRAY(EXACT_BOOLEAN_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_TEMPORAL(EXACT_BOOLEAN_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_TEMPORAL_ARRAY(EXACT_BOOLEAN_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_BOOLEAN(EXACT_BOOLEAN_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_EXACT_BOOLEAN_ARRAY(EXACT_BOOLEAN_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_NUMBER(EXACT_BOOLEAN_ARRAY, RANGE_NUMBER),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_NUMBER_ARRAY(EXACT_BOOLEAN_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_TEXT(EXACT_BOOLEAN_ARRAY, RANGE_TEXT),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_TEXT_ARRAY(EXACT_BOOLEAN_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_GEOMETRY(EXACT_BOOLEAN_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_GEOMETRY_ARRAY(EXACT_BOOLEAN_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_TEMPORAL(EXACT_BOOLEAN_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_TEMPORAL_ARRAY(EXACT_BOOLEAN_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_BOOLEAN(EXACT_BOOLEAN_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_RANGE_BOOLEAN_ARRAY(EXACT_BOOLEAN_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_STRING_PREFIX(EXACT_BOOLEAN_ARRAY, STRING_PREFIX),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_STRING_SUFFIX(EXACT_BOOLEAN_ARRAY, STRING_SUFFIX),
        COMPOSITE_EXACT_BOOLEAN_ARRAY_STRING_CONTAINS(EXACT_BOOLEAN_ARRAY, STRING_CONTAINS),
        COMPOSITE_RANGE_NUMBER_TOKEN_LOOKUP(RANGE_NUMBER, TOKEN_LOOKUP),
        COMPOSITE_RANGE_NUMBER_ALL_ENTRIES(RANGE_NUMBER, ALL_ENTRIES),
        COMPOSITE_RANGE_NUMBER_EXISTS(RANGE_NUMBER, EXISTS),
        COMPOSITE_RANGE_NUMBER_EXACT_NUMBER(RANGE_NUMBER, EXACT_NUMBER),
        COMPOSITE_RANGE_NUMBER_EXACT_NUMBER_ARRAY(RANGE_NUMBER, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_NUMBER_EXACT_TEXT(RANGE_NUMBER, EXACT_TEXT),
        COMPOSITE_RANGE_NUMBER_EXACT_TEXT_ARRAY(RANGE_NUMBER, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_NUMBER_EXACT_GEOMETRY(RANGE_NUMBER, EXACT_GEOMETRY),
        COMPOSITE_RANGE_NUMBER_EXACT_GEOMETRY_ARRAY(RANGE_NUMBER, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_NUMBER_EXACT_TEMPORAL(RANGE_NUMBER, EXACT_TEMPORAL),
        COMPOSITE_RANGE_NUMBER_EXACT_TEMPORAL_ARRAY(RANGE_NUMBER, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_NUMBER_EXACT_BOOLEAN(RANGE_NUMBER, EXACT_BOOLEAN),
        COMPOSITE_RANGE_NUMBER_EXACT_BOOLEAN_ARRAY(RANGE_NUMBER, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_NUMBER_RANGE_NUMBER(RANGE_NUMBER, RANGE_NUMBER),
        COMPOSITE_RANGE_NUMBER_RANGE_NUMBER_ARRAY(RANGE_NUMBER, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_NUMBER_RANGE_TEXT(RANGE_NUMBER, RANGE_TEXT),
        COMPOSITE_RANGE_NUMBER_RANGE_TEXT_ARRAY(RANGE_NUMBER, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_NUMBER_RANGE_GEOMETRY(RANGE_NUMBER, RANGE_GEOMETRY),
        COMPOSITE_RANGE_NUMBER_RANGE_GEOMETRY_ARRAY(RANGE_NUMBER, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_NUMBER_RANGE_TEMPORAL(RANGE_NUMBER, RANGE_TEMPORAL),
        COMPOSITE_RANGE_NUMBER_RANGE_TEMPORAL_ARRAY(RANGE_NUMBER, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_NUMBER_RANGE_BOOLEAN(RANGE_NUMBER, RANGE_BOOLEAN),
        COMPOSITE_RANGE_NUMBER_RANGE_BOOLEAN_ARRAY(RANGE_NUMBER, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_NUMBER_STRING_PREFIX(RANGE_NUMBER, STRING_PREFIX),
        COMPOSITE_RANGE_NUMBER_STRING_SUFFIX(RANGE_NUMBER, STRING_SUFFIX),
        COMPOSITE_RANGE_NUMBER_STRING_CONTAINS(RANGE_NUMBER, STRING_CONTAINS),
        COMPOSITE_RANGE_NUMBER_ARRAY_TOKEN_LOOKUP(RANGE_NUMBER_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_NUMBER_ARRAY_ALL_ENTRIES(RANGE_NUMBER_ARRAY, ALL_ENTRIES),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXISTS(RANGE_NUMBER_ARRAY, EXISTS),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_NUMBER(RANGE_NUMBER_ARRAY, EXACT_NUMBER),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_NUMBER_ARRAY(RANGE_NUMBER_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_TEXT(RANGE_NUMBER_ARRAY, EXACT_TEXT),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_TEXT_ARRAY(RANGE_NUMBER_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_GEOMETRY(RANGE_NUMBER_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_GEOMETRY_ARRAY(RANGE_NUMBER_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_TEMPORAL(RANGE_NUMBER_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_TEMPORAL_ARRAY(RANGE_NUMBER_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_BOOLEAN(RANGE_NUMBER_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_NUMBER_ARRAY_EXACT_BOOLEAN_ARRAY(RANGE_NUMBER_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_NUMBER(RANGE_NUMBER_ARRAY, RANGE_NUMBER),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_NUMBER_ARRAY(RANGE_NUMBER_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_TEXT(RANGE_NUMBER_ARRAY, RANGE_TEXT),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_TEXT_ARRAY(RANGE_NUMBER_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_GEOMETRY(RANGE_NUMBER_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_GEOMETRY_ARRAY(RANGE_NUMBER_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_TEMPORAL(RANGE_NUMBER_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_TEMPORAL_ARRAY(RANGE_NUMBER_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_BOOLEAN(RANGE_NUMBER_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_NUMBER_ARRAY_RANGE_BOOLEAN_ARRAY(RANGE_NUMBER_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_NUMBER_ARRAY_STRING_PREFIX(RANGE_NUMBER_ARRAY, STRING_PREFIX),
        COMPOSITE_RANGE_NUMBER_ARRAY_STRING_SUFFIX(RANGE_NUMBER_ARRAY, STRING_SUFFIX),
        COMPOSITE_RANGE_NUMBER_ARRAY_STRING_CONTAINS(RANGE_NUMBER_ARRAY, STRING_CONTAINS),
        COMPOSITE_RANGE_TEXT_TOKEN_LOOKUP(RANGE_TEXT, TOKEN_LOOKUP),
        COMPOSITE_RANGE_TEXT_ALL_ENTRIES(RANGE_TEXT, ALL_ENTRIES),
        COMPOSITE_RANGE_TEXT_EXISTS(RANGE_TEXT, EXISTS),
        COMPOSITE_RANGE_TEXT_EXACT_NUMBER(RANGE_TEXT, EXACT_NUMBER),
        COMPOSITE_RANGE_TEXT_EXACT_NUMBER_ARRAY(RANGE_TEXT, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEXT_EXACT_TEXT(RANGE_TEXT, EXACT_TEXT),
        COMPOSITE_RANGE_TEXT_EXACT_TEXT_ARRAY(RANGE_TEXT, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_TEXT_EXACT_GEOMETRY(RANGE_TEXT, EXACT_GEOMETRY),
        COMPOSITE_RANGE_TEXT_EXACT_GEOMETRY_ARRAY(RANGE_TEXT, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEXT_EXACT_TEMPORAL(RANGE_TEXT, EXACT_TEMPORAL),
        COMPOSITE_RANGE_TEXT_EXACT_TEMPORAL_ARRAY(RANGE_TEXT, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEXT_EXACT_BOOLEAN(RANGE_TEXT, EXACT_BOOLEAN),
        COMPOSITE_RANGE_TEXT_EXACT_BOOLEAN_ARRAY(RANGE_TEXT, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEXT_RANGE_NUMBER(RANGE_TEXT, RANGE_NUMBER),
        COMPOSITE_RANGE_TEXT_RANGE_NUMBER_ARRAY(RANGE_TEXT, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEXT_RANGE_TEXT(RANGE_TEXT, RANGE_TEXT),
        COMPOSITE_RANGE_TEXT_RANGE_TEXT_ARRAY(RANGE_TEXT, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_TEXT_RANGE_GEOMETRY(RANGE_TEXT, RANGE_GEOMETRY),
        COMPOSITE_RANGE_TEXT_RANGE_GEOMETRY_ARRAY(RANGE_TEXT, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEXT_RANGE_TEMPORAL(RANGE_TEXT, RANGE_TEMPORAL),
        COMPOSITE_RANGE_TEXT_RANGE_TEMPORAL_ARRAY(RANGE_TEXT, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEXT_RANGE_BOOLEAN(RANGE_TEXT, RANGE_BOOLEAN),
        COMPOSITE_RANGE_TEXT_RANGE_BOOLEAN_ARRAY(RANGE_TEXT, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEXT_STRING_PREFIX(RANGE_TEXT, STRING_PREFIX),
        COMPOSITE_RANGE_TEXT_STRING_SUFFIX(RANGE_TEXT, STRING_SUFFIX),
        COMPOSITE_RANGE_TEXT_STRING_CONTAINS(RANGE_TEXT, STRING_CONTAINS),
        COMPOSITE_RANGE_TEXT_ARRAY_TOKEN_LOOKUP(RANGE_TEXT_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_TEXT_ARRAY_ALL_ENTRIES(RANGE_TEXT_ARRAY, ALL_ENTRIES),
        COMPOSITE_RANGE_TEXT_ARRAY_EXISTS(RANGE_TEXT_ARRAY, EXISTS),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_NUMBER(RANGE_TEXT_ARRAY, EXACT_NUMBER),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_NUMBER_ARRAY(RANGE_TEXT_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_TEXT(RANGE_TEXT_ARRAY, EXACT_TEXT),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_TEXT_ARRAY(RANGE_TEXT_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_GEOMETRY(RANGE_TEXT_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_GEOMETRY_ARRAY(RANGE_TEXT_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_TEMPORAL(RANGE_TEXT_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_TEMPORAL_ARRAY(RANGE_TEXT_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_BOOLEAN(RANGE_TEXT_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_TEXT_ARRAY_EXACT_BOOLEAN_ARRAY(RANGE_TEXT_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_NUMBER(RANGE_TEXT_ARRAY, RANGE_NUMBER),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_NUMBER_ARRAY(RANGE_TEXT_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_TEXT(RANGE_TEXT_ARRAY, RANGE_TEXT),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_TEXT_ARRAY(RANGE_TEXT_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_GEOMETRY(RANGE_TEXT_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_GEOMETRY_ARRAY(RANGE_TEXT_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_TEMPORAL(RANGE_TEXT_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_TEMPORAL_ARRAY(RANGE_TEXT_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_BOOLEAN(RANGE_TEXT_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_TEXT_ARRAY_RANGE_BOOLEAN_ARRAY(RANGE_TEXT_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEXT_ARRAY_STRING_PREFIX(RANGE_TEXT_ARRAY, STRING_PREFIX),
        COMPOSITE_RANGE_TEXT_ARRAY_STRING_SUFFIX(RANGE_TEXT_ARRAY, STRING_SUFFIX),
        COMPOSITE_RANGE_TEXT_ARRAY_STRING_CONTAINS(RANGE_TEXT_ARRAY, STRING_CONTAINS),
        COMPOSITE_RANGE_GEOMETRY_TOKEN_LOOKUP(RANGE_GEOMETRY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_GEOMETRY_ALL_ENTRIES(RANGE_GEOMETRY, ALL_ENTRIES),
        COMPOSITE_RANGE_GEOMETRY_EXISTS(RANGE_GEOMETRY, EXISTS),
        COMPOSITE_RANGE_GEOMETRY_EXACT_NUMBER(RANGE_GEOMETRY, EXACT_NUMBER),
        COMPOSITE_RANGE_GEOMETRY_EXACT_NUMBER_ARRAY(RANGE_GEOMETRY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_EXACT_TEXT(RANGE_GEOMETRY, EXACT_TEXT),
        COMPOSITE_RANGE_GEOMETRY_EXACT_TEXT_ARRAY(RANGE_GEOMETRY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_EXACT_GEOMETRY(RANGE_GEOMETRY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_GEOMETRY_EXACT_GEOMETRY_ARRAY(RANGE_GEOMETRY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_EXACT_TEMPORAL(RANGE_GEOMETRY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_GEOMETRY_EXACT_TEMPORAL_ARRAY(RANGE_GEOMETRY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_EXACT_BOOLEAN(RANGE_GEOMETRY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_GEOMETRY_EXACT_BOOLEAN_ARRAY(RANGE_GEOMETRY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_NUMBER(RANGE_GEOMETRY, RANGE_NUMBER),
        COMPOSITE_RANGE_GEOMETRY_RANGE_NUMBER_ARRAY(RANGE_GEOMETRY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_TEXT(RANGE_GEOMETRY, RANGE_TEXT),
        COMPOSITE_RANGE_GEOMETRY_RANGE_TEXT_ARRAY(RANGE_GEOMETRY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_GEOMETRY(RANGE_GEOMETRY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_GEOMETRY_ARRAY(RANGE_GEOMETRY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_TEMPORAL(RANGE_GEOMETRY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_GEOMETRY_RANGE_TEMPORAL_ARRAY(RANGE_GEOMETRY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_RANGE_BOOLEAN(RANGE_GEOMETRY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_GEOMETRY_RANGE_BOOLEAN_ARRAY(RANGE_GEOMETRY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_STRING_PREFIX(RANGE_GEOMETRY, STRING_PREFIX),
        COMPOSITE_RANGE_GEOMETRY_STRING_SUFFIX(RANGE_GEOMETRY, STRING_SUFFIX),
        COMPOSITE_RANGE_GEOMETRY_STRING_CONTAINS(RANGE_GEOMETRY, STRING_CONTAINS),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_TOKEN_LOOKUP(RANGE_GEOMETRY_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_ALL_ENTRIES(RANGE_GEOMETRY_ARRAY, ALL_ENTRIES),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXISTS(RANGE_GEOMETRY_ARRAY, EXISTS),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_NUMBER(RANGE_GEOMETRY_ARRAY, EXACT_NUMBER),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_NUMBER_ARRAY(RANGE_GEOMETRY_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_TEXT(RANGE_GEOMETRY_ARRAY, EXACT_TEXT),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_TEXT_ARRAY(RANGE_GEOMETRY_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_GEOMETRY(RANGE_GEOMETRY_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_GEOMETRY_ARRAY(RANGE_GEOMETRY_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_TEMPORAL(RANGE_GEOMETRY_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_TEMPORAL_ARRAY(RANGE_GEOMETRY_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_BOOLEAN(RANGE_GEOMETRY_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_EXACT_BOOLEAN_ARRAY(RANGE_GEOMETRY_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_NUMBER(RANGE_GEOMETRY_ARRAY, RANGE_NUMBER),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_NUMBER_ARRAY(RANGE_GEOMETRY_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_TEXT(RANGE_GEOMETRY_ARRAY, RANGE_TEXT),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_TEXT_ARRAY(RANGE_GEOMETRY_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_GEOMETRY(RANGE_GEOMETRY_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_GEOMETRY_ARRAY(RANGE_GEOMETRY_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_TEMPORAL(RANGE_GEOMETRY_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_TEMPORAL_ARRAY(RANGE_GEOMETRY_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_BOOLEAN(RANGE_GEOMETRY_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_RANGE_BOOLEAN_ARRAY(RANGE_GEOMETRY_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_STRING_PREFIX(RANGE_GEOMETRY_ARRAY, STRING_PREFIX),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_STRING_SUFFIX(RANGE_GEOMETRY_ARRAY, STRING_SUFFIX),
        COMPOSITE_RANGE_GEOMETRY_ARRAY_STRING_CONTAINS(RANGE_GEOMETRY_ARRAY, STRING_CONTAINS),
        COMPOSITE_RANGE_TEMPORAL_TOKEN_LOOKUP(RANGE_TEMPORAL, TOKEN_LOOKUP),
        COMPOSITE_RANGE_TEMPORAL_ALL_ENTRIES(RANGE_TEMPORAL, ALL_ENTRIES),
        COMPOSITE_RANGE_TEMPORAL_EXISTS(RANGE_TEMPORAL, EXISTS),
        COMPOSITE_RANGE_TEMPORAL_EXACT_NUMBER(RANGE_TEMPORAL, EXACT_NUMBER),
        COMPOSITE_RANGE_TEMPORAL_EXACT_NUMBER_ARRAY(RANGE_TEMPORAL, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_EXACT_TEXT(RANGE_TEMPORAL, EXACT_TEXT),
        COMPOSITE_RANGE_TEMPORAL_EXACT_TEXT_ARRAY(RANGE_TEMPORAL, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_EXACT_GEOMETRY(RANGE_TEMPORAL, EXACT_GEOMETRY),
        COMPOSITE_RANGE_TEMPORAL_EXACT_GEOMETRY_ARRAY(RANGE_TEMPORAL, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_EXACT_TEMPORAL(RANGE_TEMPORAL, EXACT_TEMPORAL),
        COMPOSITE_RANGE_TEMPORAL_EXACT_TEMPORAL_ARRAY(RANGE_TEMPORAL, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_EXACT_BOOLEAN(RANGE_TEMPORAL, EXACT_BOOLEAN),
        COMPOSITE_RANGE_TEMPORAL_EXACT_BOOLEAN_ARRAY(RANGE_TEMPORAL, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_NUMBER(RANGE_TEMPORAL, RANGE_NUMBER),
        COMPOSITE_RANGE_TEMPORAL_RANGE_NUMBER_ARRAY(RANGE_TEMPORAL, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_TEXT(RANGE_TEMPORAL, RANGE_TEXT),
        COMPOSITE_RANGE_TEMPORAL_RANGE_TEXT_ARRAY(RANGE_TEMPORAL, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_GEOMETRY(RANGE_TEMPORAL, RANGE_GEOMETRY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_GEOMETRY_ARRAY(RANGE_TEMPORAL, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_TEMPORAL(RANGE_TEMPORAL, RANGE_TEMPORAL),
        COMPOSITE_RANGE_TEMPORAL_RANGE_TEMPORAL_ARRAY(RANGE_TEMPORAL, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_RANGE_BOOLEAN(RANGE_TEMPORAL, RANGE_BOOLEAN),
        COMPOSITE_RANGE_TEMPORAL_RANGE_BOOLEAN_ARRAY(RANGE_TEMPORAL, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_STRING_PREFIX(RANGE_TEMPORAL, STRING_PREFIX),
        COMPOSITE_RANGE_TEMPORAL_STRING_SUFFIX(RANGE_TEMPORAL, STRING_SUFFIX),
        COMPOSITE_RANGE_TEMPORAL_STRING_CONTAINS(RANGE_TEMPORAL, STRING_CONTAINS),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_TOKEN_LOOKUP(RANGE_TEMPORAL_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_ALL_ENTRIES(RANGE_TEMPORAL_ARRAY, ALL_ENTRIES),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXISTS(RANGE_TEMPORAL_ARRAY, EXISTS),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_NUMBER(RANGE_TEMPORAL_ARRAY, EXACT_NUMBER),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_NUMBER_ARRAY(RANGE_TEMPORAL_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_TEXT(RANGE_TEMPORAL_ARRAY, EXACT_TEXT),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_TEXT_ARRAY(RANGE_TEMPORAL_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_GEOMETRY(RANGE_TEMPORAL_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_GEOMETRY_ARRAY(RANGE_TEMPORAL_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_TEMPORAL(RANGE_TEMPORAL_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_TEMPORAL_ARRAY(RANGE_TEMPORAL_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_BOOLEAN(RANGE_TEMPORAL_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_EXACT_BOOLEAN_ARRAY(RANGE_TEMPORAL_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_NUMBER(RANGE_TEMPORAL_ARRAY, RANGE_NUMBER),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_NUMBER_ARRAY(RANGE_TEMPORAL_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_TEXT(RANGE_TEMPORAL_ARRAY, RANGE_TEXT),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_TEXT_ARRAY(RANGE_TEMPORAL_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_GEOMETRY(RANGE_TEMPORAL_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_GEOMETRY_ARRAY(RANGE_TEMPORAL_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_TEMPORAL(RANGE_TEMPORAL_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_TEMPORAL_ARRAY(RANGE_TEMPORAL_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_BOOLEAN(RANGE_TEMPORAL_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_RANGE_BOOLEAN_ARRAY(RANGE_TEMPORAL_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_STRING_PREFIX(RANGE_TEMPORAL_ARRAY, STRING_PREFIX),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_STRING_SUFFIX(RANGE_TEMPORAL_ARRAY, STRING_SUFFIX),
        COMPOSITE_RANGE_TEMPORAL_ARRAY_STRING_CONTAINS(RANGE_TEMPORAL_ARRAY, STRING_CONTAINS),
        COMPOSITE_RANGE_BOOLEAN_TOKEN_LOOKUP(RANGE_BOOLEAN, TOKEN_LOOKUP),
        COMPOSITE_RANGE_BOOLEAN_ALL_ENTRIES(RANGE_BOOLEAN, ALL_ENTRIES),
        COMPOSITE_RANGE_BOOLEAN_EXISTS(RANGE_BOOLEAN, EXISTS),
        COMPOSITE_RANGE_BOOLEAN_EXACT_NUMBER(RANGE_BOOLEAN, EXACT_NUMBER),
        COMPOSITE_RANGE_BOOLEAN_EXACT_NUMBER_ARRAY(RANGE_BOOLEAN, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_EXACT_TEXT(RANGE_BOOLEAN, EXACT_TEXT),
        COMPOSITE_RANGE_BOOLEAN_EXACT_TEXT_ARRAY(RANGE_BOOLEAN, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_EXACT_GEOMETRY(RANGE_BOOLEAN, EXACT_GEOMETRY),
        COMPOSITE_RANGE_BOOLEAN_EXACT_GEOMETRY_ARRAY(RANGE_BOOLEAN, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_EXACT_TEMPORAL(RANGE_BOOLEAN, EXACT_TEMPORAL),
        COMPOSITE_RANGE_BOOLEAN_EXACT_TEMPORAL_ARRAY(RANGE_BOOLEAN, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_EXACT_BOOLEAN(RANGE_BOOLEAN, EXACT_BOOLEAN),
        COMPOSITE_RANGE_BOOLEAN_EXACT_BOOLEAN_ARRAY(RANGE_BOOLEAN, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_NUMBER(RANGE_BOOLEAN, RANGE_NUMBER),
        COMPOSITE_RANGE_BOOLEAN_RANGE_NUMBER_ARRAY(RANGE_BOOLEAN, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_TEXT(RANGE_BOOLEAN, RANGE_TEXT),
        COMPOSITE_RANGE_BOOLEAN_RANGE_TEXT_ARRAY(RANGE_BOOLEAN, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_GEOMETRY(RANGE_BOOLEAN, RANGE_GEOMETRY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_GEOMETRY_ARRAY(RANGE_BOOLEAN, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_TEMPORAL(RANGE_BOOLEAN, RANGE_TEMPORAL),
        COMPOSITE_RANGE_BOOLEAN_RANGE_TEMPORAL_ARRAY(RANGE_BOOLEAN, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_RANGE_BOOLEAN(RANGE_BOOLEAN, RANGE_BOOLEAN),
        COMPOSITE_RANGE_BOOLEAN_RANGE_BOOLEAN_ARRAY(RANGE_BOOLEAN, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_STRING_PREFIX(RANGE_BOOLEAN, STRING_PREFIX),
        COMPOSITE_RANGE_BOOLEAN_STRING_SUFFIX(RANGE_BOOLEAN, STRING_SUFFIX),
        COMPOSITE_RANGE_BOOLEAN_STRING_CONTAINS(RANGE_BOOLEAN, STRING_CONTAINS),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_TOKEN_LOOKUP(RANGE_BOOLEAN_ARRAY, TOKEN_LOOKUP),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_ALL_ENTRIES(RANGE_BOOLEAN_ARRAY, ALL_ENTRIES),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXISTS(RANGE_BOOLEAN_ARRAY, EXISTS),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_NUMBER(RANGE_BOOLEAN_ARRAY, EXACT_NUMBER),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_NUMBER_ARRAY(RANGE_BOOLEAN_ARRAY, EXACT_NUMBER_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_TEXT(RANGE_BOOLEAN_ARRAY, EXACT_TEXT),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_TEXT_ARRAY(RANGE_BOOLEAN_ARRAY, EXACT_TEXT_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_GEOMETRY(RANGE_BOOLEAN_ARRAY, EXACT_GEOMETRY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_GEOMETRY_ARRAY(RANGE_BOOLEAN_ARRAY, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_TEMPORAL(RANGE_BOOLEAN_ARRAY, EXACT_TEMPORAL),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_TEMPORAL_ARRAY(RANGE_BOOLEAN_ARRAY, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_BOOLEAN(RANGE_BOOLEAN_ARRAY, EXACT_BOOLEAN),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_EXACT_BOOLEAN_ARRAY(RANGE_BOOLEAN_ARRAY, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_NUMBER(RANGE_BOOLEAN_ARRAY, RANGE_NUMBER),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_NUMBER_ARRAY(RANGE_BOOLEAN_ARRAY, RANGE_NUMBER_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_TEXT(RANGE_BOOLEAN_ARRAY, RANGE_TEXT),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_TEXT_ARRAY(RANGE_BOOLEAN_ARRAY, RANGE_TEXT_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_GEOMETRY(RANGE_BOOLEAN_ARRAY, RANGE_GEOMETRY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_GEOMETRY_ARRAY(RANGE_BOOLEAN_ARRAY, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_TEMPORAL(RANGE_BOOLEAN_ARRAY, RANGE_TEMPORAL),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_TEMPORAL_ARRAY(RANGE_BOOLEAN_ARRAY, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_BOOLEAN(RANGE_BOOLEAN_ARRAY, RANGE_BOOLEAN),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_RANGE_BOOLEAN_ARRAY(RANGE_BOOLEAN_ARRAY, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_STRING_PREFIX(RANGE_BOOLEAN_ARRAY, STRING_PREFIX),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_STRING_SUFFIX(RANGE_BOOLEAN_ARRAY, STRING_SUFFIX),
        COMPOSITE_RANGE_BOOLEAN_ARRAY_STRING_CONTAINS(RANGE_BOOLEAN_ARRAY, STRING_CONTAINS),
        COMPOSITE_STRING_PREFIX_TOKEN_LOOKUP(STRING_PREFIX, TOKEN_LOOKUP),
        COMPOSITE_STRING_PREFIX_ALL_ENTRIES(STRING_PREFIX, ALL_ENTRIES),
        COMPOSITE_STRING_PREFIX_EXISTS(STRING_PREFIX, EXISTS),
        COMPOSITE_STRING_PREFIX_EXACT_NUMBER(STRING_PREFIX, EXACT_NUMBER),
        COMPOSITE_STRING_PREFIX_EXACT_NUMBER_ARRAY(STRING_PREFIX, EXACT_NUMBER_ARRAY),
        COMPOSITE_STRING_PREFIX_EXACT_TEXT(STRING_PREFIX, EXACT_TEXT),
        COMPOSITE_STRING_PREFIX_EXACT_TEXT_ARRAY(STRING_PREFIX, EXACT_TEXT_ARRAY),
        COMPOSITE_STRING_PREFIX_EXACT_GEOMETRY(STRING_PREFIX, EXACT_GEOMETRY),
        COMPOSITE_STRING_PREFIX_EXACT_GEOMETRY_ARRAY(STRING_PREFIX, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_STRING_PREFIX_EXACT_TEMPORAL(STRING_PREFIX, EXACT_TEMPORAL),
        COMPOSITE_STRING_PREFIX_EXACT_TEMPORAL_ARRAY(STRING_PREFIX, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_STRING_PREFIX_EXACT_BOOLEAN(STRING_PREFIX, EXACT_BOOLEAN),
        COMPOSITE_STRING_PREFIX_EXACT_BOOLEAN_ARRAY(STRING_PREFIX, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_STRING_PREFIX_RANGE_NUMBER(STRING_PREFIX, RANGE_NUMBER),
        COMPOSITE_STRING_PREFIX_RANGE_NUMBER_ARRAY(STRING_PREFIX, RANGE_NUMBER_ARRAY),
        COMPOSITE_STRING_PREFIX_RANGE_TEXT(STRING_PREFIX, RANGE_TEXT),
        COMPOSITE_STRING_PREFIX_RANGE_TEXT_ARRAY(STRING_PREFIX, RANGE_TEXT_ARRAY),
        COMPOSITE_STRING_PREFIX_RANGE_GEOMETRY(STRING_PREFIX, RANGE_GEOMETRY),
        COMPOSITE_STRING_PREFIX_RANGE_GEOMETRY_ARRAY(STRING_PREFIX, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_STRING_PREFIX_RANGE_TEMPORAL(STRING_PREFIX, RANGE_TEMPORAL),
        COMPOSITE_STRING_PREFIX_RANGE_TEMPORAL_ARRAY(STRING_PREFIX, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_STRING_PREFIX_RANGE_BOOLEAN(STRING_PREFIX, RANGE_BOOLEAN),
        COMPOSITE_STRING_PREFIX_RANGE_BOOLEAN_ARRAY(STRING_PREFIX, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_STRING_PREFIX_STRING_PREFIX(STRING_PREFIX, STRING_PREFIX),
        COMPOSITE_STRING_PREFIX_STRING_SUFFIX(STRING_PREFIX, STRING_SUFFIX),
        COMPOSITE_STRING_PREFIX_STRING_CONTAINS(STRING_PREFIX, STRING_CONTAINS),
        COMPOSITE_STRING_SUFFIX_TOKEN_LOOKUP(STRING_SUFFIX, TOKEN_LOOKUP),
        COMPOSITE_STRING_SUFFIX_ALL_ENTRIES(STRING_SUFFIX, ALL_ENTRIES),
        COMPOSITE_STRING_SUFFIX_EXISTS(STRING_SUFFIX, EXISTS),
        COMPOSITE_STRING_SUFFIX_EXACT_NUMBER(STRING_SUFFIX, EXACT_NUMBER),
        COMPOSITE_STRING_SUFFIX_EXACT_NUMBER_ARRAY(STRING_SUFFIX, EXACT_NUMBER_ARRAY),
        COMPOSITE_STRING_SUFFIX_EXACT_TEXT(STRING_SUFFIX, EXACT_TEXT),
        COMPOSITE_STRING_SUFFIX_EXACT_TEXT_ARRAY(STRING_SUFFIX, EXACT_TEXT_ARRAY),
        COMPOSITE_STRING_SUFFIX_EXACT_GEOMETRY(STRING_SUFFIX, EXACT_GEOMETRY),
        COMPOSITE_STRING_SUFFIX_EXACT_GEOMETRY_ARRAY(STRING_SUFFIX, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_STRING_SUFFIX_EXACT_TEMPORAL(STRING_SUFFIX, EXACT_TEMPORAL),
        COMPOSITE_STRING_SUFFIX_EXACT_TEMPORAL_ARRAY(STRING_SUFFIX, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_STRING_SUFFIX_EXACT_BOOLEAN(STRING_SUFFIX, EXACT_BOOLEAN),
        COMPOSITE_STRING_SUFFIX_EXACT_BOOLEAN_ARRAY(STRING_SUFFIX, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_STRING_SUFFIX_RANGE_NUMBER(STRING_SUFFIX, RANGE_NUMBER),
        COMPOSITE_STRING_SUFFIX_RANGE_NUMBER_ARRAY(STRING_SUFFIX, RANGE_NUMBER_ARRAY),
        COMPOSITE_STRING_SUFFIX_RANGE_TEXT(STRING_SUFFIX, RANGE_TEXT),
        COMPOSITE_STRING_SUFFIX_RANGE_TEXT_ARRAY(STRING_SUFFIX, RANGE_TEXT_ARRAY),
        COMPOSITE_STRING_SUFFIX_RANGE_GEOMETRY(STRING_SUFFIX, RANGE_GEOMETRY),
        COMPOSITE_STRING_SUFFIX_RANGE_GEOMETRY_ARRAY(STRING_SUFFIX, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_STRING_SUFFIX_RANGE_TEMPORAL(STRING_SUFFIX, RANGE_TEMPORAL),
        COMPOSITE_STRING_SUFFIX_RANGE_TEMPORAL_ARRAY(STRING_SUFFIX, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_STRING_SUFFIX_RANGE_BOOLEAN(STRING_SUFFIX, RANGE_BOOLEAN),
        COMPOSITE_STRING_SUFFIX_RANGE_BOOLEAN_ARRAY(STRING_SUFFIX, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_STRING_SUFFIX_STRING_PREFIX(STRING_SUFFIX, STRING_PREFIX),
        COMPOSITE_STRING_SUFFIX_STRING_SUFFIX(STRING_SUFFIX, STRING_SUFFIX),
        COMPOSITE_STRING_SUFFIX_STRING_CONTAINS(STRING_SUFFIX, STRING_CONTAINS),
        COMPOSITE_STRING_CONTAINS_TOKEN_LOOKUP(STRING_CONTAINS, TOKEN_LOOKUP),
        COMPOSITE_STRING_CONTAINS_ALL_ENTRIES(STRING_CONTAINS, ALL_ENTRIES),
        COMPOSITE_STRING_CONTAINS_EXISTS(STRING_CONTAINS, EXISTS),
        COMPOSITE_STRING_CONTAINS_EXACT_NUMBER(STRING_CONTAINS, EXACT_NUMBER),
        COMPOSITE_STRING_CONTAINS_EXACT_NUMBER_ARRAY(STRING_CONTAINS, EXACT_NUMBER_ARRAY),
        COMPOSITE_STRING_CONTAINS_EXACT_TEXT(STRING_CONTAINS, EXACT_TEXT),
        COMPOSITE_STRING_CONTAINS_EXACT_TEXT_ARRAY(STRING_CONTAINS, EXACT_TEXT_ARRAY),
        COMPOSITE_STRING_CONTAINS_EXACT_GEOMETRY(STRING_CONTAINS, EXACT_GEOMETRY),
        COMPOSITE_STRING_CONTAINS_EXACT_GEOMETRY_ARRAY(STRING_CONTAINS, EXACT_GEOMETRY_ARRAY),
        COMPOSITE_STRING_CONTAINS_EXACT_TEMPORAL(STRING_CONTAINS, EXACT_TEMPORAL),
        COMPOSITE_STRING_CONTAINS_EXACT_TEMPORAL_ARRAY(STRING_CONTAINS, EXACT_TEMPORAL_ARRAY),
        COMPOSITE_STRING_CONTAINS_EXACT_BOOLEAN(STRING_CONTAINS, EXACT_BOOLEAN),
        COMPOSITE_STRING_CONTAINS_EXACT_BOOLEAN_ARRAY(STRING_CONTAINS, EXACT_BOOLEAN_ARRAY),
        COMPOSITE_STRING_CONTAINS_RANGE_NUMBER(STRING_CONTAINS, RANGE_NUMBER),
        COMPOSITE_STRING_CONTAINS_RANGE_NUMBER_ARRAY(STRING_CONTAINS, RANGE_NUMBER_ARRAY),
        COMPOSITE_STRING_CONTAINS_RANGE_TEXT(STRING_CONTAINS, RANGE_TEXT),
        COMPOSITE_STRING_CONTAINS_RANGE_TEXT_ARRAY(STRING_CONTAINS, RANGE_TEXT_ARRAY),
        COMPOSITE_STRING_CONTAINS_RANGE_GEOMETRY(STRING_CONTAINS, RANGE_GEOMETRY),
        COMPOSITE_STRING_CONTAINS_RANGE_GEOMETRY_ARRAY(STRING_CONTAINS, RANGE_GEOMETRY_ARRAY),
        COMPOSITE_STRING_CONTAINS_RANGE_TEMPORAL(STRING_CONTAINS, RANGE_TEMPORAL),
        COMPOSITE_STRING_CONTAINS_RANGE_TEMPORAL_ARRAY(STRING_CONTAINS, RANGE_TEMPORAL_ARRAY),
        COMPOSITE_STRING_CONTAINS_RANGE_BOOLEAN(STRING_CONTAINS, RANGE_BOOLEAN),
        COMPOSITE_STRING_CONTAINS_RANGE_BOOLEAN_ARRAY(STRING_CONTAINS, RANGE_BOOLEAN_ARRAY),
        COMPOSITE_STRING_CONTAINS_STRING_PREFIX(STRING_CONTAINS, STRING_PREFIX),
        COMPOSITE_STRING_CONTAINS_STRING_SUFFIX(STRING_CONTAINS, STRING_SUFFIX),
        COMPOSITE_STRING_CONTAINS_STRING_CONTAINS(STRING_CONTAINS, STRING_CONTAINS);

        private final IndexQueryFromId[] queryFromIds;

        private Query(IndexQueryFromId ... queryFromIds) {
            this.queryFromIds = queryFromIds;
        }

        private Query(Query ... queries) {
            this((IndexQueryFromId[])Arrays.stream(queries).map(Query::queryFromIds).flatMap(Arrays::stream).toArray(IndexQueryFromId[]::new));
        }

        IndexQueryFromId[] queryFromIds() {
            return this.queryFromIds;
        }

        IndexQuery[] queries(IntSupplier ids) {
            return (IndexQuery[])Arrays.stream(this.queryFromIds).map(query -> query.fromId(ids.getAsInt())).toArray(IndexQuery[]::new);
        }

        @FunctionalInterface
        static interface IndexQueryFromId {
            public IndexQuery fromId(int var1);
        }
    }
}

