/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.fusion;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexBase;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexSampler;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexTestHelp;
import org.neo4j.kernel.impl.index.schema.fusion.FusionVersion;
import org.neo4j.kernel.impl.index.schema.fusion.IndexSlot;
import org.neo4j.kernel.impl.index.schema.fusion.InstanceSelector;
import org.neo4j.kernel.impl.index.schema.fusion.SlotSelector;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.values.storable.Value;

@ExtendWith(value={RandomExtension.class})
abstract class FusionIndexProviderTest {
    private static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("test-fusion", "1");
    private static final IndexDescriptor AN_INDEX = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index").materialise(0L);
    private final FusionVersion fusionVersion;
    private EnumMap<IndexSlot, IndexProvider> providers;
    private IndexProvider[] aliveProviders;
    private IndexProvider fusionIndexProvider;
    private SlotSelector slotSelector;
    private InstanceSelector<IndexProvider> instanceSelector;
    @Inject
    private RandomSupport random;

    FusionIndexProviderTest(FusionVersion fusionVersion) {
        this.fusionVersion = fusionVersion;
    }

    @BeforeEach
    void setup() {
        this.slotSelector = this.fusionVersion.slotSelector();
        this.setupMocks();
    }

    private void setupMocks() {
        IndexSlot[] aliveSlots = this.fusionVersion.aliveSlots();
        this.aliveProviders = new IndexProvider[aliveSlots.length];
        this.providers = new EnumMap(IndexSlot.class);
        FusionIndexTestHelp.fill(this.providers, IndexProvider.EMPTY);
        block4: for (int i = 0; i < aliveSlots.length; ++i) {
            switch (aliveSlots[i]) {
                case GENERIC: {
                    IndexProvider generic = FusionIndexProviderTest.mockProvider(GenericNativeIndexProvider.class, "generic");
                    this.providers.put(IndexSlot.GENERIC, generic);
                    this.aliveProviders[i] = generic;
                    continue block4;
                }
                case LUCENE: {
                    IndexProvider lucene = FusionIndexProviderTest.mockProvider(IndexProvider.class, "lucene");
                    this.providers.put(IndexSlot.LUCENE, lucene);
                    this.aliveProviders[i] = lucene;
                    continue block4;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        this.fusionIndexProvider = new FusionIndexProvider(this.providers.get(IndexSlot.GENERIC), this.providers.get(IndexSlot.LUCENE), this.fusionVersion.slotSelector(), DESCRIPTOR, IndexDirectoryStructure.NONE, (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), false, DatabaseReadOnlyChecker.writable());
        this.instanceSelector = new InstanceSelector(this.providers);
    }

    private static IndexProvider mockProvider(Class<? extends IndexProvider> providerClass, String name) {
        IndexProvider mock = (IndexProvider)Mockito.mock(providerClass);
        Mockito.when((Object)mock.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor(name, "1"));
        return mock;
    }

    @Test
    void mustSelectCorrectTargetForAllGivenValueCombinations() {
        EnumMap<IndexSlot, Value[]> values = FusionIndexTestHelp.valuesByGroup();
        Value[] allValues = FusionIndexTestHelp.allValues();
        for (IndexSlot indexSlot : IndexSlot.values()) {
            Value[] group;
            Value[] valueArray = group = values.get(indexSlot);
            int n = valueArray.length;
            for (int i = 0; i < n; ++i) {
                Value value = valueArray[i];
                IndexProvider selected = (IndexProvider)this.instanceSelector.select(this.slotSelector.selectSlot((Object[])((Value[])ArrayUtil.array((Object[])new Value[]{value})), FusionIndexBase.CATEGORY_OF));
                org.junit.jupiter.api.Assertions.assertSame((Object)this.orLucene(this.providers.get(indexSlot)), (Object)selected);
            }
        }
        for (IndexSlot indexSlot : allValues) {
            for (Value secondValue : allValues) {
                IndexProvider selected = (IndexProvider)this.instanceSelector.select(this.slotSelector.selectSlot((Object[])((Value[])ArrayUtil.array((Object[])new Value[]{indexSlot, secondValue})), FusionIndexBase.CATEGORY_OF));
                org.junit.jupiter.api.Assertions.assertSame((Object)this.providers.get(IndexSlot.GENERIC), (Object)selected);
            }
        }
    }

    @Test
    void mustCombineSamples() {
        int sumIndexSize = 0;
        int sumUniqueValues = 0;
        int sumSampleSize = 0;
        IndexSample[] samples = new IndexSample[this.providers.size()];
        for (int i = 0; i < samples.length; ++i) {
            int indexSize = this.random.nextInt(0, 1000000);
            int uniqueValues = this.random.nextInt(0, 1000000);
            int sampleSize = this.random.nextInt(0, 1000000);
            samples[i] = new IndexSample((long)indexSize, (long)uniqueValues, (long)sampleSize);
            sumIndexSize += indexSize;
            sumUniqueValues += uniqueValues;
            sumSampleSize += sampleSize;
        }
        IndexSample fusionSample = FusionIndexSampler.combineSamples(Arrays.asList(samples));
        org.junit.jupiter.api.Assertions.assertEquals((long)sumIndexSize, (long)fusionSample.indexSize());
        org.junit.jupiter.api.Assertions.assertEquals((long)sumUniqueValues, (long)fusionSample.uniqueValues());
        org.junit.jupiter.api.Assertions.assertEquals((long)sumSampleSize, (long)fusionSample.sampleSize());
    }

    @Test
    void getPopulationFailureReturnEmptyStringIfNoFailure() {
        for (IndexProvider provider : this.aliveProviders) {
            Mockito.when((Object)provider.getPopulationFailure((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)"");
        }
        org.junit.jupiter.api.Assertions.assertEquals((Object)"", (Object)this.fusionIndexProvider.getPopulationFailure(AN_INDEX, CursorContext.NULL));
    }

    @Test
    void getPopulationFailureMustReportFailureWhenAnyFailed() {
        for (IndexProvider failingProvider : this.aliveProviders) {
            String failure = "failure";
            for (IndexProvider provider : this.aliveProviders) {
                if (provider == failingProvider) {
                    Mockito.when((Object)provider.getPopulationFailure((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)failure);
                    continue;
                }
                Mockito.when((Object)provider.getPopulationFailure((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)"");
            }
            Assertions.assertThat((String)this.fusionIndexProvider.getPopulationFailure(AN_INDEX, CursorContext.NULL)).contains(new CharSequence[]{failure});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    void getPopulationFailureMustReportFailureWhenMultipleFail() {
        void var4_6;
        ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
        IndexProvider[] indexProviderArray = this.aliveProviders;
        int n = indexProviderArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            IndexProvider aliveProvider = indexProviderArray[var4_6];
            String failureMessage = "FAILURE[" + aliveProvider + "]";
            failureMessages.add((CallSite)((Object)failureMessage));
            Mockito.when((Object)aliveProvider.getPopulationFailure((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)failureMessage);
            ++var4_6;
        }
        String populationFailure = this.fusionIndexProvider.getPopulationFailure(AN_INDEX, CursorContext.NULL);
        for (String string : failureMessages) {
            Assertions.assertThat((String)populationFailure).contains(new CharSequence[]{string});
        }
    }

    @Test
    void shouldReportFailedIfAnyIsFailed() {
        IndexProvider provider = this.fusionIndexProvider;
        for (InternalIndexState state : InternalIndexState.values()) {
            for (IndexProvider failedProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    FusionIndexProviderTest.setInitialState(aliveProvider, failedProvider == aliveProvider ? InternalIndexState.FAILED : state);
                }
                InternalIndexState initialState = provider.getInitialState(AN_INDEX, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.FAILED, (Object)initialState);
            }
        }
    }

    @Test
    void shouldReportPopulatingIfAnyIsPopulating() {
        for (InternalIndexState state : (InternalIndexState[])ArrayUtil.array((Object[])new InternalIndexState[]{InternalIndexState.ONLINE, InternalIndexState.POPULATING})) {
            for (IndexProvider populatingProvider : this.aliveProviders) {
                for (IndexProvider aliveProvider : this.aliveProviders) {
                    FusionIndexProviderTest.setInitialState(aliveProvider, populatingProvider == aliveProvider ? InternalIndexState.POPULATING : state);
                }
                InternalIndexState initialState = this.fusionIndexProvider.getInitialState(AN_INDEX, CursorContext.NULL);
                org.junit.jupiter.api.Assertions.assertEquals((Object)InternalIndexState.POPULATING, (Object)initialState);
            }
        }
    }

    @Test
    void shouldBlessWithAllProviders() {
        for (IndexProvider aliveProvider : this.aliveProviders) {
            Mockito.when((Object)aliveProvider.completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class))).then(AdditionalAnswers.returnsFirstArg());
        }
        this.fusionIndexProvider.completeConfiguration(AN_INDEX);
        for (IndexProvider aliveProvider : this.aliveProviders) {
            ((IndexProvider)Mockito.verify((Object)aliveProvider, (VerificationMode)Mockito.times((int)1))).completeConfiguration((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class));
        }
    }

    private static void setInitialState(IndexProvider mockedProvider, InternalIndexState state) {
        Mockito.when((Object)mockedProvider.getInitialState((IndexDescriptor)ArgumentMatchers.any(IndexDescriptor.class), (CursorContext)ArgumentMatchers.any(CursorContext.class))).thenReturn((Object)state);
    }

    private IndexProvider orLucene(IndexProvider provider) {
        return provider != IndexProvider.EMPTY ? provider : this.providers.get(IndexSlot.LUCENE);
    }
}

