/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.newapi.EntityWithPropertyValues;
import org.neo4j.kernel.impl.newapi.TxStateIndexChanges;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.TrackableDiffSets;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class TxStateIndexChangesTest {
    private final IndexDescriptor index = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1});

    TxStateIndexChangesTest() {
    }

    @Test
    void shouldComputeIndexUpdatesForScanOnAnEmptyTxState() {
        ReadableTransactionState state = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)changes.isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)changesWithValues.isEmpty());
    }

    @Test
    void shouldComputeIndexUpdatesForScanWhenThereAreNewEntities() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)IndexOrder.NONE);
        TxStateIndexChangesTest.assertContains(changes.getAdded(), 42L, 43L);
        TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(42L, "foo"), TxStateIndexChangesTest.entityWithPropertyValues(43L, "bar"));
    }

    @Test
    void shouldComputeIndexUpdatesForScan() {
        this.assertScanWithOrder(IndexOrder.NONE);
        this.assertScanWithOrder(IndexOrder.ASCENDING);
    }

    @Test
    void shouldComputeIndexUpdatesForScanWithDescendingOrder() {
        this.assertScanWithOrder(IndexOrder.DESCENDING);
    }

    private void assertScanWithOrder(IndexOrder indexOrder) {
        ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Barbarella").withAdded(44L, "Andrea").withAdded(45L, "Aristotle").withAdded(46L, "Barbara").withAdded(47L, "Cinderella").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)indexOrder);
        TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.index, (IndexOrder)indexOrder);
        EntityWithPropertyValues[] expectedEntitiesWithValues = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(40L, "Aaron"), TxStateIndexChangesTest.entityWithPropertyValues(41L, "Agatha"), TxStateIndexChangesTest.entityWithPropertyValues(44L, "Andrea"), TxStateIndexChangesTest.entityWithPropertyValues(42L, "Andreas"), TxStateIndexChangesTest.entityWithPropertyValues(45L, "Aristotle"), TxStateIndexChangesTest.entityWithPropertyValues(46L, "Barbara"), TxStateIndexChangesTest.entityWithPropertyValues(43L, "Barbarella"), TxStateIndexChangesTest.entityWithPropertyValues(47L, "Cinderella")};
        TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expectedEntitiesWithValues);
    }

    @Test
    void shouldComputeIndexUpdatesForSeekWhenThereAreNewEntities() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
        TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (ValueTuple)ValueTuple.of((Object[])new Object[]{"bar"}));
        TxStateIndexChangesTest.assertContains(changes.getAdded(), 43L);
    }

    @TestFactory
    Collection<DynamicTest> rangeTests() {
        ReadableTransactionState state = new TxStateBuilder().withAdded(42L, 510).withAdded(43L, 520).withAdded(44L, 550).withAdded(45L, 500).withAdded(46L, 530).withAdded(47L, 560).withAdded(48L, 540).build();
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        tests.addAll(this.rangeTest(state, Values.of((Object)510), true, Values.of((Object)550), true, TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), true, Values.of((Object)550), false, TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), false, Values.of((Object)550), true, TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, Values.of((Object)510), false, Values.of((Object)550), false, TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, null, false, Values.of((Object)550), true, TxStateIndexChangesTest.entityWithPropertyValues(45L, 500), TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, null, true, Values.of((Object)550), true, TxStateIndexChangesTest.entityWithPropertyValues(45L, 500), TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550)));
        tests.addAll(this.rangeTest(state, null, false, Values.of((Object)550), false, TxStateIndexChangesTest.entityWithPropertyValues(45L, 500), TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, null, true, Values.of((Object)550), false, TxStateIndexChangesTest.entityWithPropertyValues(45L, 500), TxStateIndexChangesTest.entityWithPropertyValues(42L, 510), TxStateIndexChangesTest.entityWithPropertyValues(43L, 520), TxStateIndexChangesTest.entityWithPropertyValues(46L, 530), TxStateIndexChangesTest.entityWithPropertyValues(48L, 540)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), true, null, true, TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550), TxStateIndexChangesTest.entityWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), true, null, false, TxStateIndexChangesTest.entityWithPropertyValues(48L, 540), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550), TxStateIndexChangesTest.entityWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), false, null, true, TxStateIndexChangesTest.entityWithPropertyValues(44L, 550), TxStateIndexChangesTest.entityWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)540), false, null, false, TxStateIndexChangesTest.entityWithPropertyValues(44L, 550), TxStateIndexChangesTest.entityWithPropertyValues(47L, 560)));
        tests.addAll(this.rangeTest(state, Values.of((Object)560), false, Values.of((Object)800), true, new EntityWithPropertyValues[0]));
        return tests;
    }

    private Collection<DynamicTest> rangeTest(ReadableTransactionState state, Value lo, boolean includeLo, Value hi, boolean includeHi, EntityWithPropertyValues ... expected) {
        return Arrays.asList(this.rangeTest(state, IndexOrder.NONE, lo, includeLo, hi, includeHi, expected), this.rangeTest(state, IndexOrder.ASCENDING, lo, includeLo, hi, includeHi, expected), this.rangeTest(state, IndexOrder.DESCENDING, lo, includeLo, hi, includeHi, expected));
    }

    private DynamicTest rangeTest(ReadableTransactionState state, IndexOrder indexOrder, Value lo, boolean includeLo, Value hi, boolean includeHi, EntityWithPropertyValues ... expected) {
        return DynamicTest.dynamicTest((String)String.format("range seek: lo=%s (incl: %s), hi=%s (incl: %s)", lo, includeLo, hi, includeHi), () -> {
            assert (lo != Values.NO_VALUE);
            assert (hi != Values.NO_VALUE);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)lo, (boolean)includeLo, (Value)hi, (boolean)includeHi), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.index, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)lo, (boolean)includeLo, (Value)hi, (boolean)includeHi), (IndexOrder)indexOrder);
            TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expected);
        });
    }

    private static void assertContains(IndexOrder indexOrder, TxStateIndexChanges.AddedAndRemoved changes, TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues, EntityWithPropertyValues[] expected) {
        if (indexOrder == IndexOrder.DESCENDING) {
            ArrayUtils.reverse((Object[])expected);
        }
        long[] expectedEntityIds = Arrays.stream(expected).mapToLong(EntityWithPropertyValues::getEntityId).toArray();
        if (indexOrder == IndexOrder.NONE) {
            TxStateIndexChangesTest.assertContains(changes.getAdded(), expectedEntityIds);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), expected);
        } else {
            TxStateIndexChangesTest.assertContainsInOrder(changes.getAdded(), expectedEntityIds);
            TxStateIndexChangesTest.assertContainsInOrder(changesWithValues.getAdded(), expected);
        }
    }

    private static EntityWithPropertyValues entityWithPropertyValues(long entityId, Object ... values) {
        return new EntityWithPropertyValues(entityId, (Value[])Arrays.stream(values).map(ValueUtils::of).toArray(Value[]::new));
    }

    private static void assertContains(LongIterable iterable, long ... entityIds) {
        Assertions.assertThat((long[])iterable.toArray()).contains(entityIds);
    }

    private static void assertContains(Iterable<EntityWithPropertyValues> iterable, EntityWithPropertyValues ... expected) {
        Assertions.assertThat(iterable).containsExactlyInAnyOrder((Object[])expected);
    }

    private static void assertContainsInOrder(LongIterable iterable, long ... entityIds) {
        Assertions.assertThat((long[])iterable.toArray()).containsExactly(entityIds);
    }

    private static void assertContainsInOrder(Iterable<EntityWithPropertyValues> iterable, EntityWithPropertyValues ... expected) {
        if (expected.length == 0) {
            Assertions.assertThat(iterable).isEmpty();
        } else {
            Assertions.assertThat(iterable).containsExactly((Object[])expected);
        }
    }

    private static class TxStateBuilder {
        Map<ValueTuple, MutableLongDiffSets> updates = new HashMap<ValueTuple, MutableLongDiffSets>();

        private TxStateBuilder() {
        }

        TxStateBuilder withAdded(long id, Object ... value) {
            ValueTuple valueTuple = ValueTuple.of((Object[])value);
            MutableLongDiffSets changes = this.updates.computeIfAbsent(valueTuple, ignore -> TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            changes.add(id);
            return this;
        }

        TxStateBuilder withRemoved(long id, Object ... value) {
            ValueTuple valueTuple = ValueTuple.of((Object[])value);
            MutableLongDiffSets changes = this.updates.computeIfAbsent(valueTuple, ignore -> TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE));
            changes.remove(id);
            return this;
        }

        ReadableTransactionState build() {
            ReadableTransactionState mock = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
            ((ReadableTransactionState)Mockito.doReturn((Object)new UnmodifiableMap(this.updates)).when((Object)mock)).getIndexUpdates((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class));
            TreeMap<ValueTuple, MutableLongDiffSets> sortedMap = new TreeMap<ValueTuple, MutableLongDiffSets>(ValueTuple.COMPARATOR);
            sortedMap.putAll(this.updates);
            ((ReadableTransactionState)Mockito.doReturn(sortedMap).when((Object)mock)).getSortedIndexUpdates((SchemaDescriptor)ArgumentMatchers.any(SchemaDescriptor.class));
            return mock;
        }
    }

    @Nested
    class CompositeIndex {
        private final IndexDescriptor compositeIndex = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2});
        private final IndexDescriptor compositeIndex3properties = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{1, 2, 3});

        CompositeIndex() {
        }

        @Test
        void shouldSeekOnAnEmptyTxState() {
            ReadableTransactionState state = (ReadableTransactionState)Mockito.mock(ReadableTransactionState.class);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes.isEmpty());
        }

        @Test
        void shouldScanWhenThereAreNewEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 42L, 43L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(42L, "42value1", "42value2"), TxStateIndexChangesTest.entityWithPropertyValues(43L, "43value1", "43value2"));
        }

        @Test
        void shouldSeekWhenThereAreNewStringEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").build();
            PropertyIndexQuery.RangePredicate predicate = PropertyIndexQuery.range((int)-1, null, (boolean)false, (Value)Values.stringValue((String)"44val"), (boolean)true);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"43value1")}, (PropertyIndexQuery.RangePredicate)predicate, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 43L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(43L, "43value1", "43value2"));
        }

        @Test
        void shouldSeekWhenThereAreNewNumberEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, 42001.0, 42002.0).withAdded(43L, 43001.0, 43002.0).build();
            PropertyIndexQuery.RangePredicate predicate = PropertyIndexQuery.range((int)-1, (Value)Values.doubleValue((double)43000.0), (boolean)true, null, (boolean)false);
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{43001.0, 43002.0}));
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.doubleValue((double)43001.0)}, (PropertyIndexQuery.RangePredicate)predicate, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 43L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(43L, 43001.0, 43002.0));
        }

        @Test
        void shouldHandleMixedAddsAndRemovesEntryForScan() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").withRemoved(43L, "43value1", "43value2").withRemoved(44L, "44value1", "44value2").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForScan((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 42L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(42L, "42value1", "42value2"));
            TxStateIndexChangesTest.assertContains((LongIterable)changes.getRemoved(), 44L);
            TxStateIndexChangesTest.assertContains((LongIterable)changesWithValues.getRemoved(), 44L);
        }

        @Test
        void shouldHandleMixedAddsAndRemovesEntryForSeek() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2").withAdded(43L, "43value1", "43value2").withRemoved(43L, "43value1", "43value2").withRemoved(44L, "44value1", "44value2").build();
            TxStateIndexChanges.AddedAndRemoved changes42 = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"42value1", "42value2"}));
            TxStateIndexChanges.AddedAndRemoved changes43 = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2"}));
            TxStateIndexChanges.AddedAndRemoved changes44 = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"44value1", "44value2"}));
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues42 = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"42value1")}, null, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues43 = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"43value1")}, null, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues44 = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"44value1")}, null, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes42.getAdded(), 42L);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes42.getRemoved().isEmpty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes43.isEmpty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes44.getAdded().isEmpty());
            TxStateIndexChangesTest.assertContains((LongIterable)changes44.getRemoved(), 44L);
            TxStateIndexChangesTest.assertContains(changesWithValues42.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(42L, "42value1", "42value2"));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changesWithValues42.getRemoved().isEmpty());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changesWithValues43.isEmpty());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)changesWithValues44.getAdded().iterator().hasNext());
            TxStateIndexChangesTest.assertContains((LongIterable)changesWithValues44.getRemoved(), 44L);
        }

        @Test
        void shouldSeekWhenThereAreManyEntriesWithTheSameValues() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "42value1", "42value2", "42value3").withAdded(43L, "43value1", "43value2", "43value3").withAdded(44L, "43value1", "43value2", "43value3").withAdded(45L, "43value1", "42value2", "42value3").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"43value1", "43value2", "43value3"}));
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex3properties, (Value[])new Value[]{Values.stringValue((String)"43value1"), Values.stringValue((String)"43value2")}, null, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 43L, 44L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(43L, "43value1", "43value2", "43value3"), TxStateIndexChangesTest.entityWithPropertyValues(44L, "43value1", "43value2", "43value3"));
        }

        @Test
        void shouldSeekInComplexMix() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(10L, "hi", 3).withAdded(11L, 9L, 33L).withAdded(12L, "sneaker", false).withAdded(13L, new int[]{10, 100}, "array-buddy").withAdded(14L, 40.1, 40.2).build();
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"hi", 3})).getAdded(), 10L);
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{9L, 33L})).getAdded(), 11L);
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{"sneaker", false})).getAdded(), 12L);
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{new int[]{10, 100}, "array-buddy"})).getAdded(), 13L);
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesForSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (ValueTuple)ValueTuple.of((Object[])new Object[]{40.1, 40.2})).getAdded(), 14L);
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"hi")}, null, (IndexOrder)IndexOrder.NONE).getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(10L, "hi", 3));
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.longValue((long)9L)}, null, (IndexOrder)IndexOrder.NONE).getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(11L, 9L, 33L));
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.stringValue((String)"sneaker")}, null, (IndexOrder)IndexOrder.NONE).getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(12L, "sneaker", false));
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.intArray((int[])new int[]{10, 100})}, null, (IndexOrder)IndexOrder.NONE).getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(13L, new int[]{10, 100}, "array-buddy"));
            TxStateIndexChangesTest.assertContains(TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[]{Values.doubleValue((double)40.1)}, null, (IndexOrder)IndexOrder.NONE).getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(14L, 40.1, 40.2));
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeek() {
            this.assertRangeSeekForOrder(IndexOrder.NONE);
            this.assertRangeSeekForOrder(IndexOrder.ASCENDING);
            this.assertRangeSeekForOrder(IndexOrder.DESCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefix() {
            this.assertRangeSeekByPrefixForOrder(IndexOrder.NONE);
            this.assertRangeSeekByPrefixForOrder(IndexOrder.ASCENDING);
            this.assertRangeSeekByPrefixForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, 520, "random42").withAdded(43L, 510, "random43").withAdded(44L, 550, "random44").withAdded(45L, 500, "random45").withAdded(46L, "530", "random46").withAdded(47L, "560", "random47").withAdded(48L, "540", "random48").build();
            EntityWithPropertyValues[] expectedInt = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(43L, 510, "random43"), TxStateIndexChangesTest.entityWithPropertyValues(42L, 520, "random42"), TxStateIndexChangesTest.entityWithPropertyValues(44L, 550, "random44")};
            EntityWithPropertyValues[] expectedString = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(48L, "540", "random48"), TxStateIndexChangesTest.entityWithPropertyValues(47L, "560", "random47")};
            TxStateIndexChanges.AddedAndRemoved changesInt = TxStateIndexChanges.indexUpdatesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)Values.intValue((int)500), (boolean)false, (Value)Values.intValue((int)600), (boolean)false), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedAndRemoved changesString = TxStateIndexChanges.indexUpdatesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)Values.stringValue((String)"530"), (boolean)false, null, (boolean)false), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValuesInt = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)Values.intValue((int)500), (boolean)false, (Value)Values.intValue((int)600), (boolean)false), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValuesString = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (PropertyIndexQuery.RangePredicate)PropertyIndexQuery.range((int)-1, (Value)Values.stringValue((String)"530"), (boolean)false, null, (boolean)false), (IndexOrder)indexOrder);
            TxStateIndexChangesTest.assertContains(indexOrder, changesInt, changesWithValuesInt, expectedInt);
            TxStateIndexChangesTest.assertContains(indexOrder, changesString, changesWithValuesString, expectedString);
        }

        private void assertRangeSeekByPrefixForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron", "Bass").withAdded(41L, "Agatha", "Christie").withAdded(42L, "Andreas", "Jona").withAdded(43L, "Barbarella", "Fonda").withAdded(44L, "Andrea", "Kormos").withAdded(45L, "Aristotle", "Nicomachus").withAdded(46L, "Barbara", "Mikellen").withAdded(47L, "Andy", "Gallagher").withAdded(48L, "Cinderella", "Tremaine").withAdded(49L, "Andromeda", "Black").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)this.compositeIndex, (Value[])new Value[0], (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            EntityWithPropertyValues[] expected = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(44L, "Andrea", "Kormos"), TxStateIndexChangesTest.entityWithPropertyValues(42L, "Andreas", "Jona"), TxStateIndexChangesTest.entityWithPropertyValues(49L, "Andromeda", "Black"), TxStateIndexChangesTest.entityWithPropertyValues(47L, "Andy", "Gallagher")};
            TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expected);
        }
    }

    @Nested
    class Prefix {
        Prefix() {
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNoMatchingEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "value42").withAdded(43L, "value43").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (Value[])new Value[0], (TextValue)Values.stringValue((String)"eulav"), (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (Value[])new Value[0], (TextValue)Values.stringValue((String)"eulav"), (IndexOrder)IndexOrder.NONE);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes.getAdded().isEmpty());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)changesWithValues.getAdded().iterator().hasNext());
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefix() {
            this.assertRangeSeekByPrefixForOrder(IndexOrder.NONE);
            this.assertRangeSeekByPrefixForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWithDescendingOrder() {
            this.assertRangeSeekByPrefixForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekByPrefixForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Barbarella").withAdded(44L, "Andrea").withAdded(45L, "Aristotle").withAdded(46L, "Barbara").withAdded(47L, "Andy").withAdded(48L, "Cinderella").withAdded(49L, "Andromeda").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (Value[])new Value[0], (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (Value[])new Value[0], (TextValue)Values.stringValue((String)"And"), (IndexOrder)indexOrder);
            EntityWithPropertyValues[] expected = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(44L, "Andrea"), TxStateIndexChangesTest.entityWithPropertyValues(42L, "Andreas"), TxStateIndexChangesTest.entityWithPropertyValues(49L, "Andromeda"), TxStateIndexChangesTest.entityWithPropertyValues(47L, "Andy")};
            TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expected);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNonStringEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "barry").withAdded(44L, 101L).withAdded(43L, "bar").build();
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (Value[])new Value[0], (TextValue)Values.stringValue((String)"bar"), (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContainsInOrder(changes.getAdded(), 43L, 42L);
        }
    }

    @Nested
    class SuffixOrContains {
        SuffixOrContains() {
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByContainsWhenThereAreNoMatchingEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(42L, "foo").withAdded(43L, "bar").build();
            PropertyIndexQuery.StringContainsPredicate indexQuery = PropertyIndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"eulav"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)changes.getAdded().isEmpty());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)changesWithValues.getAdded().iterator().hasNext());
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekBySuffixWhenThereArePartiallyMatchingNewEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Andrea").withAdded(44L, "Aristotle").withAdded(45L, "Barbara").withAdded(46L, "Barbarella").withAdded(47L, "Cinderella").build();
            PropertyIndexQuery.StringSuffixPredicate indexQuery = PropertyIndexQuery.stringSuffix((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"ella"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 46L, 47L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(46L, "Barbarella"), TxStateIndexChangesTest.entityWithPropertyValues(47L, "Cinderella"));
        }

        @Test
        void shouldComputeIndexUpdatesForSuffixWithAscendingOrder() {
            this.assertRangeSeekBySuffixForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForSuffixWithDescendingOrder() {
            this.assertRangeSeekBySuffixForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekBySuffixForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Bonbon").withAdded(42L, "Crayfish").withAdded(43L, "Mayonnaise").withAdded(44L, "Seashell").withAdded(45L, "Ton").withAdded(46L, "Macron").withAdded(47L, "Tony").withAdded(48L, "Evon").withAdded(49L, "Andromeda").build();
            PropertyIndexQuery.StringSuffixPredicate indexQuery = PropertyIndexQuery.stringSuffix((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"on"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)indexOrder);
            EntityWithPropertyValues[] expected = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(40L, "Aaron"), TxStateIndexChangesTest.entityWithPropertyValues(41L, "Bonbon"), TxStateIndexChangesTest.entityWithPropertyValues(48L, "Evon"), TxStateIndexChangesTest.entityWithPropertyValues(46L, "Macron"), TxStateIndexChangesTest.entityWithPropertyValues(45L, "Ton")};
            TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expected);
        }

        @Test
        void shouldComputeIndexUpdatesForRangeSeekByContainsWhenThereArePartiallyMatchingNewEntities() {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Aaron").withAdded(41L, "Agatha").withAdded(42L, "Andreas").withAdded(43L, "Andrea").withAdded(44L, "Aristotle").withAdded(45L, "Barbara").withAdded(46L, "Barbarella").withAdded(47L, "Cinderella").build();
            PropertyIndexQuery.StringContainsPredicate indexQuery = PropertyIndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"arbar"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)IndexOrder.NONE);
            TxStateIndexChangesTest.assertContains(changes.getAdded(), 45L, 46L);
            TxStateIndexChangesTest.assertContains(changesWithValues.getAdded(), TxStateIndexChangesTest.entityWithPropertyValues(45L, "Barbara"), TxStateIndexChangesTest.entityWithPropertyValues(46L, "Barbarella"));
        }

        @Test
        void shouldComputeIndexUpdatesForContainsWithAscendingOrder() {
            this.assertRangeSeekByContainsForOrder(IndexOrder.ASCENDING);
        }

        @Test
        void shouldComputeIndexUpdatesForContainsWithDescendingOrder() {
            this.assertRangeSeekByContainsForOrder(IndexOrder.DESCENDING);
        }

        private void assertRangeSeekByContainsForOrder(IndexOrder indexOrder) {
            ReadableTransactionState state = new TxStateBuilder().withAdded(40L, "Smashing").withAdded(41L, "Bashley").withAdded(42L, "Crasch").withAdded(43L, "Mayonnaise").withAdded(44L, "Seashell").withAdded(45L, "Ton").withAdded(46L, "The Flash").withAdded(47L, "Strayhound").withAdded(48L, "Trashy").withAdded(49L, "Andromeda").build();
            PropertyIndexQuery.StringContainsPredicate indexQuery = PropertyIndexQuery.stringContains((int)TxStateIndexChangesTest.this.index.schema().getPropertyId(), (TextValue)Values.stringValue((String)"ash"));
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)indexOrder);
            TxStateIndexChanges.AddedWithValuesAndRemoved changesWithValues = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains((ReadableTransactionState)state, (IndexDescriptor)TxStateIndexChangesTest.this.index, (PropertyIndexQuery)indexQuery, (IndexOrder)indexOrder);
            EntityWithPropertyValues[] expected = new EntityWithPropertyValues[]{TxStateIndexChangesTest.entityWithPropertyValues(41L, "Bashley"), TxStateIndexChangesTest.entityWithPropertyValues(44L, "Seashell"), TxStateIndexChangesTest.entityWithPropertyValues(40L, "Smashing"), TxStateIndexChangesTest.entityWithPropertyValues(46L, "The Flash"), TxStateIndexChangesTest.entityWithPropertyValues(48L, "Trashy")};
            TxStateIndexChangesTest.assertContains(indexOrder, changes, changesWithValues, expected);
        }
    }
}

