/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.Converters;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class ConvertersTest {
    @Inject
    private TestDirectory directory;

    ConvertersTest() {
    }

    @Test
    void shouldSortFilesByNumberCleverly() throws Exception {
        Path file1 = this.existenceOfFile("file1");
        Path file123 = this.existenceOfFile("file123");
        Path file12 = this.existenceOfFile("file12");
        Path file2 = this.existenceOfFile("file2");
        Path file32 = this.existenceOfFile("file32");
        Object[] files = (Path[])Converters.regexFiles((boolean)true).apply(this.directory.file("file").toAbsolutePath().toString() + ".*");
        Assertions.assertArrayEquals((Object[])new Path[]{file1, file2, file12, file32, file123}, (Object[])files);
    }

    @Test
    void shouldParseFile() throws IOException {
        Path file = this.existenceOfFile("file");
        Path[] files = (Path[])Converters.regexFiles((boolean)true).apply(file.toString());
        Assertions.assertEquals(List.of(file), List.of(files));
    }

    @Test
    void shouldParseRegexFileWithDashes() throws IOException {
        Assumptions.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        Path file1 = this.existenceOfFile("file_1");
        Path file3 = this.existenceOfFile("file_3");
        Path file12 = this.existenceOfFile("file_12");
        Path[] files = (Path[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\d+");
        Path[] files2 = (Path[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\d{1,5}");
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files));
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files2));
    }

    @Test
    void shouldParseRegexFileWithDoubleDashes() throws IOException {
        Path file1 = this.existenceOfFile("file_1");
        Path file3 = this.existenceOfFile("file_3");
        Path file12 = this.existenceOfFile("file_12");
        Path[] files = (Path[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\\\d+");
        Path[] files2 = (Path[])Converters.regexFiles((boolean)true).apply(file1.getParent() + File.separator + "file_\\\\d{1,5}");
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files));
        Assertions.assertEquals(List.of(file1, file3, file12), List.of(files2));
    }

    @Test
    void shouldConsiderInnerQuotationWhenSplittingMultipleFiles() throws IOException {
        Path header = this.existenceOfFile("header.csv");
        Path file1 = this.existenceOfFile("file_1.csv");
        Path file3 = this.existenceOfFile("file_3.csv");
        Path file12 = this.existenceOfFile("file_12.csv");
        Function regexMatcher = Converters.regexFiles((boolean)true);
        Function converter = Converters.toFiles((String)",", (Function)regexMatcher);
        Path[] files = (Path[])converter.apply(header + ",'" + header.getParent() + File.separator + "file_\\\\d{1,5}.csv'");
        Assertions.assertEquals(List.of(header, file1, file3, file12), List.of(files));
    }

    @Test
    void shouldFailWithProperErrorMessageOnMissingEndQuote() {
        Function<String, Path[]> regexMatcher = s -> {
            throw new UnsupportedOperationException("Should not required");
        };
        Function converter = Converters.toFiles((String)",", regexMatcher);
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> converter.apply("thing1,'thing2,test,thing3"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"no matching end quote"));
    }

    private Path existenceOfFile(String name) throws IOException {
        Path file = this.directory.file(name);
        Files.createFile(file, new FileAttribute[0]);
        return file;
    }
}

