/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.exceptions.UnsatisfiedDependencyException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionFailureStrategy;
import org.neo4j.kernel.extension.GlobalExtensions;
import org.neo4j.kernel.extension.UninitializableExtensionFactory;
import org.neo4j.kernel.extension.context.DatabaseExtensionContext;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.extension.context.GlobalExtensionContext;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
class ExtensionContextTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private Neo4jLayout neo4jLayout;

    ExtensionContextTest() {
    }

    @Test
    void shouldConsultUnsatisfiedDependencyHandlerOnMissingDependencies() {
        GlobalExtensionContext context = (GlobalExtensionContext)Mockito.mock(GlobalExtensionContext.class);
        ExtensionFailureStrategy handler = (ExtensionFailureStrategy)Mockito.mock(ExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        TestingExtensionFactory extensionFactory = new TestingExtensionFactory();
        GlobalExtensions extensions = new GlobalExtensions(context, Iterables.iterable((Object[])new TestingExtensionFactory[]{extensionFactory}), dependencies, handler);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{extensions});){
            ((ExtensionFailureStrategy)Mockito.verify((Object)handler)).handle((ExtensionFactory)ArgumentMatchers.eq((Object)((Object)extensionFactory)), (UnsatisfiedDependencyException)ArgumentMatchers.any(UnsatisfiedDependencyException.class));
        }
    }

    @Test
    void shouldFindDependenciesFromHierarchyBottomUp() {
        GlobalExtensionContext context = (GlobalExtensionContext)Mockito.mock(GlobalExtensionContext.class);
        ExtensionFailureStrategy handler = (ExtensionFailureStrategy)Mockito.mock(ExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        dependencies.satisfyDependencies(new Object[]{jobScheduler});
        SubTestingExtensionFactory extensionFactory = new SubTestingExtensionFactory();
        GlobalExtensions extensions = new GlobalExtensions(context, Iterables.iterable((Object[])new SubTestingExtensionFactory[]{extensionFactory}), dependencies, handler);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{extensions});){
            Assertions.assertNotNull((Object)dependencies.resolveDependency(TestingExtension.class));
        }
    }

    @Test
    void shouldFindDependenciesFromHierarchyBottomUpWithGenericsInTheMiddle() {
        GlobalExtensionContext context = (GlobalExtensionContext)Mockito.mock(GlobalExtensionContext.class);
        ExtensionFailureStrategy handler = (ExtensionFailureStrategy)Mockito.mock(ExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        dependencies.satisfyDependencies(new Object[]{jobScheduler});
        SubGenericTestingExtensionFactory extensionFactory = new SubGenericTestingExtensionFactory();
        GlobalExtensions extensions = new GlobalExtensions(context, Iterables.iterable((Object[])new SubGenericTestingExtensionFactory[]{extensionFactory}), dependencies, handler);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{extensions});){
            Assertions.assertNotNull((Object)dependencies.resolveDependency(TestingExtension.class));
        }
    }

    @Test
    void shouldFindDependenciesFromWhenExtensionIsGenerified() {
        GlobalExtensionContext context = (GlobalExtensionContext)Mockito.mock(GlobalExtensionContext.class);
        ExtensionFailureStrategy handler = (ExtensionFailureStrategy)Mockito.mock(ExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
        dependencies.satisfyDependencies(new Object[]{jobScheduler});
        GenericTestingExtensionFactory extensionFactory = new GenericTestingExtensionFactory();
        GlobalExtensions extensions = new GlobalExtensions(context, Iterables.iterable((Object[])new GenericTestingExtensionFactory[]{extensionFactory}), dependencies, handler);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{extensions});){
            Assertions.assertNotNull((Object)dependencies.resolveDependency(TestingExtension.class));
        }
    }

    @Test
    void shouldConsultUnsatisfiedDependencyHandlerOnFailingDependencyClasses() {
        GlobalExtensionContext context = (GlobalExtensionContext)Mockito.mock(GlobalExtensionContext.class);
        ExtensionFailureStrategy handler = (ExtensionFailureStrategy)Mockito.mock(ExtensionFailureStrategy.class);
        Dependencies dependencies = new Dependencies();
        UninitializableExtensionFactory extensionFactory = new UninitializableExtensionFactory();
        GlobalExtensions extensions = new GlobalExtensions(context, Iterables.iterable((Object[])new UninitializableExtensionFactory[]{extensionFactory}), dependencies, handler);
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{extensions});){
            ((ExtensionFailureStrategy)Mockito.verify((Object)handler)).handle((ExtensionFactory)ArgumentMatchers.eq((Object)((Object)extensionFactory)), (Throwable)ArgumentMatchers.any(IllegalArgumentException.class));
        }
    }

    @Test
    void globalContextRootDirectoryEqualToStoreDirectory() {
        GlobalExtensionContext context = new GlobalExtensionContext(this.neo4jLayout, DbmsInfo.TOOL, (DependencySatisfier)new Dependencies());
        Assertions.assertSame((Object)this.neo4jLayout.databasesDirectory(), (Object)context.directory());
    }

    @Test
    void databaseContextRootDirectoryEqualToDatabaseDirectory() {
        DatabaseExtensionContext context = new DatabaseExtensionContext(this.databaseLayout, DbmsInfo.TOOL, (DependencySatisfier)new Dependencies());
        Assertions.assertSame((Object)this.databaseLayout.databaseDirectory(), (Object)context.directory());
    }

    private static class SubGenericTestingExtensionFactory
    extends GenericTestingExtensionFactory<TestingExtension> {
        private SubGenericTestingExtensionFactory() {
        }
    }

    private static class GenericTestingExtensionFactory<T>
    extends ExtensionFactory<TestingDependencies> {
        protected GenericTestingExtensionFactory() {
            super("testing generics");
        }

        public Lifecycle newInstance(ExtensionContext context, TestingDependencies dependencies) {
            dependencies.jobScheduler();
            return new TestingExtension();
        }
    }

    private static class TestingExtension
    extends LifecycleAdapter {
        TestingExtension() {
        }
    }

    private static class SubTestingExtensionFactory
    extends TestingExtensionFactory {
        private SubTestingExtensionFactory() {
        }
    }

    private static class TestingExtensionFactory
    extends ExtensionFactory<TestingDependencies> {
        TestingExtensionFactory() {
            super("testing");
        }

        public Lifecycle newInstance(ExtensionContext context, TestingDependencies dependencies) {
            dependencies.jobScheduler();
            return new TestingExtension();
        }
    }

    private static interface TestingDependencies {
        public JobScheduler jobScheduler();
    }
}

