/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.function.IntSupplier;
import org.junit.jupiter.api.Nested;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.SupportPartitionedScanTestSuite;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public class NoSupportPartitionedScanTest
extends SupportPartitionedScanTestSuite {
    NoSupportPartitionedScanTest() {
        super(IndexCapability.NO_CAPABILITY, NO_SUPPORT);
    }

    private static IndexCapability fusionCapability() {
        IndexProviderDescriptor descriptor = FulltextIndexProviderFactory.DESCRIPTOR;
        FulltextIndexProvider provider = new FulltextIndexProvider(descriptor, (IndexDirectoryStructure.Factory)Mockito.mock(IndexDirectoryStructure.Factory.class), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), Config.defaults(), (TokenHolders)Mockito.mock(TokenHolders.class), (DirectoryFactory)Mockito.mock(DirectoryFactory.class), (DatabaseReadOnlyChecker)Mockito.mock(DatabaseReadOnlyChecker.class), (JobScheduler)Mockito.mock(JobScheduler.class), (Log)Mockito.mock(Log.class));
        IntSupplier ids = NoSupportPartitionedScanTest.idGenerator();
        IndexDescriptor index = provider.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)ids.getAsInt(), (int[])new int[]{ids.getAsInt(), ids.getAsInt()})).withName("Fulltext").withIndexProvider(descriptor).materialise((long)ids.getAsInt()));
        return index.getCapability();
    }

    @Nested
    class Fulltext
    extends SupportPartitionedScanTestSuite {
        Fulltext() {
            super(NoSupportPartitionedScanTest.fusionCapability(), NO_SUPPORT);
        }
    }

    @Nested
    class Text
    extends SupportPartitionedScanTestSuite {
        Text() {
            super(TextIndexProvider.CAPABILITY, NO_SUPPORT);
        }
    }

    @Nested
    class Point
    extends SupportPartitionedScanTestSuite {
        Point() {
            super(PointIndexProvider.CAPABILITY, NO_SUPPORT);
        }
    }
}

