/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
class LogHeaderWriterTest {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private RandomSupport random;
    private long expectedLogVersion;
    private long expectedTxId;
    private StoreId expectedStoreId;
    private LogHeader logHeader;

    LogHeaderWriterTest() {
    }

    @BeforeEach
    void setUp() {
        this.expectedLogVersion = this.random.nextLong(0L, 0xFFFFFFFFFFFFFFL);
        this.expectedTxId = this.random.nextLong(0L, Long.MAX_VALUE);
        this.expectedStoreId = new StoreId(this.random.nextLong(), this.random.nextLong(), this.random.nextLong(), this.random.nextLong(), this.random.nextLong());
        this.logHeader = new LogHeader(this.expectedLogVersion, this.expectedTxId, this.expectedStoreId);
    }

    @Test
    void shouldWriteALogHeaderInTheGivenChannel() throws IOException {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        LogHeaderWriter.writeLogHeader((FlushableChannel)channel, (LogHeader)this.logHeader);
        long encodedLogVersions = channel.getLong();
        Assertions.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)this.expectedLogVersion, (long)7L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assertions.assertEquals((byte)7, (byte)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assertions.assertEquals((long)this.expectedLogVersion, (long)logVersion);
        long txId = channel.getLong();
        Assertions.assertEquals((long)this.expectedTxId, (long)txId);
        StoreId storeId = new StoreId(channel.getLong(), channel.getLong(), channel.getLong(), channel.getLong(), channel.getLong());
        Assertions.assertEquals((Object)this.expectedStoreId, (Object)storeId);
    }

    @Test
    void shouldWriteALogHeaderInAStoreChannel() throws IOException {
        Path file = this.testDirectory.file("WriteLogHeader");
        StoreChannel channel = this.fileSystem.write(file);
        LogHeaderWriter.writeLogHeader((StoreChannel)channel, (LogHeader)this.logHeader, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        channel.close();
        byte[] array = new byte[64];
        try (InputStream stream = this.fileSystem.openAsInputStream(file);){
            int read = stream.read(array);
            Assertions.assertEquals((int)64, (int)read);
        }
        ByteBuffer result = ByteBuffer.wrap(array);
        long encodedLogVersions = result.getLong();
        Assertions.assertEquals((long)LogHeaderWriter.encodeLogVersion((long)this.expectedLogVersion, (long)7L), (long)encodedLogVersions);
        byte logFormatVersion = LogHeaderReader.decodeLogFormatVersion((long)encodedLogVersions);
        Assertions.assertEquals((byte)7, (byte)logFormatVersion);
        long logVersion = LogHeaderReader.decodeLogVersion((long)encodedLogVersions);
        Assertions.assertEquals((long)this.expectedLogVersion, (long)logVersion);
        long txId = result.getLong();
        Assertions.assertEquals((long)this.expectedTxId, (long)txId);
        StoreId storeId = new StoreId(result.getLong(), result.getLong(), result.getLong(), result.getLong(), result.getLong());
        Assertions.assertEquals((Object)this.expectedStoreId, (Object)storeId);
    }
}

