/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.testkit.engine.EngineTestKit;
import org.junit.platform.testkit.engine.EventConditions;
import org.junit.platform.testkit.engine.Events;
import org.junit.platform.testkit.engine.TestExecutionResultConditions;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.JobSchedulerExtension;
import org.neo4j.scheduler.JobSchedulerExtensionShutdown;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={JobSchedulerExtension.class})
class JobSchedulerExtensionTest {
    @Inject
    private JobScheduler jobScheduler;

    JobSchedulerExtensionTest() {
    }

    @Test
    void injectStartedJobScheduler() throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.jobScheduler.schedule(Group.TESTING, countDownLatch::countDown);
        Assertions.assertTrue((boolean)countDownLatch.await(1L, TimeUnit.MINUTES));
    }

    @Nested
    class ShutdownScheduler {
        ShutdownScheduler() {
        }

        @Test
        void componentShutdownAfterTest() {
            Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(JobSchedulerExtensionShutdown.class)}).execute().testEvents();
            testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedWithFailure((Condition[])new Condition[]{TestExecutionResultConditions.instanceOf(RuntimeException.class), TestExecutionResultConditions.message(message -> message.contains("Shutdown called."))})}));
        }
    }
}

