/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Objects;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.annotations.documented.Documented;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphDescription;

public class TestData<T>
implements BeforeEachCallback,
AfterEachCallback {
    private final Producer<T> producer;
    private final ThreadLocal<Lazy> product = new InheritableThreadLocal<Lazy>();
    private static final String EMPTY = "";

    public static <T> TestData<T> producedThrough(Producer<T> transformation) {
        Objects.requireNonNull(transformation);
        return new TestData<T>(transformation);
    }

    public T get() {
        return this.get(true);
    }

    private TestData(Producer<T> producer) {
        this.producer = producer;
    }

    public void beforeEach(ExtensionContext context) {
        Method method = context.getRequiredTestMethod();
        Title title = method.getAnnotation(Title.class);
        Documented doc = method.getAnnotation(Documented.class);
        GraphDescription.Graph g = method.getAnnotation(GraphDescription.Graph.class);
        if (g == null) {
            g = context.getRequiredTestClass().getAnnotation(GraphDescription.Graph.class);
        }
        GraphDescription graph = GraphDescription.create(g);
        this.product.set(TestData.create(graph, title == null ? null : title.value(), doc == null ? null : doc.value(), method.getName()));
    }

    public void afterEach(ExtensionContext context) {
        this.product.set(null);
    }

    private T get(boolean create) {
        Lazy lazy = this.product.get();
        if (lazy == null) {
            if (create) {
                throw new IllegalStateException("Not in test case");
            }
            return null;
        }
        return lazy.get(this.producer, create);
    }

    private static Lazy create(GraphDescription graph, String title, String doc, String methodName) {
        if (doc != null) {
            int dot;
            if (title == null && (dot = doc.indexOf(46)) > 0) {
                title = doc.substring(0, dot);
                if (title.contains("\n")) {
                    title = null;
                } else {
                    title = title.trim();
                    doc = doc.substring(dot + 1);
                }
            }
            String[] lines = doc.split("\n");
            int indent = Integer.MAX_VALUE;
            int start = 0;
            int end = 0;
            for (int i = 0; i < lines.length; ++i) {
                if (EMPTY.equals(lines[i].trim())) {
                    lines[i] = EMPTY;
                    if (start != i) continue;
                    end = ++start;
                    continue;
                }
                for (int j = 0; j < lines[i].length(); ++j) {
                    if (Character.isWhitespace(lines[i].charAt(j))) continue;
                    indent = Math.min(indent, j);
                    break;
                }
                end = i;
            }
            if (end == lines.length) {
                --end;
            }
            if (title == null && start < end && EMPTY.equals(lines[start + 1])) {
                title = lines[start].trim();
                start += 2;
            }
            StringBuilder documentation = new StringBuilder();
            for (int i = start; i <= end; ++i) {
                documentation.append(EMPTY.equals(lines[i]) ? EMPTY : lines[i].substring(indent)).append("\n");
            }
            doc = documentation.toString();
        } else {
            doc = EMPTY;
        }
        if (title == null) {
            title = methodName.replace("_", " ");
        }
        return new Lazy(graph, title, doc);
    }

    private static final class Factory {
        private final GraphDefinition graph;
        private final String title;
        private final String documentation;

        Factory(GraphDefinition graph, String title, String documentation) {
            this.graph = graph;
            this.title = title;
            this.documentation = documentation;
        }

        Object create(Producer<?> producer, boolean create) {
            return create ? producer.create(this.graph, this.title, this.documentation) : null;
        }
    }

    private static final class Lazy {
        private volatile Object productOrFactory;

        Lazy(GraphDefinition graph, String title, String documentation) {
            this.productOrFactory = new Factory(graph, title, documentation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T get(Producer<T> producer, boolean create) {
            Object result = this.productOrFactory;
            if (result instanceof Factory) {
                Lazy lazy = this;
                synchronized (lazy) {
                    result = this.productOrFactory;
                    if (result instanceof Factory) {
                        this.productOrFactory = result = ((Factory)result).create(producer, create);
                    }
                }
            }
            return (T)result;
        }
    }

    public static interface Producer<T> {
        public T create(GraphDefinition var1, String var2, String var3);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Title {
        public String value();
    }
}

