/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.IndexTestUtil;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.utils.PageCacheConfig;

abstract class IndexAccessorTests<KEY, VALUE, LAYOUT extends Layout<KEY, VALUE>>
extends IndexTestUtil<KEY, VALUE, LAYOUT> {
    IndexAccessor accessor;

    IndexAccessorTests() {
    }

    @BeforeEach
    void setupAccessor() throws IOException {
        this.accessor = this.createAccessor(this.pageCache);
    }

    @AfterEach
    void closeAccessor() {
        this.accessor.close();
    }

    abstract IndexAccessor createAccessor(PageCache var1) throws IOException;

    @Test
    void shouldHandleCloseWithoutCallsToProcess() throws Exception {
        IndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);
        updater.close();
    }

    @Test
    void requestForSecondUpdaterMustThrow() throws Exception {
        try (IndexUpdater ignored = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL));
        }
    }

    @Test
    void dropShouldDeleteAndCloseIndex() {
        this.assertFilePresent();
        this.accessor.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropShouldNotFlushContent() throws IOException {
        this.accessor.close();
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        try (PageCache pageCache = PageCacheSupportExtension.getPageCache((FileSystemAbstraction)this.fs, (PageCacheConfig)PageCacheConfig.config().withTracer((PageCacheTracer)tracer));){
            this.accessor = this.createAccessor(pageCache);
            long baseline = tracer.flushes();
            this.accessor.force(CursorContext.NULL);
            long preDrop = tracer.flushes();
            Assertions.assertThat((long)preDrop).isGreaterThan(baseline);
            this.accessor.drop();
            long postDrop = tracer.flushes();
            org.junit.jupiter.api.Assertions.assertEquals((long)preDrop, (long)postDrop);
        }
    }

    @Test
    void snapshotFilesShouldReturnIndexFile() {
        ResourceIterator files = this.accessor.snapshotFiles();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)files.hasNext());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.indexFiles.getStoreFile(), (Object)files.next());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)files.hasNext());
    }

    @Test
    void writingAfterDropShouldThrow() {
        this.accessor.drop();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL));
    }

    @Test
    void writingAfterCloseShouldThrow() {
        this.accessor.close();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL));
    }
}

