/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.watcher;

import java.nio.file.WatchKey;
import java.util.Set;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.fs.watcher.resource.WatchedFile;
import org.neo4j.io.fs.watcher.resource.WatchedResource;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionEventListener;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class DefaultFileDeletionEventListenerTest {
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private TestDirectory testDirectory;
    private final WatchKey databaseDirKey = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchKey databaseLogsDirKey = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchKey databaseRootKey = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchKey databaseLogsRootKey = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchKey anotherDatabaseDirKey = (WatchKey)Mockito.mock(WatchKey.class);
    private final WatchKey anotherDatabaseLogsDirKey = (WatchKey)Mockito.mock(WatchKey.class);
    private WatchedResource watchedDatabaseDirectory;
    private WatchedResource watchedLogsDirectory;
    private WatchedResource watchedDatabaseRootDirectory;
    private WatchedResource watchedLogsRootDirectory;

    DefaultFileDeletionEventListenerTest() {
    }

    @BeforeEach
    void setUp() {
        this.watchedDatabaseDirectory = new WatchedFile(this.databaseDirKey, this.databaseLayout.databaseDirectory());
        this.watchedLogsDirectory = new WatchedFile(this.databaseLogsDirKey, this.databaseLayout.getTransactionLogsDirectory());
        this.watchedDatabaseRootDirectory = new WatchedFile(this.databaseRootKey, this.neo4jLayout.databasesDirectory());
        this.watchedLogsRootDirectory = new WatchedFile(this.databaseLogsRootKey, this.neo4jLayout.transactionLogsRootDirectory());
    }

    @Test
    void notificationInLogAboutFileDeletion() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.databaseDirKey, "testFile");
        listener.fileDeleted(this.databaseDirKey, "anotherDirectory");
        String databaseName = this.databaseLayout.getDatabaseName();
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).containsMessages(new String[]{"'testFile' which belongs to the '" + databaseName + "' database was deleted while it was running.", "'anotherDirectory' which belongs to the '" + databaseName + "' database was deleted while it was running."});
    }

    @Test
    void notificationAboutDeletionInDatabaseDirectory() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String databaseFile = "neostore.db";
        listener.fileDeleted(this.databaseDirKey, databaseFile);
        String databaseName = this.databaseLayout.getDatabaseName();
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).containsMessages(new String[]{"'" + databaseFile + "' which belongs to the '" + databaseName + "' database was deleted while it was running."});
    }

    @Test
    void noNotificationAboutDeletionInAnotherDatabaseDirectory() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String databaseFile = "neostore.db";
        listener.fileDeleted(this.anotherDatabaseDirKey, databaseFile);
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).doesNotHaveAnyLogs();
    }

    @Test
    void notificationAboutDeletionInTransactionLogsDirectory() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String someFile = "someFile";
        listener.fileDeleted(this.databaseLogsDirKey, someFile);
        String databaseName = this.databaseLayout.getDatabaseName();
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).containsMessages(new String[]{"'" + someFile + "' which belongs to the '" + databaseName + "' database was deleted while it was running."});
    }

    @Test
    void noNotificationAboutDeletionInAnotherTransactionLogsDirectory() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String someFile = "someFile";
        listener.fileDeleted(this.anotherDatabaseLogsDirKey, someFile);
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).doesNotHaveAnyLogs();
    }

    @Test
    void notificationAboutDatabaseDirectoryRemoval() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String databaseName = this.databaseLayout.getDatabaseName();
        listener.fileDeleted(this.databaseRootKey, databaseName);
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).containsMessages(new String[]{"'" + databaseName + "' which belongs to the '" + databaseName + "' database was deleted while it was running."});
    }

    @Test
    void noNotificationAboutAnotherDatabaseDirectoryRemoval() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.databaseRootKey, "foo");
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).doesNotHaveAnyLogs();
    }

    @Test
    void notificationAboutLogsDirectoryRemoval() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        String databaseName = this.databaseLayout.getDatabaseName();
        listener.fileDeleted(this.databaseLogsRootKey, databaseName);
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).containsMessages(new String[]{"'" + databaseName + "' which belongs to the '" + databaseName + "' database was deleted while it was running."});
    }

    @Test
    void notificationAboutAnotherDatabaseLogsDirectoryRemoval() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.databaseLogsRootKey, "bar");
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).doesNotHaveAnyLogs();
    }

    @Test
    void noNotificationForTransactionLogs() {
        AssertableLogProvider internalLogProvider = new AssertableLogProvider(false);
        DefaultFileDeletionEventListener listener = this.buildListener(internalLogProvider);
        listener.fileDeleted(this.databaseLogsDirKey, "neostore.transaction.db.0");
        listener.fileDeleted(this.databaseLogsDirKey, "neostore.transaction.db.1");
        LogAssertions.assertThat((AssertableLogProvider)internalLogProvider).doesNotHaveAnyLogs();
    }

    private DefaultFileDeletionEventListener buildListener(AssertableLogProvider internalLogProvider) {
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)internalLogProvider);
        Set watchedResources = Iterators.asSet((Object[])new WatchedResource[]{this.watchedDatabaseDirectory, this.watchedLogsDirectory, this.watchedDatabaseRootDirectory, this.watchedLogsRootDirectory});
        return new DefaultFileDeletionEventListener(this.databaseLayout, watchedResources, (LogService)logService, filename -> filename.startsWith("neostore.transaction.db"));
    }
}

