/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StubStorageCursors;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityValueUpdatesTest {
    private static final long ENTITY_ID = 0L;
    private static final int TOKEN_ID_1 = 0;
    private static final int TOKEN_ID_2 = 1;
    private static final int UNUSED_TOKEN_ID = 2;
    private static final int PROPERTY_KEY_ID_1 = 0;
    private static final int PROPERTY_KEY_ID_2 = 1;
    private static final int PROPERTY_KEY_ID_3 = 2;
    private static final long[] TOKEN = new long[]{0L};
    private static final long[] ALL_TOKENS = new long[]{0L, 1L};
    private static final long[] EMPTY = new long[0];
    private static final SchemaDescriptorSupplier NODE_INDEX_1 = () -> SchemaDescriptors.forLabel((int)0, (int[])new int[]{0});
    private static final SchemaDescriptorSupplier NODE_INDEX_2 = () -> SchemaDescriptors.forLabel((int)0, (int[])new int[]{1});
    private static final SchemaDescriptorSupplier NODE_INDEX_3 = () -> SchemaDescriptors.forLabel((int)0, (int[])new int[]{2});
    private static final SchemaDescriptorSupplier NODE_INDEX_123 = () -> SchemaDescriptors.forLabel((int)0, (int[])new int[]{0, 1, 2});
    private static final List<SchemaDescriptorSupplier> NODE_INDEXES = Arrays.asList(NODE_INDEX_1, NODE_INDEX_2, NODE_INDEX_3, NODE_INDEX_123);
    private static final SchemaDescriptorSupplier NON_SCHEMA_NODE_INDEX = () -> SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{0, 1}, (int[])new int[]{0, 1, 2});
    private static final StorageProperty PROPERTY_1 = new PropertyKeyValue(0, Values.of((Object)"Neo"));
    private static final StorageProperty PROPERTY_2 = new PropertyKeyValue(1, Values.of((Object)100L));
    private static final StorageProperty PROPERTY_3 = new PropertyKeyValue(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
    private static final Value[] VALUES_123 = new Value[]{PROPERTY_1.value(), PROPERTY_2.value(), PROPERTY_3.value()};

    EntityValueUpdatesTest() {
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdatesForEmptyEntityUpdates(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.assertNoLoading(), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void useProvidedCursorForPropertiesOnNodesLoad() {
        CursorContext cursorContext = (CursorContext)Mockito.mock(CursorContext.class);
        StoreCursors storeCursors = (StoreCursors)Mockito.mock(StoreCursors.class);
        StorageNodeCursor nodeCursor = (StorageNodeCursor)Mockito.mock(StorageNodeCursor.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)nodeCursor.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)storageReader.allocateNodeCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenReturn((Object)nodeCursor);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).build();
        updates.valueUpdatesForIndexKeys(NODE_INDEXES, storageReader, EntityType.NODE, cursorContext, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocateNodeCursor(cursorContext, storeCursors);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocatePropertyCursor(cursorContext, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Test
    void useProvidedCursorForPropertiesOnRelationshipLoad() {
        CursorContext cursorContext = (CursorContext)Mockito.mock(CursorContext.class);
        StoreCursors storeCursors = (StoreCursors)Mockito.mock(StoreCursors.class);
        StorageRelationshipScanCursor relationshipCursor = (StorageRelationshipScanCursor)Mockito.mock(StorageRelationshipScanCursor.class);
        StorageReader storageReader = (StorageReader)Mockito.mock(StorageReader.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)relationshipCursor.hasProperties()).thenReturn((Object)true);
        Mockito.when((Object)relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)storageReader.allocateRelationshipScanCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenReturn((Object)relationshipCursor);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).build();
        updates.valueUpdatesForIndexKeys(NODE_INDEXES, storageReader, EntityType.RELATIONSHIP, cursorContext, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocateRelationshipScanCursor(cursorContext, storeCursors);
        ((StorageReader)Mockito.verify((Object)storageReader)).allocatePropertyCursor(cursorContext, storeCursors, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdateForMultipleExistingPropertiesAndTokens(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.assertNoLoading(), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdatesForTokenAdditionWithNoProperties(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForLabelAdditionWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.propertyLoader(PROPERTY_1), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_1, (Value[])new Value[]{PROPERTY_1.value()})});
    }

    @Test
    void shouldGenerateUpdatesForLabelAdditionWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).existing(0, Values.of((Object)"Neo")).existing(1, Values.of((Object)100L)).existing(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_1, (Value[])new Value[]{PROPERTY_1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_2, (Value[])new Value[]{PROPERTY_2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_3, (Value[])new Value[]{PROPERTY_3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_123, (Value[])VALUES_123)});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdateForPartialCompositeSchemaIndexUpdate(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.index123()), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateWhenCompletingCompositeSchemaIndexUpdate(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).added(0, Values.of((Object)"Neo")).added(2, (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.index123()), EntityValueUpdatesTest.propertyLoader(PROPERTY_2), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index123(), (Value[])VALUES_123)});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotGenerateUpdatesForTokenRemovalWithNoProperties(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(EMPTY).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateForLabelRemovalWithExistingProperty() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(EMPTY).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.propertyLoader(PROPERTY_1), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_1, (Value[])new Value[]{PROPERTY_1.value()})});
    }

    @Test
    void shouldGenerateUpdatesForLabelRemovalWithExistingProperties() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(EMPTY).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_1, (Value[])new Value[]{PROPERTY_1.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_2, (Value[])new Value[]{PROPERTY_2.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_3, (Value[])new Value[]{PROPERTY_3.value()}), IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NODE_INDEX_123, (Value[])VALUES_123)});
    }

    @Test
    void shouldNotGenerateUpdatesForPropertyAdditionWithNoLabels() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.assertNoLoading(), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdatesForSinglePropertyAdditionWithToken(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index1(), (Value[])new Value[]{PROPERTY_1.value()})});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdatesForMultiplePropertyAdditionWithToken(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).added(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).added(PROPERTY_3.propertyKeyId(), PROPERTY_3.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(entity.indexes(), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index1(), (Value[])new Value[]{PROPERTY_1.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index2(), (Value[])new Value[]{PROPERTY_2.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index3(), (Value[])new Value[]{PROPERTY_3.value()}), IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.index123(), (Value[])VALUES_123)});
    }

    @Test
    void shouldNotGenerateUpdatesForLabelAddAndPropertyRemove() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).removed(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).removed(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).removed(PROPERTY_3.propertyKeyId(), PROPERTY_3.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.assertNoLoading(), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotGenerateUpdatesForLabelRemoveAndPropertyAdd() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(EMPTY).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).added(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).added(PROPERTY_3.propertyKeyId(), PROPERTY_3.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(NODE_INDEXES, EntityValueUpdatesTest.assertNoLoading(), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldNotLoadPropertyForNoTokenAndNoPropertyChanges(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.index1()), EntityValueUpdatesTest.assertNoLoading(), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotLoadPropertyForNoLabelsAndButPropertyAddition() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NODE_INDEX_1), EntityValueUpdatesTest.assertNoLoading(), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForPartialNonSchemaIndexUpdate(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).added(0, Values.of((Object)"Neo")).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])new Value[]{PROPERTY_1.value(), null, null})});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForFullNonSchemaIndexUpdate(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).added(PROPERTY_1.propertyKeyId(), PROPERTY_1.value()).added(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).added(PROPERTY_3.propertyKeyId(), PROPERTY_3.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(new StorageProperty[0]), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])VALUES_123)});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForSingleChangeNonSchemaIndex(Entity entity) {
        Value newValue2 = Values.of((Object)10L);
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).changed(PROPERTY_2.propertyKeyId(), PROPERTY_2.value(), newValue2).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])VALUES_123, (Value[])new Value[]{PROPERTY_1.value(), newValue2, PROPERTY_3.value()})});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateForAllChangedNonSchemaIndex(Entity entity) {
        Value newValue1 = Values.of((Object)"Nio");
        Value newValue2 = Values.of((Object)10L);
        PointValue newValue3 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{32.3, 15.6});
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).changed(PROPERTY_1.propertyKeyId(), PROPERTY_1.value(), newValue1).changed(PROPERTY_2.propertyKeyId(), PROPERTY_2.value(), newValue2).changed(PROPERTY_3.propertyKeyId(), PROPERTY_3.value(), (Value)newValue3).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])VALUES_123, (Value[])new Value[]{newValue1, newValue2, newValue3})});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateWhenRemovingLastPropForNonSchemaIndex(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).removed(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(PROPERTY_2), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])new Value[]{null, PROPERTY_2.value(), null})});
    }

    @ParameterizedTest
    @EnumSource(value=Entity.class)
    void shouldGenerateUpdateWhenRemovingOnePropertyForNonSchemaIndex(Entity entity) {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(TOKEN).removed(PROPERTY_2.propertyKeyId(), PROPERTY_2.value()).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(entity.nonSchemaIndex()), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), entity.type(), CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)entity.nonSchemaIndex(), (Value[])VALUES_123, (Value[])new Value[]{PROPERTY_1.value(), null, PROPERTY_3.value()})});
    }

    @Test
    void shouldGenerateUpdateWhenAddingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(TOKEN).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NON_SCHEMA_NODE_INDEX, (Value[])VALUES_123)});
    }

    @Test
    void shouldGenerateUpdateWhenAddingMultipleTokensForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(EMPTY).withTokensAfter(ALL_TOKENS).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)NON_SCHEMA_NODE_INDEX, (Value[])VALUES_123)});
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(ALL_TOKENS).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldNotGenerateUpdateWhenAddingAnotherUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(new long[]{0L, 2L}).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateWhenSwitchingToUselessTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(new long[]{2L}).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NON_SCHEMA_NODE_INDEX, (Value[])VALUES_123)});
    }

    @Test
    void shouldNotGenerateUpdateWhenRemovingOneTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(ALL_TOKENS).withTokensAfter(TOKEN).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).isEmpty();
    }

    @Test
    void shouldGenerateUpdateWhenRemovingLastTokenForNonSchemaIndex() {
        EntityUpdates updates = EntityUpdates.forEntity((long)0L, (boolean)false).withTokens(TOKEN).withTokensAfter(EMPTY).build();
        Assertions.assertThat((Iterable)updates.valueUpdatesForIndexKeys(Collections.singleton(NON_SCHEMA_NODE_INDEX), EntityValueUpdatesTest.propertyLoader(PROPERTY_1, PROPERTY_2, PROPERTY_3), EntityType.NODE, CursorContext.NULL, StoreCursors.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).contains((Object[])new IndexEntryUpdate[]{IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)NON_SCHEMA_NODE_INDEX, (Value[])VALUES_123)});
    }

    private static StorageReader propertyLoader(StorageProperty ... properties) {
        StubStorageCursors stub = new StubStorageCursors();
        for (StorageProperty property : properties) {
            stub.propertyKeyTokenHolder().addToken(new NamedToken(String.valueOf(property.propertyKeyId()), property.propertyKeyId()));
        }
        HashMap<String, Value> propertyMap = new HashMap<String, Value>();
        for (StorageProperty p : properties) {
            propertyMap.put(String.valueOf(p.propertyKeyId()), p.value());
        }
        stub.withNode(0L).properties(propertyMap);
        stub.withRelationship(0L, 1L, 1, 2L).properties(propertyMap);
        return stub;
    }

    private static StorageReader assertNoLoading() {
        StorageReader reader = (StorageReader)Mockito.mock(StorageReader.class);
        IllegalStateException exception = new IllegalStateException("Should never attempt to load properties!");
        Mockito.when((Object)reader.allocateNodeCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipScanCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocateRelationshipTraversalCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)reader.allocatePropertyCursor((CursorContext)ArgumentMatchers.any(), (StoreCursors)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any())).thenThrow(new Throwable[]{exception});
        return reader;
    }

    private static enum Entity {
        NODE{

            @Override
            List<SchemaDescriptorSupplier> indexes() {
                return NODE_INDEXES;
            }

            @Override
            EntityType type() {
                return EntityType.NODE;
            }

            @Override
            SchemaDescriptorSupplier index1() {
                return NODE_INDEX_1;
            }

            @Override
            SchemaDescriptorSupplier index2() {
                return NODE_INDEX_2;
            }

            @Override
            SchemaDescriptorSupplier index3() {
                return NODE_INDEX_3;
            }

            @Override
            SchemaDescriptorSupplier index123() {
                return NODE_INDEX_123;
            }

            @Override
            SchemaDescriptorSupplier nonSchemaIndex() {
                return NON_SCHEMA_NODE_INDEX;
            }
        }
        ,
        RELATIONSHIP{
            private final SchemaDescriptorSupplier index1 = () -> SchemaDescriptors.forRelType((int)0, (int[])new int[]{0});
            private final SchemaDescriptorSupplier index2 = () -> SchemaDescriptors.forRelType((int)0, (int[])new int[]{1});
            private final SchemaDescriptorSupplier index3 = () -> SchemaDescriptors.forRelType((int)0, (int[])new int[]{2});
            private final SchemaDescriptorSupplier index123 = () -> SchemaDescriptors.forLabel((int)0, (int[])new int[]{0, 1, 2});
            private final List<SchemaDescriptorSupplier> indexes = Arrays.asList(this.index1, this.index2, this.index3, this.index123);
            private final SchemaDescriptorSupplier nonSchemaIndex = () -> SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{0, 1}, (int[])new int[]{0, 1, 2});

            @Override
            List<SchemaDescriptorSupplier> indexes() {
                return this.indexes;
            }

            @Override
            EntityType type() {
                return EntityType.RELATIONSHIP;
            }

            @Override
            SchemaDescriptorSupplier index1() {
                return this.index1;
            }

            @Override
            SchemaDescriptorSupplier index2() {
                return this.index2;
            }

            @Override
            SchemaDescriptorSupplier index3() {
                return this.index3;
            }

            @Override
            SchemaDescriptorSupplier index123() {
                return this.index123;
            }

            @Override
            SchemaDescriptorSupplier nonSchemaIndex() {
                return this.nonSchemaIndex;
            }
        };


        abstract List<SchemaDescriptorSupplier> indexes();

        abstract EntityType type();

        abstract SchemaDescriptorSupplier index1();

        abstract SchemaDescriptorSupplier index2();

        abstract SchemaDescriptorSupplier index3();

        abstract SchemaDescriptorSupplier index123();

        abstract SchemaDescriptorSupplier nonSchemaIndex();
    }
}

