/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.test.FormatCompatibilityVerifier;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class IndexKeyStateFormatTest<KEY extends NativeIndexKey<KEY>>
extends FormatCompatibilityVerifier {
    protected static final int ENTITY_ID = 19570320;
    @RegisterExtension
    static PageCacheSupportExtension pageCacheExtension = new PageCacheSupportExtension();
    protected List<Value> values;

    IndexKeyStateFormatTest() {
    }

    @BeforeEach
    public void setup() {
        this.values = new ArrayList<Value>();
        this.populateValues(this.values);
    }

    abstract void populateValues(List<Value> var1);

    abstract Layout<KEY, ?> getLayout();

    abstract String toDetailedString(KEY var1);

    protected void createStoreFile(Path storeFile) throws IOException {
        this.withCursor(storeFile, true, c -> {
            this.putFormatVersion((PageCursor)c);
            this.putData((PageCursor)c);
        });
    }

    protected void verifyFormat(Path storeFile) throws FormatCompatibilityVerifier.FormatViolationException, IOException {
        AtomicReference exception = new AtomicReference();
        this.withCursor(storeFile, false, c -> {
            int major = c.getInt();
            int minor = c.getInt();
            Layout<KEY, ?> layout = this.getLayout();
            if (major != layout.majorVersion() || minor != layout.minorVersion()) {
                exception.set(new FormatCompatibilityVerifier.FormatViolationException(String.format("Read format version %d.%d, but layout has version %d.%d", major, minor, layout.majorVersion(), layout.minorVersion())));
            }
        });
        if (exception.get() != null) {
            throw (FormatCompatibilityVerifier.FormatViolationException)exception.get();
        }
    }

    protected void verifyContent(Path storeFile) throws IOException {
        this.withCursor(storeFile, false, c -> {
            IndexKeyStateFormatTest.readFormatVersion(c);
            this.verifyData((PageCursor)c);
        });
    }

    protected void initializeFromValue(KEY key, Value value) {
        key.initialize(19570320L);
        for (int i = 0; i < 2; ++i) {
            key.initFromValue(i, value, NativeIndexKey.Inclusion.NEUTRAL);
        }
    }

    protected String detailedFailureMessage(KEY actualKey, KEY expectedKey) {
        return "expected " + this.toDetailedString(expectedKey) + ", but was " + this.toDetailedString(actualKey);
    }

    private void withCursor(Path storeFile, boolean create, Consumer<PageCursor> cursorConsumer) throws IOException {
        ImmutableSet openOptions = create ? Sets.immutable.of((Object)StandardOpenOption.WRITE, (Object)StandardOpenOption.CREATE) : Sets.immutable.of((Object)StandardOpenOption.WRITE);
        try (PageCache pageCache = pageCacheExtension.getPageCache(this.globalFs);
             PagedFile pagedFile = pageCache.map(storeFile, pageCache.pageSize(), "neo4j", openOptions);
             PageCursor cursor = pagedFile.io(0L, 2, CursorContext.NULL);){
            cursor.next();
            cursorConsumer.accept(cursor);
        }
    }

    private void putFormatVersion(PageCursor cursor) {
        Layout<KEY, ?> layout = this.getLayout();
        int major = layout.majorVersion();
        cursor.putInt(major);
        int minor = layout.minorVersion();
        cursor.putInt(minor);
    }

    private void putData(PageCursor c) {
        Layout<KEY, ?> layout = this.getLayout();
        NativeIndexKey key = (NativeIndexKey)layout.newKey();
        for (Value value : this.values) {
            this.initializeFromValue(key, value);
            c.putInt(layout.keySize((Object)key));
            layout.writeKey(c, (Object)key);
        }
    }

    private void verifyData(PageCursor c) {
        Layout<KEY, ?> layout = this.getLayout();
        NativeIndexKey readCompositeKey = (NativeIndexKey)layout.newKey();
        NativeIndexKey comparison = (NativeIndexKey)layout.newKey();
        for (Value value : this.values) {
            int keySize = c.getInt();
            layout.readKey(c, (Object)readCompositeKey, keySize);
            for (Value readValue : readCompositeKey.asValues()) {
                this.initializeFromValue(comparison, value);
                Assertions.assertEquals((int)0, (int)layout.compare((Object)readCompositeKey, (Object)comparison), (String)this.detailedFailureMessage(readCompositeKey, comparison));
                if (readValue == Values.NO_VALUE) continue;
                Assertions.assertEquals((Object)value, (Object)readValue, (String)("expected read value to be " + value + ", but was " + readValue));
            }
        }
    }

    private static void readFormatVersion(PageCursor c) {
        c.getInt();
        c.getInt();
    }
}

