/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.IndexTestUtil;
import org.neo4j.kernel.impl.index.schema.NativeIndexHeaderReader;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.test.extension.pagecache.PageCacheSupportExtension;
import org.neo4j.test.utils.PageCacheConfig;

abstract class IndexPopulatorTests<KEY, VALUE, LAYOUT extends Layout<KEY, VALUE>>
extends IndexTestUtil<KEY, VALUE, LAYOUT> {
    static final NodePropertyAccessor null_property_accessor = (nodeId, propertyKeyId, cursorContext) -> {
        throw new RuntimeException("Did not expect an attempt to go to store");
    };
    IndexPopulator populator;

    IndexPopulatorTests() {
    }

    @BeforeEach
    void setupPopulator() throws IOException {
        this.populator = this.createPopulator(this.pageCache);
    }

    abstract IndexPopulator createPopulator(PageCache var1) throws IOException;

    abstract byte failureByte();

    abstract byte populatingByte();

    abstract byte onlineByte();

    @Test
    void createShouldCreateFile() throws IOException {
        this.assertFileNotPresent();
        this.populator.create();
        this.assertFilePresent();
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void createShouldClearExistingFile() throws Exception {
        byte[] someBytes = this.fileWithContent();
        this.populator.create();
        try (StoreFileChannel r = this.fs.read(this.indexFiles.getStoreFile());){
            byte[] firstBytes = new byte[someBytes.length];
            r.readAll(ByteBuffer.wrap(firstBytes));
            Assertions.assertNotEquals((Object)someBytes, (Object)firstBytes, (String)"Expected previous file content to have been cleared but was still there");
        }
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void dropShouldDeleteExistingFile() throws IOException {
        this.populator.create();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropShouldSucceedOnNonExistentFile() {
        this.assertFileNotPresent();
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void addShouldHandleEmptyCollection() throws Exception {
        this.populator.create();
        List updates = Collections.emptyList();
        this.populator.add(updates, CursorContext.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void successfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assertions.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(true, CursorContext.NULL);
        existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        Assertions.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    void successfulCloseMustMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(true, CursorContext.NULL);
        this.assertHeader(InternalIndexState.ONLINE, null, false);
    }

    @Test
    void unsuccessfulCloseMustSucceedWithoutMarkAsFailed() throws IOException {
        this.populator.create();
        this.populator.close(false, CursorContext.NULL);
    }

    @Test
    void unsuccessfulCloseMustCloseGBPTree() throws Exception {
        this.populator.create();
        Optional existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        if (existingMapping.isPresent()) {
            ((PagedFile)existingMapping.get()).close();
        } else {
            Assertions.fail((String)"Expected underlying GBPTree to have a mapping for this file");
        }
        this.populator.close(false, CursorContext.NULL);
        existingMapping = this.pageCache.getExistingMapping(this.indexFiles.getStoreFile());
        Assertions.assertFalse((boolean)existingMapping.isPresent());
    }

    @Test
    void unsuccessfulCloseMustNotMarkIndexAsOnline() throws Exception {
        this.populator.create();
        this.populator.close(false, CursorContext.NULL);
        this.assertHeader(InternalIndexState.POPULATING, null, false);
    }

    @Test
    void closeMustWriteFailureMessageAfterMarkedAsFailed() throws Exception {
        this.populator.create();
        String failureMessage = "Fly, you fools!";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, CursorContext.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    void closeMustWriteFailureMessageAfterMarkedAsFailedWithLongMessage() throws Exception {
        this.populator.create();
        String failureMessage = IndexPopulatorTests.longString(this.pageCache.pageSize());
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, CursorContext.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, true);
    }

    @Test
    void successfulCloseMustThrowIfMarkedAsFailed() throws IOException {
        this.populator.create();
        this.populator.markAsFailed("");
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, CursorContext.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
        this.populator.close(false, CursorContext.NULL);
    }

    @Test
    void dropMustSucceedAfterSuccessfulClose() throws IOException {
        this.populator.create();
        this.populator.close(true, CursorContext.NULL);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropMustSucceedAfterUnsuccessfulClose() throws IOException {
        this.populator.create();
        this.populator.close(false, CursorContext.NULL);
        this.populator.drop();
        this.assertFileNotPresent();
    }

    @Test
    void dropShouldNotFlushContent() throws IOException {
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        try (PageCache pageCache = PageCacheSupportExtension.getPageCache((FileSystemAbstraction)this.fs, (PageCacheConfig)PageCacheConfig.config().withTracer((PageCacheTracer)tracer));){
            this.populator = this.createPopulator(pageCache);
            this.populator.create();
            long preDrop = tracer.flushes();
            this.populator.drop();
            long postDrop = tracer.flushes();
            Assertions.assertEquals((long)preDrop, (long)postDrop);
        }
    }

    @Test
    void successfulCloseMustThrowWithoutPriorSuccessfulCreate() {
        this.assertFileNotPresent();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, CursorContext.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    @Test
    void unsuccessfulCloseMustSucceedWithoutSuccessfulPriorCreate() throws Exception {
        this.assertFileNotPresent();
        String failureMessage = "There is no spoon";
        this.populator.markAsFailed(failureMessage);
        this.populator.close(false, CursorContext.NULL);
        this.assertHeader(InternalIndexState.FAILED, failureMessage, false);
    }

    @Test
    void successfulCloseMustThrowAfterDrop() throws IOException {
        this.populator.create();
        this.populator.drop();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(true, CursorContext.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    @Test
    void unsuccessfulCloseMustThrowAfterDrop() throws IOException {
        this.populator.create();
        this.populator.drop();
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.populator.close(false, CursorContext.NULL));
        Assertions.assertTrue((boolean)ExceptionUtils.hasCause((Throwable)e, IllegalStateException.class), (String)("Expected cause to contain " + IllegalStateException.class));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assertHeader(InternalIndexState expectedState, String failureMessage, boolean messageTruncated) throws IOException {
        NativeIndexHeaderReader headerReader = new NativeIndexHeaderReader(this.failureByte());
        try (GBPTree ignored = new GBPTreeBuilder(this.pageCache, this.indexFiles.getStoreFile(), this.layout).with((Header.Reader)headerReader).build();){
            switch (expectedState) {
                case ONLINE: {
                    Assertions.assertEquals((byte)this.onlineByte(), (byte)headerReader.state, (String)"Index was not marked as online when expected not to be.");
                    Assertions.assertNull((Object)headerReader.failureMessage, (String)"Expected failure message to be null when marked as online.");
                    return;
                }
                case FAILED: {
                    Assertions.assertEquals((byte)this.failureByte(), (byte)headerReader.state, (String)"Index was marked as online when expected not to be.");
                    if (messageTruncated) {
                        Assertions.assertTrue((headerReader.failureMessage.length() < failureMessage.length() ? 1 : 0) != 0);
                        Assertions.assertTrue((boolean)failureMessage.startsWith(headerReader.failureMessage));
                        return;
                    } else {
                        Assertions.assertEquals((Object)failureMessage, (Object)headerReader.failureMessage);
                        return;
                    }
                }
                case POPULATING: {
                    Assertions.assertEquals((byte)this.populatingByte(), (byte)headerReader.state, (String)"Index was not left as populating when expected to be.");
                    Assertions.assertNull((Object)headerReader.failureMessage, (String)"Expected failure message to be null when marked as populating.");
                    return;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected index state " + expectedState);
                }
            }
        }
    }

    private static String longString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    private byte[] fileWithContent() throws IOException {
        int size = 1000;
        this.indexFiles.ensureDirectoryExist();
        try (StoreFileChannel storeChannel = this.fs.write(this.indexFiles.getStoreFile());){
            byte[] someBytes = new byte[size];
            new Random().nextBytes(someBytes);
            storeChannel.writeAll(ByteBuffer.wrap(someBytes));
            byte[] byArray = someBytes;
            return byArray;
        }
    }
}

