/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.RangeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.RangeLayout;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

class RangeIndexAccessorTest
extends GenericNativeIndexAccessorTests<RangeKey> {
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)42, (int[])new int[]{666})).withIndexType(IndexType.RANGE).withIndexProvider(RangeIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
    private static final ValueType[] SUPPORTED_TYPES = ValueType.values();
    private static final RangeLayout LAYOUT = new RangeLayout(1);
    private static final IndexCapability INDEX_CAPABILITY = RangeIndexProvider.CAPABILITY;

    RangeIndexAccessorTest() {
    }

    NativeIndexAccessor<RangeKey> createAccessor(PageCache pageCache) {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new RangeIndexAccessor(context, this.indexFiles, (IndexLayout)this.layout, cleanup, INDEX_DESCRIPTOR, this.tokenNameLookup);
    }

    @Override
    IndexCapability indexCapability() {
        return INDEX_CAPABILITY;
    }

    @Override
    boolean supportsGeometryRangeQueries() {
        return false;
    }

    @Override
    ValueCreatorUtil<RangeKey> createValueCreatorUtil() {
        return new ValueCreatorUtil<RangeKey>(INDEX_DESCRIPTOR, SUPPORTED_TYPES, 0.1);
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return INDEX_DESCRIPTOR;
    }

    @Override
    RangeLayout layout() {
        return LAYOUT;
    }

    @Test
    void readerShouldThrowOnGeometryRangeQueries() {
        PropertyIndexQuery.RangePredicate geometryRangePredicate = PropertyIndexQuery.range((int)0, (CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian);
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{geometryRangePredicate}));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Tried to query index with illegal query. Geometry range predicate is not allowed");
        }
    }

    @Test
    void readerShouldThrowOnStringSuffixQueries() {
        PropertyIndexQuery.StringSuffixPredicate suffixPredicate = PropertyIndexQuery.stringSuffix((int)0, (TextValue)Values.stringValue((String)"myValue"));
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{suffixPredicate}));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Tried to query index with illegal query. STRING_SUFFIX predicate is not allowed");
        }
    }

    @Test
    void readerShouldThrowOnStringContainsQueries() {
        PropertyIndexQuery.StringContainsPredicate containsPredicate = PropertyIndexQuery.stringContains((int)0, (TextValue)Values.stringValue((String)"myValue"));
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            IllegalArgumentException e = (IllegalArgumentException)org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{containsPredicate}));
            Assertions.assertThat((Throwable)e).hasMessageContaining("Tried to query index with illegal query. STRING_CONTAINS predicate is not allowed");
        }
    }

    @Test
    void shouldRespectIndexOrderForGeometryTypes() throws Exception {
        int nUpdates = 10000;
        ValueType[] types = this.supportedTypesForGeometry();
        Iterator<ValueIndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random, types);
        ValueIndexEntryUpdate[] someUpdates = new ValueIndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Value[] allValues = ValueCreatorUtil.extractValuesFromUpdates(someUpdates);
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            PropertyIndexQuery.ExistsPredicate exists = PropertyIndexQuery.exists((int)0);
            RangeIndexAccessorTest.expectIndexOrder(allValues, reader, IndexOrder.ASCENDING, exists);
            RangeIndexAccessorTest.expectIndexOrder(allValues, reader, IndexOrder.DESCENDING, exists);
        }
    }

    private static void expectIndexOrder(Value[] allValues, ValueIndexReader reader, IndexOrder supportedOrder, PropertyIndexQuery.ExistsPredicate supportedQuery) throws IndexNotApplicableKernelException {
        if (supportedOrder == IndexOrder.ASCENDING) {
            Arrays.sort(allValues, Values.COMPARATOR);
        } else if (supportedOrder == IndexOrder.DESCENDING) {
            Arrays.sort(allValues, Values.COMPARATOR.reversed());
        }
        SimpleEntityValueClient client = new SimpleEntityValueClient();
        reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.constrained((IndexOrder)supportedOrder, (boolean)true), new PropertyIndexQuery[]{supportedQuery});
        int i = 0;
        while (client.next()) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)allValues[i++], (Object)client.values[0], (String)"values in order");
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)i, (int)allValues.length, (String)"found all values");
    }

    private ValueType[] supportedTypesForGeometry() {
        return RandomValues.excluding((ValueType[])this.valueCreatorUtil.supportedTypes(), t -> t.valueGroup != ValueGroup.GEOMETRY && t.valueGroup != ValueGroup.GEOMETRY_ARRAY);
    }
}

