/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.Write;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.helpers.StubCursorFactory;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubRead;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.index.schema.FulltextIndexProviderFactory;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipScanCursor;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.logging.Level;
import org.neo4j.logging.SecurityLogHelper;
import org.neo4j.logging.log4j.LogExtended;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Values;
import org.opentest4j.AssertionFailedError;

abstract class OperationsTest {
    protected static final long TOKEN_INDEX_RESOURCE_ID = Long.MAX_VALUE;
    protected final KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
    protected Operations operations;
    protected final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);
    protected final Write write = (Write)Mockito.mock(Write.class);
    protected InOrder order;
    protected FullAccessNodeCursor nodeCursor;
    protected FullAccessPropertyCursor propertyCursor;
    protected DefaultRelationshipScanCursor relationshipCursor;
    protected TransactionState txState;
    protected AllStoreHolder allStoreHolder;
    protected final LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)123, (int[])new int[]{456});
    protected StorageReader storageReader;
    protected StorageSchemaReader storageReaderSnapshot;
    protected ConstraintIndexCreator constraintIndexCreator;
    protected IndexingService indexingService;
    protected TokenHolders tokenHolders;
    protected CommandCreationContext creationContext;
    protected SecurityLogHelper logHelper;
    protected CommunitySecurityLog securityLog;
    protected StorageLocks storageLocks;
    protected static final String DB_NAME = "db.test";
    private StoreCursors storeCursors;

    OperationsTest() {
    }

    abstract FormattedLogFormat getFormat();

    @BeforeEach
    void setUp() throws Exception {
        TxState realTxState = new TxState();
        this.txState = (TransactionState)Mockito.spy((Object)realTxState);
        this.storeCursors = (StoreCursors)Mockito.mock(StoreCursors.class);
        Mockito.when((Object)this.transaction.getReasonIfTerminated()).thenReturn(Optional.empty());
        Mockito.when((Object)this.transaction.lockClient()).thenReturn((Object)this.locks);
        Mockito.when((Object)this.transaction.dataWrite()).thenReturn((Object)this.write);
        Mockito.when((Object)this.transaction.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.lockTracer()).thenReturn((Object)LockTracer.NONE);
        Mockito.when((Object)this.transaction.txState()).thenReturn((Object)this.txState);
        Mockito.when((Object)this.transaction.storeCursors()).thenReturn((Object)this.storeCursors);
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)SecurityContext.authDisabled((AccessMode)AccessMode.Static.FULL, (ClientConnectionInfo)ClientConnectionInfo.EMBEDDED_CONNECTION, (String)DB_NAME));
        this.logHelper = new SecurityLogHelper(this.getFormat());
        this.securityLog = new CommunitySecurityLog((LogExtended)this.logHelper.getLogProvider().getLog(this.getClass()));
        Mockito.when((Object)this.transaction.securityAuthorizationHandler()).thenReturn((Object)new SecurityAuthorizationHandler((AbstractSecurityLog)this.securityLog));
        DefaultPooledCursors cursors = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
        this.nodeCursor = (FullAccessNodeCursor)Mockito.mock(FullAccessNodeCursor.class);
        this.propertyCursor = (FullAccessPropertyCursor)Mockito.mock(FullAccessPropertyCursor.class);
        this.relationshipCursor = (DefaultRelationshipScanCursor)Mockito.mock(DefaultRelationshipScanCursor.class);
        Mockito.when((Object)cursors.allocateFullAccessNodeCursor(CursorContext.NULL)).thenReturn((Object)this.nodeCursor);
        Mockito.when((Object)cursors.allocateFullAccessPropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).thenReturn((Object)this.propertyCursor);
        Mockito.when((Object)cursors.allocateRelationshipScanCursor(CursorContext.NULL)).thenReturn((Object)this.relationshipCursor);
        StorageEngine engine = (StorageEngine)Mockito.mock(StorageEngine.class);
        this.storageReader = (StorageReader)Mockito.mock(StorageReader.class);
        this.storageReaderSnapshot = (StorageSchemaReader)Mockito.mock(StorageSchemaReader.class);
        Mockito.when((Object)this.storageReader.nodeExists(ArgumentMatchers.anyLong(), (StoreCursors)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.constraintsGetForLabel(ArgumentMatchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.schemaSnapshot()).thenReturn((Object)this.storageReaderSnapshot);
        Mockito.when((Object)engine.newReader()).thenReturn((Object)this.storageReader);
        Mockito.when((Object)engine.createStorageCursors((CursorContext)ArgumentMatchers.any())).thenReturn((Object)this.storeCursors);
        this.indexingService = (IndexingService)Mockito.mock(IndexingService.class);
        Dependencies dependencies = new Dependencies();
        GraphDatabaseFacade facade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
        dependencies.satisfyDependency((Object)facade);
        this.storageLocks = (StorageLocks)Mockito.mock(StorageLocks.class);
        this.allStoreHolder = new AllStoreHolder(this.storageReader, this.transaction, this.storageLocks, cursors, (GlobalProcedures)Mockito.mock(GlobalProcedures.class), (SchemaState)Mockito.mock(SchemaState.class), this.indexingService, (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class), dependencies, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.constraintIndexCreator = (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class);
        this.tokenHolders = OperationsTest.mockedTokenHolders();
        this.creationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        IndexingProvidersService indexingProvidersService = (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("native-btree-1.0")).thenReturn((Object)GenericNativeIndexProvider.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.getDefaultProvider()).thenReturn((Object)GenericNativeIndexProvider.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("fulltext-1.0")).thenReturn((Object)FulltextIndexProviderFactory.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.getFulltextProvider()).thenReturn((Object)FulltextIndexProviderFactory.DESCRIPTOR);
        Mockito.when((Object)indexingProvidersService.indexProviderByName("provider-1.0")).thenReturn((Object)new IndexProviderDescriptor("provider", "1.0"));
        Mockito.when((Object)indexingProvidersService.completeConfiguration((IndexDescriptor)ArgumentMatchers.any())).thenAnswer(inv -> inv.getArgument(0));
        this.operations = new Operations(this.allStoreHolder, this.storageReader, (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), this.creationContext, this.storageLocks, this.transaction, new KernelToken(this.storageReader, this.creationContext, this.transaction, this.tokenHolders), cursors, this.constraintIndexCreator, (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), indexingProvidersService, Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        this.operations.initialize(CursorContext.NULL);
        this.order = Mockito.inOrder((Object[])new Object[]{this.locks, this.txState, this.storageReader, this.storageReaderSnapshot, this.creationContext, this.storageLocks});
    }

    @AfterEach
    void tearDown() {
        this.operations.release();
    }

    @Test
    void nodeAddLabelShouldFailReadOnly() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.READ, false);
        String expected = String.format("Set label for label 'Label' on database '%s' is not allowed for AUTH_DISABLED with READ.", DB_NAME);
        Assertions.assertThat((String)message).contains(new CharSequence[]{expected});
        this.logHelper.assertLog(this.getFormat()).containsOrdered(new SecurityLogHelper.LogLineContent[]{SecurityLogHelper.line().level(Level.ERROR).database(DB_NAME).source(ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails()).message(expected)});
    }

    @Test
    void nodeAddLabelShouldFailAccess() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.ACCESS, false);
        String expected = String.format("Set label for label 'Label' on database '%s' is not allowed for AUTH_DISABLED with ACCESS.", DB_NAME);
        Assertions.assertThat((String)message).contains(new CharSequence[]{expected});
        this.logHelper.assertLog(this.getFormat()).containsOrdered(new SecurityLogHelper.LogLineContent[]{SecurityLogHelper.line().level(Level.ERROR).database(DB_NAME).source(ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails()).message(expected)});
    }

    @Test
    void nodeRemoveLabelShouldFailReadOnly() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.READ, false);
        String expected = String.format("Remove label for label 'Label' on database '%s' is not allowed for AUTH_DISABLED with READ.", DB_NAME);
        Assertions.assertThat((String)message).contains(new CharSequence[]{expected});
        this.logHelper.assertLog(this.getFormat()).containsOrdered(new SecurityLogHelper.LogLineContent[]{SecurityLogHelper.line().level(Level.ERROR).database(DB_NAME).source(ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails()).message(expected)});
    }

    @Test
    void nodeRemoveLabelShouldFailAccess() throws Exception {
        String message = this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.ACCESS, false);
        String expected = String.format("Remove label for label 'Label' on database '%s' is not allowed for AUTH_DISABLED with ACCESS.", DB_NAME);
        Assertions.assertThat((String)message).contains(new CharSequence[]{expected});
        this.logHelper.assertLog(this.getFormat()).containsOrdered(new SecurityLogHelper.LogLineContent[]{SecurityLogHelper.line().level(Level.ERROR).database(DB_NAME).source(ClientConnectionInfo.EMBEDDED_CONNECTION.asConnectionDetails()).message(expected)});
    }

    @Test
    void nodeApplyChangesShouldLockNodeAndLabels() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)Labels.from((long[])new long[]{1L, 2L}));
        long node = 1L;
        this.operations.nodeApplyChanges(node, (IntSet)IntSets.immutable.of(3), (IntSet)IntSets.immutable.of(1), (IntObjectMap)IntObjectMaps.immutable.of(1, (Object)Values.intValue((int)10)));
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.NODE), new long[]{ArgumentMatchers.eq((long)1L)});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.LABEL), new long[]{ArgumentMatchers.eq((long)1L)});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.LABEL), new long[]{ArgumentMatchers.eq((long)3L)});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.LABEL), new long[]{ArgumentMatchers.eq((long)Long.MAX_VALUE)});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.LABEL), new long[]{ArgumentMatchers.eq((long)1L), ArgumentMatchers.eq((long)2L)});
        ((StorageLocks)Mockito.verify((Object)this.storageLocks)).acquireNodeLabelChangeLock((LockTracer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)node), ArgumentMatchers.eq((int)1));
        ((StorageLocks)Mockito.verify((Object)this.storageLocks)).acquireNodeLabelChangeLock((LockTracer)ArgumentMatchers.any(), ArgumentMatchers.eq((long)node), ArgumentMatchers.eq((int)3));
    }

    @Test
    void relationshipApplyChangesShouldLockRelationshipAndType() throws Exception {
        int type = 5;
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipCursor.type()).thenReturn((Object)type);
        long relationship = 1L;
        this.operations.relationshipApplyChanges(relationship, (IntObjectMap)IntObjectMaps.immutable.of(1, (Object)Values.intValue((int)10)));
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.RELATIONSHIP), new long[]{ArgumentMatchers.eq((long)1L)});
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireShared((LockTracer)ArgumentMatchers.any(), (ResourceType)ArgumentMatchers.eq((Object)ResourceTypes.RELATIONSHIP_TYPE), new long[]{ArgumentMatchers.eq((long)type)});
    }

    protected String runForSecurityLevel(Executable executable, AccessMode mode, boolean shoudldBeAuthorized) throws Exception {
        SecurityContext securityContext = SecurityContext.authDisabled((AccessMode)mode, (ClientConnectionInfo)ClientConnectionInfo.EMBEDDED_CONNECTION, (String)DB_NAME);
        Mockito.when((Object)this.transaction.securityContext()).thenReturn((Object)securityContext);
        Mockito.when((Object)this.transaction.securityAuthorizationHandler()).thenReturn((Object)new SecurityAuthorizationHandler((AbstractSecurityLog)this.securityLog));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.hasLabel(2)).thenReturn((Object)false);
        Mockito.when((Object)this.nodeCursor.hasLabel(3)).thenReturn((Object)true);
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 2));
        if (shoudldBeAuthorized) {
            OperationsTest.assertAuthorized(executable);
            return null;
        }
        AuthorizationViolationException exception = (AuthorizationViolationException)org.junit.jupiter.api.Assertions.assertThrows(AuthorizationViolationException.class, (Executable)executable);
        return exception.getMessage();
    }

    private static void assertAuthorized(Executable executable) {
        try {
            executable.execute();
        }
        catch (AuthorizationViolationException e) {
            throw new AssertionFailedError(e.getMessage(), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
        }
        catch (Throwable t) {
            throw new AssertionFailedError("Unexpected exception thrown: " + t.getMessage(), t);
        }
    }

    private static TokenHolders mockedTokenHolders() {
        return new TokenHolders((TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class), (TokenHolder)Mockito.mock(TokenHolder.class));
    }

    public static void returnRelationships(KernelTransactionImplementation ktx, TestRelationshipChain relIds) {
        StubRead read = new StubRead();
        Mockito.when((Object)ktx.dataRead()).thenReturn((Object)read);
        StubCursorFactory cursorFactory = new StubCursorFactory(true);
        cursorFactory.withRelationshipTraversalCursors(new RelationshipTraversalCursor[]{new StubRelationshipCursor(relIds)});
        Mockito.when((Object)ktx.lockTracer()).thenReturn((Object)LockTracer.NONE);
        Mockito.when((Object)ktx.cursors()).thenReturn((Object)cursorFactory);
        Mockito.when((Object)ktx.ambientNodeCursor()).thenAnswer(args -> new StubNodeCursor(false).withNode(42L));
    }
}

