/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.schema.TextIndexProvider;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.PointIndexProvider;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.index.schema.fusion.FusionIndexProvider;
import org.neo4j.kernel.impl.transaction.state.StaticIndexProviderMap;

class StaticIndexProviderMapTest {
    StaticIndexProviderMapTest() {
    }

    @Test
    void testGetters() throws Exception {
        TokenIndexProvider tokenIndexProvider = StaticIndexProviderMapTest.mockProvider(TokenIndexProvider.class);
        GenericNativeIndexProvider btreeIndexProvider = StaticIndexProviderMapTest.mockProvider(GenericNativeIndexProvider.class);
        FusionIndexProvider fusionIndexProvider = StaticIndexProviderMapTest.mockProvider(FusionIndexProvider.class);
        TextIndexProvider textIndexProvider = StaticIndexProviderMapTest.mockProvider(TextIndexProvider.class);
        FulltextIndexProvider fulltextIndexProvider = StaticIndexProviderMapTest.mockProvider(FulltextIndexProvider.class);
        RangeIndexProvider rangeIndexProvider = StaticIndexProviderMapTest.mockProvider(RangeIndexProvider.class);
        PointIndexProvider pointIndexProvider = StaticIndexProviderMapTest.mockProvider(PointIndexProvider.class);
        StaticIndexProviderMap map = new StaticIndexProviderMap(tokenIndexProvider, btreeIndexProvider, fusionIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider, Config.newBuilder().build(), (DependencyResolver)new Dependencies());
        map.init();
        Assertions.assertThat((Object)map.getTextIndexProvider()).isEqualTo((Object)textIndexProvider);
        Assertions.assertThat((Object)map.getFulltextProvider()).isEqualTo((Object)fulltextIndexProvider);
        Assertions.assertThat((Object)map.getTokenIndexProvider()).isEqualTo((Object)tokenIndexProvider);
        Assertions.assertThat((Object)map.getDefaultProvider()).isEqualTo((Object)btreeIndexProvider);
        Assertions.assertThat((Object)map.getRangeIndexProvider()).isEqualTo((Object)rangeIndexProvider);
        Assertions.assertThat((Object)map.getPointIndexProvider()).isEqualTo((Object)pointIndexProvider);
    }

    @Test
    void testLookup() throws Exception {
        TokenIndexProvider tokenIndexProvider = StaticIndexProviderMapTest.mockProvider(TokenIndexProvider.class);
        GenericNativeIndexProvider btreeIndexProvider = StaticIndexProviderMapTest.mockProvider(GenericNativeIndexProvider.class);
        FusionIndexProvider fusionIndexProvider = StaticIndexProviderMapTest.mockProvider(FusionIndexProvider.class);
        TextIndexProvider textIndexProvider = StaticIndexProviderMapTest.mockProvider(TextIndexProvider.class);
        FulltextIndexProvider fulltextIndexProvider = StaticIndexProviderMapTest.mockProvider(FulltextIndexProvider.class);
        RangeIndexProvider rangeIndexProvider = StaticIndexProviderMapTest.mockProvider(RangeIndexProvider.class);
        PointIndexProvider pointIndexProvider = StaticIndexProviderMapTest.mockProvider(PointIndexProvider.class);
        StaticIndexProviderMap map = new StaticIndexProviderMap(tokenIndexProvider, btreeIndexProvider, fusionIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider, Config.newBuilder().build(), (DependencyResolver)new Dependencies());
        map.init();
        Arrays.asList(tokenIndexProvider, btreeIndexProvider, fusionIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider).forEach(p -> {
            Assertions.assertThat((Object)map.lookup(p.getProviderDescriptor())).isEqualTo(p);
            Assertions.assertThat((Object)map.lookup(p.getProviderDescriptor().name())).isEqualTo(p);
        });
    }

    @Test
    void testAccept() throws Exception {
        TokenIndexProvider tokenIndexProvider = StaticIndexProviderMapTest.mockProvider(TokenIndexProvider.class);
        GenericNativeIndexProvider btreeIndexProvider = StaticIndexProviderMapTest.mockProvider(GenericNativeIndexProvider.class);
        FusionIndexProvider fusionIndexProvider = StaticIndexProviderMapTest.mockProvider(FusionIndexProvider.class);
        TextIndexProvider textIndexProvider = StaticIndexProviderMapTest.mockProvider(TextIndexProvider.class);
        FulltextIndexProvider fulltextIndexProvider = StaticIndexProviderMapTest.mockProvider(FulltextIndexProvider.class);
        RangeIndexProvider rangeIndexProvider = StaticIndexProviderMapTest.mockProvider(RangeIndexProvider.class);
        PointIndexProvider pointIndexProvider = StaticIndexProviderMapTest.mockProvider(PointIndexProvider.class);
        StaticIndexProviderMap map = new StaticIndexProviderMap(tokenIndexProvider, btreeIndexProvider, fusionIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider, Config.newBuilder().build(), (DependencyResolver)new Dependencies());
        map.init();
        ArrayList accepted = new ArrayList();
        map.accept(accepted::add);
        Assertions.assertThat(accepted).containsExactlyInAnyOrder(new Object[]{tokenIndexProvider, btreeIndexProvider, fusionIndexProvider, textIndexProvider, fulltextIndexProvider, rangeIndexProvider, pointIndexProvider});
    }

    @Test
    void testWithExtension() throws Exception {
        IndexProvider extension = StaticIndexProviderMapTest.mockProvider(IndexProvider.class);
        Dependencies dependencies = new Dependencies();
        dependencies.satisfyDependency((Object)extension);
        Config config = Config.newBuilder().set(GraphDatabaseSettings.default_schema_provider, (Object)extension.getProviderDescriptor().name()).build();
        StaticIndexProviderMap map = new StaticIndexProviderMap(StaticIndexProviderMapTest.mockProvider(TokenIndexProvider.class), StaticIndexProviderMapTest.mockProvider(GenericNativeIndexProvider.class), StaticIndexProviderMapTest.mockProvider(FusionIndexProvider.class), StaticIndexProviderMapTest.mockProvider(TextIndexProvider.class), StaticIndexProviderMapTest.mockProvider(FulltextIndexProvider.class), StaticIndexProviderMapTest.mockProvider(RangeIndexProvider.class), StaticIndexProviderMapTest.mockProvider(PointIndexProvider.class), config, (DependencyResolver)dependencies);
        map.init();
        Assertions.assertThat((Object)map.getDefaultProvider()).isEqualTo((Object)extension);
        Assertions.assertThat((Object)map.lookup(extension.getProviderDescriptor())).isEqualTo((Object)extension);
        Assertions.assertThat((Object)map.lookup(extension.getProviderDescriptor().name())).isEqualTo((Object)extension);
        ArrayList accepted = new ArrayList();
        map.accept(accepted::add);
        Assertions.assertThat(accepted).contains(new Object[]{extension});
    }

    private static <T extends IndexProvider> T mockProvider(Class<? extends T> clazz) {
        IndexProvider mock = (IndexProvider)Mockito.mock(clazz);
        Mockito.when((Object)mock.getProviderDescriptor()).thenReturn((Object)new IndexProviderDescriptor(clazz.getName(), "o_O"));
        return (T)mock;
    }
}

