/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapReference;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexPopulationJobController;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexProxyCreator;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexUpdaterMap;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.kernel.impl.transaction.state.storeview.IndexStoreViewFactory;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;

public class IndexingService
extends LifecycleAdapter
implements IndexUpdateListener,
IndexingProvidersService {
    private static final String INDEX_SERVICE_INDEX_CLOSING_TAG = "indexServiceIndexClosing";
    private final IndexSamplingController samplingController;
    private final IndexProxyCreator indexProxyCreator;
    private final IndexProviderMap providerMap;
    private final IndexMapReference indexMapRef;
    private final Iterable<IndexDescriptor> indexDescriptors;
    private final Log internalLog;
    private final Log userLog;
    private final IndexStatisticsStore indexStatisticsStore;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private final String databaseName;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final Config config;
    private final TokenNameLookup tokenNameLookup;
    private final JobScheduler jobScheduler;
    private final LogProvider internalLogProvider;
    private final IndexMonitor monitor;
    private final SchemaState schemaState;
    private final IndexPopulationJobController populationJobController;
    private static final String INIT_TAG = "Initialize IndexingService";
    private final IndexStoreView storeView;
    private volatile State state = State.NOT_STARTED;

    IndexingService(IndexProxyCreator indexProxyCreator, IndexProviderMap providerMap, IndexMapReference indexMapRef, IndexStoreViewFactory indexStoreViewFactory, Iterable<IndexDescriptor> indexDescriptors, IndexSamplingController samplingController, TokenNameLookup tokenNameLookup, JobScheduler scheduler, SchemaState schemaState, LogProvider internalLogProvider, LogProvider userLogProvider, IndexMonitor monitor, IndexStatisticsStore indexStatisticsStore, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker, String databaseName, DatabaseReadOnlyChecker readOnlyChecker, Config config) {
        this.indexProxyCreator = indexProxyCreator;
        this.providerMap = providerMap;
        this.indexMapRef = indexMapRef;
        this.indexDescriptors = indexDescriptors;
        this.samplingController = samplingController;
        this.tokenNameLookup = tokenNameLookup;
        this.jobScheduler = scheduler;
        this.schemaState = schemaState;
        this.internalLogProvider = internalLogProvider;
        this.monitor = monitor;
        this.populationJobController = new IndexPopulationJobController(scheduler);
        this.internalLog = internalLogProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
        this.indexStatisticsStore = indexStatisticsStore;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.databaseName = databaseName;
        this.readOnlyChecker = readOnlyChecker;
        this.config = config;
        this.storeView = indexStoreViewFactory.createTokenIndexStoreView(descriptor -> indexMapRef.getIndexProxy(descriptor.getId()));
    }

    public void init() throws IOException {
        this.validateDefaultProviderExisting();
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(INIT_TAG));){
            this.indexMapRef.modify(indexMap -> {
                EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
                for (IndexDescriptor descriptor : this.indexDescriptors) {
                    IndexProxy indexProxy;
                    if (descriptor.getName().equals("__org_neo4j_schema_index_label_scan_store_converted_to_token_index") && (!descriptor.schema().isAnyTokenSchemaDescriptor() || descriptor.schema().entityType() != EntityType.NODE)) {
                        throw new IllegalStateException("Index '" + descriptor.userDescription(this.tokenNameLookup) + "' is using a reserved name: '__org_neo4j_schema_index_label_scan_store_converted_to_token_index'. This index must be removed on an earlier version to be able to use binaries for version 4.3 or newer.");
                    }
                    IndexProviderDescriptor providerDescriptor = descriptor.getIndexProvider();
                    IndexProvider provider = this.providerMap.lookup(providerDescriptor);
                    InternalIndexState initialState = provider.getInitialState(descriptor, cursorContext);
                    indexStates.computeIfAbsent(initialState, internalIndexState -> new ArrayList()).add(new IndexLogRecord(descriptor));
                    this.internalLog.debug(this.indexStateInfo("init", initialState, descriptor));
                    switch (initialState) {
                        case ONLINE: {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.ONLINE);
                            indexProxy = this.indexProxyCreator.createOnlineIndexProxy(descriptor);
                            break;
                        }
                        case POPULATING: {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.POPULATING);
                            indexProxy = this.indexProxyCreator.createRecoveringIndexProxy(descriptor);
                            break;
                        }
                        case FAILED: {
                            this.monitor.initialState(this.databaseName, descriptor, InternalIndexState.FAILED);
                            IndexPopulationFailure failure = IndexPopulationFailure.failure(provider.getPopulationFailure(descriptor, cursorContext));
                            indexProxy = this.indexProxyCreator.createFailedIndexProxy(descriptor, failure);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("" + initialState);
                        }
                    }
                    indexMap.putIndexProxy(indexProxy);
                }
                this.logIndexStateSummary("init", indexStates);
                return indexMap;
            });
        }
        this.indexStatisticsStore.init();
    }

    private void validateDefaultProviderExisting() {
        if (this.providerMap == null || this.providerMap.getDefaultProvider() == null) {
            throw new IllegalStateException("You cannot run the database without an index provider, please make sure that a valid provider (subclass of " + IndexProvider.class.getName() + ") is on your classpath.");
        }
    }

    public void start() throws Exception {
        this.state = State.STARTING;
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("refresh", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)IndexProxy::refresh)));
        LongObjectHashMap rebuildingDescriptors = new LongObjectHashMap();
        this.indexMapRef.modify(arg_0 -> this.lambda$start$4((MutableLongObjectMap)rebuildingDescriptors, arg_0));
        this.indexStatisticsStore.start();
        this.samplingController.recoverIndexSamples();
        this.samplingController.start();
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, index) -> {
            IndexProxy proxy;
            if (!index.isUnique()) {
                return;
            }
            try {
                proxy = this.getIndexProxy((IndexDescriptor)index);
            }
            catch (IndexNotFoundKernelException e) {
                throw new IllegalStateException("What? This index was seen during recovery just now, why isn't it available now?", e);
            }
            if (proxy.getDescriptor().getOwningConstraintId().isEmpty()) {
                return;
            }
            this.monitor.awaitingPopulationOfRecoveredIndex(index);
            this.awaitOnlineAfterRecovery(proxy);
        });
        this.state = State.RUNNING;
    }

    private void dontRebuildIndexesInReadOnlyMode(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors) {
        if (this.readOnlyChecker.isReadOnly() && rebuildingDescriptors.notEmpty()) {
            String indexString = rebuildingDescriptors.values().stream().map(String::valueOf).collect(Collectors.joining(", ", "{", "}"));
            throw new IllegalStateException("Some indexes need to be rebuilt. This is not allowed in read only mode. Please start db in writable mode to rebuild indexes. Indexes needing rebuild: " + indexString);
        }
    }

    private void populateIndexesOfAllTypes(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors, IndexMap indexMap) {
        EnumMap<EntityType, MutableLongObjectMap> rebuildingDescriptorsByType = new EnumMap<EntityType, MutableLongObjectMap>(EntityType.class);
        for (IndexDescriptor descriptor : rebuildingDescriptors) {
            rebuildingDescriptorsByType.computeIfAbsent(descriptor.schema().entityType(), type -> new LongObjectHashMap()).put(descriptor.getId(), (Object)descriptor);
        }
        for (Map.Entry descriptorToPopulate : rebuildingDescriptorsByType.entrySet()) {
            IndexPopulationJob populationJob = this.newIndexPopulationJob((EntityType)descriptorToPopulate.getKey(), false, Subject.SYSTEM);
            this.populate((MutableLongObjectMap<IndexDescriptor>)((MutableLongObjectMap)descriptorToPopulate.getValue()), indexMap, populationJob);
        }
    }

    private void populate(MutableLongObjectMap<IndexDescriptor> rebuildingDescriptors, IndexMap indexMap, IndexPopulationJob populationJob) {
        rebuildingDescriptors.forEachKeyValue((LongObjectProcedure & Serializable)(indexId, descriptor) -> {
            IndexProxy proxy = this.indexProxyCreator.createPopulatingIndexProxy((IndexDescriptor)descriptor, this.monitor, populationJob);
            proxy.start();
            indexMap.putIndexProxy(proxy);
        });
        this.startIndexPopulation(populationJob);
    }

    private void awaitOnlineAfterRecovery(IndexProxy proxy) {
        block7: while (true) {
            switch (1.$SwitchMap$org$neo4j$internal$kernel$api$InternalIndexState[proxy.getState().ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    String message = String.format("Index %s entered %s state while recovery waited for it to be fully populated.", proxy.getDescriptor(), InternalIndexState.FAILED);
                    IndexPopulationFailure populationFailure = proxy.getPopulationFailure();
                    String causeOfFailure = populationFailure.asString();
                    this.internalLog.info(IndexPopulationFailure.appendCauseOfFailure(message, causeOfFailure));
                    return;
                }
                case 3: {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Waiting for index to become ONLINE was interrupted", e);
                    }
                }
                continue block7;
            }
            break;
        }
        throw new IllegalStateException(proxy.getState().name());
    }

    public void stop() throws Exception {
        this.samplingController.stop();
        this.populationJobController.stop();
        this.indexStatisticsStore.stop();
    }

    public void shutdown() throws IOException {
        this.state = State.STOPPED;
        this.closeAllIndexes();
        this.indexStatisticsStore.shutdown();
    }

    @Override
    public void validateBeforeCommit(IndexDescriptor index, Value[] tuple, long entityId) {
        this.indexMapRef.validateBeforeCommit(index, tuple, entityId);
    }

    @Override
    public void validateIndexPrototype(IndexPrototype prototype) {
        IndexProvider provider = this.providerMap.lookup(prototype.getIndexProvider());
        provider.validatePrototype(prototype);
    }

    @Override
    public IndexProviderDescriptor getDefaultProvider() {
        return this.providerMap.getDefaultProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getFulltextProvider() {
        return this.providerMap.getFulltextProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getTokenIndexProvider() {
        return this.providerMap.getTokenIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getTextIndexProvider() {
        return this.providerMap.getTextIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getRangeIndexProvider() {
        return this.providerMap.getRangeIndexProvider().getProviderDescriptor();
    }

    @Override
    public IndexProviderDescriptor getPointIndexProvider() {
        return this.providerMap.getPointIndexProvider().getProviderDescriptor();
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return this.providerMap.completeConfiguration(index);
    }

    @Override
    public IndexProviderDescriptor indexProviderByName(String providerName) {
        return this.providerMap.lookup(providerName).getProviderDescriptor();
    }

    @Override
    public IndexType indexTypeByProviderName(String providerName) {
        return this.providerMap.lookup(providerName).getIndexType();
    }

    public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext) throws KernelException {
        if (this.state == State.NOT_STARTED) {
            this.apply(updates, IndexUpdateMode.RECOVERY, cursorContext);
        } else if (this.state == State.RUNNING || this.state == State.STARTING) {
            this.apply(updates, IndexUpdateMode.ONLINE, cursorContext);
        } else {
            throw new IllegalStateException("Can't apply index updates " + Iterables.asList(updates) + " while indexing service is " + this.state);
        }
    }

    private void apply(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, IndexUpdateMode updateMode, CursorContext cursorContext) throws KernelException {
        try (IndexUpdaterMap updaterMap = this.indexMapRef.createIndexUpdaterMap(updateMode);){
            for (IndexEntryUpdate<IndexDescriptor> indexUpdate : updates) {
                IndexingService.processUpdate(updaterMap, indexUpdate, cursorContext);
            }
        }
    }

    public void createIndexes(Subject subject, IndexDescriptor ... rules) {
        this.createIndexes(false, subject, rules);
    }

    public void createIndexes(boolean verifyBeforeFlipping, Subject subject, IndexDescriptor ... rules) {
        IndexDescriptor[] newlyCreated = this.filterOutAndHandleInjectedTokenIndex(rules);
        IndexPopulationStarter populationStarter = new IndexPopulationStarter(verifyBeforeFlipping, subject, newlyCreated);
        this.indexMapRef.modify(populationStarter);
        populationStarter.startPopulation();
    }

    private IndexDescriptor[] filterOutAndHandleInjectedTokenIndex(IndexDescriptor[] rules) {
        IndexProxy nli = this.indexMapRef.indexMapSnapshot().getIndexProxy(-2L);
        if (nli == null) {
            return rules;
        }
        ArrayList<IndexDescriptor> filteredRules = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor rule : rules) {
            if (rule.schema().isAnyTokenSchemaDescriptor() && rule.schema().entityType() == EntityType.NODE) {
                nli.changeIdentity(rule);
                this.indexMapRef.modify(indexMap -> {
                    indexMap.putIndexProxy(nli);
                    indexMap.removeIndexProxy(-2L);
                    return indexMap;
                });
                this.schemaState.clear();
                continue;
            }
            filteredRules.add(rule);
        }
        return (IndexDescriptor[])filteredRules.toArray(IndexDescriptor[]::new);
    }

    private static void processUpdate(IndexUpdaterMap updaterMap, IndexEntryUpdate<IndexDescriptor> indexUpdate, CursorContext cursorContext) throws IndexEntryConflictException {
        IndexUpdater updater = updaterMap.getUpdater((IndexDescriptor)indexUpdate.indexKey(), cursorContext);
        if (updater != null) {
            updater.process(indexUpdate);
        }
    }

    public void dropIndex(IndexDescriptor rule) {
        Preconditions.checkState((this.state == State.RUNNING || this.state == State.NOT_STARTED ? 1 : 0) != 0, (String)"Dropping index in unexpected state %s", (Object[])new Object[]{this.state.name()});
        this.indexMapRef.modify(indexMap -> {
            long indexId = rule.getId();
            IndexProxy index = indexMap.removeIndexProxy(indexId);
            if (this.state == State.RUNNING) {
                Preconditions.checkState((index != null ? 1 : 0) != 0, (String)"Index %s doesn't exists", (Object[])new Object[]{rule});
                index.drop();
            } else if (index != null) {
                try {
                    index.drop();
                }
                catch (Exception e) {
                    try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(INDEX_SERVICE_INDEX_CLOSING_TAG));){
                        index.close(cursorContext);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return indexMap;
        });
    }

    public void triggerIndexSampling(IndexSamplingMode mode) {
        this.internalLog.info("Manual trigger for sampling all indexes [" + mode + "]");
        this.monitor.indexSamplingTriggered(mode);
        this.samplingController.sampleIndexes(mode);
    }

    public void triggerIndexSampling(IndexDescriptor index, IndexSamplingMode mode) {
        String description = index.userDescription(this.tokenNameLookup);
        this.internalLog.info("Manual trigger for sampling index " + description + " [" + mode + "]");
        this.samplingController.sampleIndex(index.getId(), mode);
    }

    private static void dropRecoveringIndexes(IndexMap indexMap, LongIterable indexesToRebuild) {
        indexesToRebuild.forEach((LongProcedure & Serializable)idx -> {
            IndexProxy indexProxy = indexMap.removeIndexProxy(idx);
            assert (indexProxy != null);
            indexProxy.drop();
        });
    }

    public void activateIndex(IndexDescriptor descriptor) throws IndexNotFoundKernelException, IndexActivationFailedKernelException, IndexPopulationFailedKernelException {
        try {
            if (this.state == State.RUNNING) {
                IndexProxy index = this.getIndexProxy(descriptor);
                index.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
                index.activate();
                this.internalLog.info("Constraint %s is %s.", new Object[]{index.getDescriptor(), InternalIndexState.ONLINE.name()});
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IndexActivationFailedKernelException(e, "Unable to activate index, thread was interrupted.");
        }
    }

    public IndexProxy getIndexProxy(IndexDescriptor index) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(index.getId());
    }

    @Deprecated
    public IndexProxy getIndexProxy(long indexId) throws IndexNotFoundKernelException {
        return this.indexMapRef.getIndexProxy(indexId);
    }

    public void validateIndex(long indexId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, UniquePropertyValueValidationException {
        this.indexMapRef.getIndexProxy(indexId).validate();
    }

    public void forceAll(CursorContext cursorContext) throws IOException {
        this.indexStatisticsStore.checkpoint(cursorContext);
        this.indexMapRef.indexMapSnapshot().forEachIndexProxy(this.indexProxyOperation("force", (ThrowingConsumer<IndexProxy, Exception>)((ThrowingConsumer)proxy -> proxy.force(cursorContext))));
    }

    private LongObjectProcedure<IndexProxy> indexProxyOperation(String name, ThrowingConsumer<IndexProxy, Exception> operation) {
        return (LongObjectProcedure & Serializable)(id, indexProxy) -> {
            try {
                operation.accept(indexProxy);
            }
            catch (Exception e) {
                try {
                    IndexProxy proxy = this.indexMapRef.getIndexProxy(id);
                    throw new UnderlyingStorageException("Unable to " + name + " " + proxy, (Throwable)e);
                }
                catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                    // empty catch block
                }
            }
        };
    }

    private void closeAllIndexes() {
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer(INDEX_SERVICE_INDEX_CLOSING_TAG));){
            this.indexMapRef.modify(indexMap -> {
                Iterable<IndexProxy> indexesToStop = indexMap.getAllIndexProxies();
                for (IndexProxy index : indexesToStop) {
                    try {
                        index.close(cursorContext);
                    }
                    catch (Exception e) {
                        this.internalLog.error("Unable to close index", (Throwable)e);
                    }
                }
                return new IndexMap();
            });
        }
    }

    public LongSet getIndexIds() {
        Iterable<IndexProxy> indexProxies = this.indexMapRef.getAllIndexProxies();
        LongHashSet indexIds = new LongHashSet();
        for (IndexProxy indexProxy : indexProxies) {
            indexIds.add(indexProxy.getDescriptor().getId());
        }
        return indexIds;
    }

    public ResourceIterator<Path> snapshotIndexFiles() throws IOException {
        ArrayList<Object> snapshots = new ArrayList<Object>();
        snapshots.add(Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.indexStatisticsStore.storeFile())));
        for (IndexProxy indexProxy : this.indexMapRef.getAllIndexProxies()) {
            snapshots.add(indexProxy.snapshotFiles());
        }
        return Iterators.concatResourceIterators(snapshots.iterator());
    }

    public IndexMonitor getMonitor() {
        return this.monitor;
    }

    private IndexPopulationJob newIndexPopulationJob(EntityType type, boolean verifyBeforeFlipping, Subject subject) {
        MultipleIndexPopulator multiPopulator = new MultipleIndexPopulator(this.storeView, this.internalLogProvider, type, this.schemaState, this.jobScheduler, this.tokenNameLookup, this.pageCacheTracer, this.memoryTracker, this.databaseName, subject, this.config);
        return new IndexPopulationJob(multiPopulator, this.monitor, verifyBeforeFlipping, this.pageCacheTracer, this.memoryTracker, this.databaseName, subject, EntityType.NODE, this.config);
    }

    private void startIndexPopulation(IndexPopulationJob job) {
        if (this.storeView.isEmpty()) {
            job.run();
        } else {
            this.populationJobController.startIndexPopulation(job);
        }
    }

    private String indexStateInfo(String tag, InternalIndexState state, IndexDescriptor descriptor) {
        return String.format("IndexingService.%s: index %d on %s is %s", tag, descriptor.getId(), descriptor.schema().userDescription(this.tokenNameLookup), state.name());
    }

    private void logIndexStateSummary(String method, Map<InternalIndexState, List<IndexLogRecord>> indexStates) {
        if (indexStates.isEmpty()) {
            return;
        }
        int mostPopularStateCount = Integer.MIN_VALUE;
        InternalIndexState mostPopularState = null;
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            if (indexStateEntry.getValue().size() <= mostPopularStateCount) continue;
            mostPopularState = indexStateEntry.getKey();
            mostPopularStateCount = indexStateEntry.getValue().size();
        }
        indexStates.remove(mostPopularState);
        for (Map.Entry<InternalIndexState, List<IndexLogRecord>> indexStateEntry : indexStates.entrySet()) {
            InternalIndexState state = indexStateEntry.getKey();
            List<IndexLogRecord> logRecords = indexStateEntry.getValue();
            for (IndexLogRecord logRecord : logRecords) {
                this.internalLog.info(this.indexStateInfo(method, state, logRecord.getDescriptor()));
            }
        }
        this.internalLog.info(String.format("IndexingService.%s: indexes not specifically mentioned above are %s", method, mostPopularState));
    }

    private /* synthetic */ IndexMap lambda$start$4(MutableLongObjectMap rebuildingDescriptors, IndexMap indexMap) {
        EnumMap<InternalIndexState, List<IndexLogRecord>> indexStates = new EnumMap<InternalIndexState, List<IndexLogRecord>>(InternalIndexState.class);
        indexMap.forEachIndexProxy((LongObjectProcedure<IndexProxy>)(LongObjectProcedure & Serializable)(indexId, proxy) -> {
            InternalIndexState state = proxy.getState();
            IndexDescriptor descriptor = proxy.getDescriptor();
            IndexLogRecord indexLogRecord = new IndexLogRecord(descriptor);
            indexStates.computeIfAbsent(state, internalIndexState -> new ArrayList()).add(indexLogRecord);
            this.internalLog.debug(this.indexStateInfo("start", state, descriptor));
            switch (state) {
                case ONLINE: 
                case FAILED: {
                    proxy.start();
                    break;
                }
                case POPULATING: {
                    rebuildingDescriptors.put(indexId, (Object)descriptor);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
        });
        this.logIndexStateSummary("start", indexStates);
        this.dontRebuildIndexesInReadOnlyMode((MutableLongObjectMap<IndexDescriptor>)rebuildingDescriptors);
        IndexingService.dropRecoveringIndexes(indexMap, (LongIterable)rebuildingDescriptors.keySet());
        this.populateIndexesOfAllTypes((MutableLongObjectMap<IndexDescriptor>)rebuildingDescriptors, indexMap);
        return indexMap;
    }

    @FunctionalInterface
    public static interface IndexProxyProvider {
        public IndexProxy getIndexProxy(IndexDescriptor var1) throws IndexNotFoundKernelException;
    }

    private static final class IndexLogRecord {
        private final IndexDescriptor descriptor;

        IndexLogRecord(IndexDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public long getIndexId() {
            return this.descriptor.getId();
        }

        public IndexDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    private final class IndexPopulationStarter
    implements UnaryOperator<IndexMap> {
        private final boolean verifyBeforeFlipping;
        private final Subject subject;
        private final IndexDescriptor[] descriptors;
        private IndexPopulationJob nodePopulationJob;
        private IndexPopulationJob relationshipPopulationJob;

        IndexPopulationStarter(boolean verifyBeforeFlipping, Subject subject, IndexDescriptor[] descriptors) {
            this.verifyBeforeFlipping = verifyBeforeFlipping;
            this.subject = subject;
            this.descriptors = descriptors;
        }

        @Override
        public IndexMap apply(IndexMap indexMap) {
            for (IndexDescriptor descriptor : this.descriptors) {
                IndexProxy index = indexMap.getIndexProxy(descriptor);
                if (index != null && IndexingService.this.state == State.NOT_STARTED) continue;
                if (IndexingService.this.state == State.RUNNING) {
                    if (descriptor.schema().entityType() == EntityType.NODE) {
                        this.nodePopulationJob = this.nodePopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.NODE, this.verifyBeforeFlipping, this.subject) : this.nodePopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, IndexingService.this.monitor, this.nodePopulationJob);
                        index.start();
                    } else {
                        this.relationshipPopulationJob = this.relationshipPopulationJob == null ? IndexingService.this.newIndexPopulationJob(EntityType.RELATIONSHIP, this.verifyBeforeFlipping, this.subject) : this.relationshipPopulationJob;
                        index = IndexingService.this.indexProxyCreator.createPopulatingIndexProxy(descriptor, IndexingService.this.monitor, this.relationshipPopulationJob);
                        index.start();
                    }
                } else {
                    index = IndexingService.this.indexProxyCreator.createRecoveringIndexProxy(descriptor);
                }
                indexMap.putIndexProxy(index);
            }
            return indexMap;
        }

        void startPopulation() {
            if (this.nodePopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.nodePopulationJob);
            }
            if (this.relationshipPopulationJob != null) {
                IndexingService.this.startIndexPopulation(this.relationshipPopulationJob);
            }
        }
    }

    static enum State {
        NOT_STARTED,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

