/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import java.util.SortedMap;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.dbms.api.DatabaseExistsException;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

class DatabaseManagerTest {
    private static final String KNOWN_DATABASE_NAME = "known";
    private static final String UNKNOWN_DATABASE_NAME = "unknown";
    private static final NamedDatabaseId DATABASE_ID_NAMED = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
    private final DatabaseManager<?> databaseManager = new TestDatabaseManager();

    DatabaseManagerTest() {
    }

    @Test
    void shouldReturnContextForKnownDatabaseName() {
        Assertions.assertTrue((boolean)this.databaseManager.getDatabaseContext(KNOWN_DATABASE_NAME).isPresent());
    }

    @Test
    void shouldReturnEmptyForUnknownDatabaseName() {
        Assertions.assertFalse((boolean)this.databaseManager.getDatabaseContext(UNKNOWN_DATABASE_NAME).isPresent());
    }

    private static class TestDatabaseManager
    extends LifecycleAdapter
    implements DatabaseManager<DatabaseContext> {
        private TestDatabaseManager() {
        }

        public Optional<DatabaseContext> getDatabaseContext(NamedDatabaseId namedDatabaseId) {
            return Optional.of((DatabaseContext)Mockito.mock(DatabaseContext.class));
        }

        public DatabaseIdRepository.Caching databaseIdRepository() {
            return new DatabaseIdRepository.Caching(){

                public void invalidateAll() {
                }

                public Optional<NamedDatabaseId> getByName(NormalizedDatabaseName databaseName) {
                    if (DatabaseManagerTest.KNOWN_DATABASE_NAME.equals(databaseName.name())) {
                        return Optional.of(DATABASE_ID_NAMED);
                    }
                    return Optional.empty();
                }

                public Optional<NamedDatabaseId> getById(DatabaseId databaseId) {
                    if (DATABASE_ID_NAMED.databaseId().equals((Object)databaseId)) {
                        return Optional.of(DATABASE_ID_NAMED);
                    }
                    return Optional.empty();
                }
            };
        }

        public DatabaseContext createDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseExistsException {
            return null;
        }

        public void dropDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseNotFoundException {
        }

        public void stopDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseNotFoundException {
        }

        public void startDatabase(NamedDatabaseId namedDatabaseId) throws DatabaseNotFoundException {
        }

        public SortedMap<NamedDatabaseId, DatabaseContext> registeredDatabases() {
            return null;
        }
    }
}

