/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
abstract class BaseAccessorTilesTest<KEY extends NativeIndexKey<KEY>> {
    private static final CoordinateReferenceSystem crs = CoordinateReferenceSystem.WGS84;
    private static final Config config = Config.defaults();
    static final IndexSpecificSpaceFillingCurveSettings indexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
    static final SpaceFillingCurve curve = indexSettings.forCrs(crs);
    @Inject
    FileSystemAbstraction fs;
    @Inject
    TestDirectory directory;
    @Inject
    PageCache pageCache;
    @Inject
    RandomSupport random;
    private NativeIndexAccessor<KEY> accessor;
    IndexDescriptor descriptor;

    BaseAccessorTilesTest() {
    }

    abstract IndexDescriptor createDescriptor();

    abstract NativeIndexAccessor<KEY> createAccessor();

    @BeforeEach
    void setup() {
        this.descriptor = this.createDescriptor();
        this.accessor = this.createAccessor();
    }

    @AfterEach
    void tearDown() {
        this.accessor.close();
    }

    @Test
    void mustHandlePointsWithinSameTile() throws IndexEntryConflictException, IndexNotApplicableKernelException {
        int nbrOfValues = 10000;
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        Long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint.longValue());
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        ArrayList<Value> pointValues = new ArrayList<Value>();
        ArrayList<IndexEntryUpdate<IndexDescriptor>> updates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        long nodeId = 1L;
        for (int i = 0; i < nbrOfValues / 4; ++i) {
            double x1 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double x2 = (this.random.nextDouble() * 2.0 - 1.0) * xWidthMultiplier;
            double y1 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            double y2 = (this.random.nextDouble() * 2.0 - 1.0) * yWidthMultiplier;
            PointValue value11 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y1});
            PointValue value12 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x1, centerPoint[1] + y2});
            PointValue value21 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y1});
            PointValue value22 = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{centerPoint[0] + x2, centerPoint[1] + y2});
            BaseAccessorTilesTest.assertDerivedValue(derivedValueForCenterPoint, value11, value12, value21, value22);
            nodeId = this.addPointsToLists(pointValues, updates, nodeId, value11, value12, value21, value22);
        }
        this.processAll(updates);
        this.exactMatchOnAllValues(pointValues);
    }

    @Test
    void shouldNotGetRoundingErrorsWithPointsJustWithinTheTileUpperBound() {
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] centerPoint = curve.centerPointFor(derivedValueForCenterPoint);
        double xWidthMultiplier = curve.getTileWidth(0, curve.getMaxLevel()) / 2.0;
        double yWidthMultiplier = curve.getTileWidth(1, curve.getMaxLevel()) / 2.0;
        double[] faultyCoords = new double[]{1.874410632171803E-8, 1.6763806281859016E-7};
        org.junit.jupiter.api.Assertions.assertTrue((centerPoint[0] + xWidthMultiplier > faultyCoords[0] ? 1 : 0) != 0, (String)"inside upper x limit");
        org.junit.jupiter.api.Assertions.assertTrue((centerPoint[0] - xWidthMultiplier < faultyCoords[0] ? 1 : 0) != 0, (String)"inside lower x limit");
        org.junit.jupiter.api.Assertions.assertTrue((centerPoint[1] + yWidthMultiplier > faultyCoords[1] ? 1 : 0) != 0, (String)"inside upper y limit");
        org.junit.jupiter.api.Assertions.assertTrue((centerPoint[1] - yWidthMultiplier < faultyCoords[1] ? 1 : 0) != 0, (String)"inside lower y limit");
        long derivedValueForFaultyCoords = curve.derivedValueFor(faultyCoords);
        org.junit.jupiter.api.Assertions.assertEquals((long)derivedValueForCenterPoint, (long)derivedValueForFaultyCoords, (String)"expected same derived value");
    }

    @Test
    void shouldNotGetFalsePositivesForRangesSpanningMultipleTiles() throws IndexNotApplicableKernelException, IndexEntryConflictException {
        PointValue origin = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.0, 0.0});
        long derivedValueForCenterPoint = curve.derivedValueFor(origin.coordinate());
        double[] searchStart = curve.centerPointFor(derivedValueForCenterPoint);
        double xTileWidth = curve.getTileWidth(0, curve.getMaxLevel());
        PointValue limitPoint = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{searchStart[0] + xTileWidth, searchStart[1]});
        int nbrOfValues = 10000;
        ArrayList<PointValue> pointsInside = new ArrayList<PointValue>();
        ArrayList<IndexEntryUpdate<IndexDescriptor>> updates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();
        for (int i = 0; i < nbrOfValues; ++i) {
            double distanceMultiplier = this.random.nextDouble() * 2.0;
            PointValue point = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{searchStart[0] + distanceMultiplier * xTileWidth, searchStart[1]});
            updates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{point}));
            if (!(distanceMultiplier <= 1.0)) continue;
            pointsInside.add(point);
        }
        this.processAll(updates);
        try (ValueIndexReader indexReader = this.accessor.newValueReader();){
            SimpleEntityValueClient client = new SimpleEntityValueClient();
            PropertyIndexQuery.RangePredicate range = PropertyIndexQuery.range((int)this.descriptor.schema().getPropertyId(), (Value)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])searchStart), (boolean)true, (Value)limitPoint, (boolean)true);
            indexReader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{range});
            ArrayList<Value> queryResult = new ArrayList<Value>();
            while (client.next()) {
                queryResult.add(client.values[0]);
            }
            Assertions.assertThat(queryResult).containsExactlyInAnyOrderElementsOf(pointsInside);
        }
    }

    private long addPointsToLists(List<Value> pointValues, List<IndexEntryUpdate<IndexDescriptor>> updates, long nodeId, PointValue ... values) {
        for (PointValue value : values) {
            pointValues.add((Value)value);
            updates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])new Value[]{value}));
        }
        return nodeId;
    }

    static void assertDerivedValue(Long targetDerivedValue, PointValue ... values) {
        for (PointValue value : values) {
            Long derivedValueForValue = curve.derivedValueFor(value.coordinate());
            org.junit.jupiter.api.Assertions.assertEquals((Long)targetDerivedValue, (Long)derivedValueForValue, (String)"expected random value to belong to same tile as center point");
        }
    }

    void processAll(List<IndexEntryUpdate<IndexDescriptor>> updates) throws IndexEntryConflictException {
        try (NativeIndexUpdater updater = this.accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            for (IndexEntryUpdate<IndexDescriptor> update : updates) {
                updater.process(update);
            }
        }
    }

    void exactMatchOnAllValues(List<Value> values) throws IndexNotApplicableKernelException {
        try (ValueIndexReader indexReader = this.accessor.newValueReader();){
            SimpleEntityValueClient client = new SimpleEntityValueClient();
            for (Value value : values) {
                PropertyIndexQuery.ExactPredicate exact = PropertyIndexQuery.exact((int)this.descriptor.schema().getPropertyId(), (Object)value);
                indexReader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.unorderedValues(), new PropertyIndexQuery[]{exact});
                org.junit.jupiter.api.Assertions.assertTrue((boolean)client.next());
                org.junit.jupiter.api.Assertions.assertEquals((Object)value, (Object)client.values[0]);
                org.junit.jupiter.api.Assertions.assertFalse((boolean)client.next());
            }
        }
    }
}

