/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongPredicate;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NullValue;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ThreadSafePeakMemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsExtension;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.scheduler.JobSchedulerAdapter;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.values.storable.Value;

@ActorsExtension
@EphemeralPageCacheExtension
abstract class BlockBasedIndexPopulatorTest<KEY extends NativeIndexKey<KEY>> {
    private static final LabelSchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptors.forLabel((int)1, (int[])new int[]{1});
    final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SCHEMA_DESCRIPTOR).withIndexType(this.indexType()).withName("index").materialise(1L);
    public static final int SUFFICIENTLY_LARGE_BUFFER_SIZE = (int)ByteUnit.kibiBytes((long)50L);
    final TokenNameLookup tokenNameLookup = SchemaTestUtil.SIMPLE_NAME_LOOKUP;
    @Inject
    Actor merger;
    @Inject
    Actor closer;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    TestDirectory testDir;
    @Inject
    PageCache pageCache;
    IndexFiles indexFiles;
    DatabaseIndexContext databaseIndexContext;
    private JobScheduler jobScheduler;
    IndexPopulator.PopulationWorkScheduler populationWorkScheduler;

    BlockBasedIndexPopulatorTest() {
    }

    abstract IndexType indexType();

    abstract BlockBasedIndexPopulator<KEY> instantiatePopulator(BlockStorage.Monitor var1, ByteBufferFactory var2, MemoryTracker var3) throws IOException;

    abstract Layout<KEY, NullValue> layout();

    abstract Value supportedValue(int var1);

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((Path)this.testDir.homePath()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, this.INDEX_DESCRIPTOR.getId());
        this.databaseIndexContext = DatabaseIndexContext.builder((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").build();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.populationWorkScheduler = BlockBasedIndexPopulatorTest.wrapScheduler(this.jobScheduler);
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.shutdown();
    }

    private static IndexPopulator.PopulationWorkScheduler wrapScheduler(final JobScheduler jobScheduler) {
        return new IndexPopulator.PopulationWorkScheduler(){

            public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                return jobScheduler.schedule(Group.INDEX_POPULATION_WORK, new JobMonitoringParams(null, null, null), job);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAwaitMergeToBeFullyAbortedBeforeLeavingCloseMethod() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false, CursorContext.NULL));
            this.closer.untilWaiting();
            monitor.barrier.release();
            closeFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    private Callable<Object> scanCompletedTask(BlockBasedIndexPopulator<KEY> populator) {
        return () -> {
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleBeingAbortedWhileMerging() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 2L);
        BlockBasedIndexPopulator populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.await();
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false, CursorContext.NULL));
            this.closer.untilWaiting();
            monitor.mergeFinishedBarrier.release();
            closeFuture.get();
            closed = true;
            mergeFuture.get();
        }
        finally {
            if (!closed) {
                populator.close(false, CursorContext.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReportAccurateProgressThroughoutThePhases() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 1L);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.5f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.7f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.mergeFinishedBarrier.release();
            mergeFuture.get();
            Assertions.assertEquals((float)1.0f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.0f);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCorrectlyDecideToAwaitMergeDependingOnProgress() throws Throwable {
        BlockBasedIndexPopulator populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            Race race = new Race();
            race.addContestant(Race.throwing(() -> populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL)));
            race.addContestant(Race.throwing(() -> populator.close(false, CursorContext.NULL)));
            race.go();
            closed = true;
            EphemeralFileSystemAbstraction ephemeralFileSystem = (EphemeralFileSystemAbstraction)this.fs;
            ephemeralFileSystem.assertNoOpenFiles();
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeleteDirectoryOnDrop() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getBase()));
            Assertions.assertTrue((boolean)this.fs.isDirectory(this.indexFiles.getBase()));
            Assertions.assertTrue((this.fs.listFiles(this.indexFiles.getBase()).length > 0 ? 1 : 0) != 0);
            Future dropFuture = this.closer.submit(() -> populator.drop());
            this.closer.untilWaiting();
            monitor.barrier.release();
            dropFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
            Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()));
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnClose() throws IndexEntryConflictException, IOException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = this.batchOfUpdates();
            populator.add(updates, CursorContext.NULL);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedNativeMemory();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.close(true, CursorContext.NULL);
            closed = true;
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnDrop() throws IndexEntryConflictException, IOException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = this.batchOfUpdates();
            populator.add(updates, CursorContext.NULL);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedNativeMemory();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.drop();
            closed = true;
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedNativeMemory());
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    @Test
    void shouldBuildNonUniqueSampleAsPartOfScanCompleted() throws IndexEntryConflictException, IOException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        Collection<IndexEntryUpdate<?>> populationUpdates = this.batchOfUpdates();
        populator.add(populationUpdates, CursorContext.NULL);
        populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        int numberOfUpdatesAfterCompleted = 4;
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            for (int i = 0; i < numberOfUpdatesAfterCompleted; ++i) {
                updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)(10000 + i), (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{this.supportedValue(i)}));
            }
        }
        populator.close(true, CursorContext.NULL);
        IndexSample sample = populator.sample(CursorContext.NULL);
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.indexSize());
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.sampleSize());
        Assertions.assertEquals((long)populationUpdates.size(), (long)sample.uniqueValues());
        Assertions.assertEquals((long)numberOfUpdatesAfterCompleted, (long)sample.updates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFlushTreeOnScanCompleted() throws IndexEntryConflictException, IOException {
        ThreadSafePeakMemoryTracker memoryTracker = new ThreadSafePeakMemoryTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, 100);
        final AtomicInteger checkpoints = new AtomicInteger();
        GBPTree.Monitor.Adaptor treeMonitor = new GBPTree.Monitor.Adaptor(){

            public void checkpointCompleted() {
                checkpoints.incrementAndGet();
            }
        };
        Monitors monitors = new Monitors(this.databaseIndexContext.monitors, (LogProvider)NullLogProvider.getInstance());
        monitors.addMonitorListener((Object)treeMonitor, new String[0]);
        this.databaseIndexContext = DatabaseIndexContext.builder((DatabaseIndexContext)this.databaseIndexContext).withMonitors(monitors).build();
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)memoryTracker);
        try {
            int numberOfCheckPointsBeforeScanCompleted = checkpoints.get();
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            Assertions.assertEquals((int)(numberOfCheckPointsBeforeScanCompleted + 1), (int)checkpoints.get());
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldScheduleMergeOnJobSchedulerWithCorrectGroup() throws IndexEntryConflictException, IOException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(this.batchOfUpdates(), CursorContext.NULL);
            final MutableBoolean called = new MutableBoolean();
            JobSchedulerAdapter trackingJobScheduler = new JobSchedulerAdapter(){

                public <T> JobHandle<T> schedule(Group group, JobMonitoringParams jobMonitoringParams, Callable<T> job) {
                    called.setTrue();
                    AssertionsForInterfaceTypes.assertThat((Comparable)group).isSameAs((Object)Group.INDEX_POPULATION_WORK);
                    return BlockBasedIndexPopulatorTest.this.jobScheduler.schedule(group, jobMonitoringParams, job);
                }
            };
            populator.scanCompleted(PhaseTracker.nullInstance, BlockBasedIndexPopulatorTest.wrapScheduler((JobScheduler)trackingJobScheduler), CursorContext.NULL);
            Assertions.assertTrue((boolean)called.booleanValue());
            populator.close(true, CursorContext.NULL);
            closed = true;
        }
        finally {
            if (!closed) {
                populator.close(true, CursorContext.NULL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldFailOnBatchAddedTooLargeValue() throws IOException {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap() + 1;
            Assertions.assertThrows(IllegalArgumentException.class, () -> populator.add(Collections.singletonList(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(this.layout(), size)})), CursorContext.NULL));
        }
        finally {
            populator.close(false, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldFailOnUpdatedTooLargeValue(boolean updateBeforeScanCompleted) throws IndexEntryConflictException, IOException {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap() + 1;
            if (!updateBeforeScanCompleted) {
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            }
            Assertions.assertThrows(IllegalArgumentException.class, () -> {
                try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(this.layout(), size)}));
                }
            });
        }
        finally {
            populator.close(false, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCountExternalUpdatesAsSampleUpdates() throws IOException, IndexEntryConflictException {
        BlockBasedIndexPopulator<KEY> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        try {
            populator.add(List.of(this.add(0), this.add(1)), CursorContext.NULL);
            try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
                updater.process(this.add(10));
                updater.process(this.add(11));
                updater.process(this.add(12));
            }
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            updater = populator.newPopulatingUpdater(CursorContext.NULL);
            try {
                updater.process(this.remove(10));
            }
            finally {
                if (updater != null) {
                    updater.close();
                }
            }
            IndexSample sample = populator.sample(CursorContext.NULL);
            AssertionsForInterfaceTypes.assertThat((long)sample.updates()).isEqualTo(4L);
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    Seeker<KEY, NullValue> seek(GBPTree<KEY, NullValue> tree, Layout<KEY, NullValue> layout) throws IOException {
        NativeIndexKey low = (NativeIndexKey)layout.newKey();
        low.initialize(Long.MIN_VALUE);
        low.initValuesAsLowest();
        NativeIndexKey high = (NativeIndexKey)layout.newKey();
        high.initialize(Long.MAX_VALUE);
        high.initValuesAsHighest();
        return tree.seek((Object)low, (Object)high, CursorContext.NULL);
    }

    private void externalUpdates(BlockBasedIndexPopulator<KEY> populator, int firstId, int lastId) throws IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            for (int i = firstId; i < lastId; ++i) {
                updater.process(this.add(i));
            }
        }
    }

    protected BlockBasedIndexPopulator<KEY> instantiatePopulator(BlockStorage.Monitor monitor) throws IOException {
        return this.instantiatePopulator(monitor, ByteBufferFactory.heapBufferFactory((int)100), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private Collection<IndexEntryUpdate<?>> batchOfUpdates() {
        ArrayList updates = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            updates.add(this.add(i));
        }
        return updates;
    }

    private IndexEntryUpdate<IndexDescriptor> add(int i) {
        return IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{this.supportedValue(i)});
    }

    private IndexEntryUpdate<IndexDescriptor> remove(int i) {
        return IndexEntryUpdate.remove((long)i, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{this.supportedValue(i)});
    }

    private static class TrappingMonitor
    extends BlockStorage.Monitor.Adapter {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Barrier.Control mergeFinishedBarrier = new Barrier.Control();
        private final LongPredicate trapForMergeIterationFinished;

        TrappingMonitor(LongPredicate trapForMergeIterationFinished) {
            this.trapForMergeIterationFinished = trapForMergeIterationFinished;
        }

        public void mergedBlocks(long resultingBlockSize, long resultingEntryCount, long numberOfBlocks) {
            this.barrier.reached();
        }

        public void mergeIterationFinished(long numberOfBlocksBefore, long numberOfBlocksAfter) {
            if (this.trapForMergeIterationFinished.test(numberOfBlocksAfter)) {
                this.mergeFinishedBarrier.reached();
            }
        }
    }
}

