/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexProviderTests;
import org.neo4j.kernel.impl.index.schema.RangeIndexProvider;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class RangeIndexProviderTest
extends IndexProviderTests {
    private static final IndexProviderTests.ProviderFactory factory = (pageCache, fs, dir, monitors, collector, readOnlyChecker, databaseLayout) -> {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)fs, (String)"neo4j").withMonitors(monitors).withReadOnlyChecker(readOnlyChecker).build();
        return new RangeIndexProvider(context, dir, collector, Config.defaults());
    };

    RangeIndexProviderTest() {
        super(factory);
    }

    @Test
    void shouldNotCheckConflictsWhenApplyingUpdatesInOnlineAccessor() throws IOException, IndexEntryConflictException {
        Value someValue = Values.of((Object)1);
        this.provider = this.newProvider();
        IndexDescriptor descriptor = this.descriptorUnique();
        try (IndexAccessor accessor = this.provider.getOnlineAccessor(descriptor, RangeIndexProviderTest.samplingConfig(), this.tokenNameLookup);
             IndexUpdater indexUpdater = accessor.newUpdater(IndexUpdateMode.ONLINE, CursorContext.NULL);){
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)1L, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{someValue}));
            indexUpdater.process((IndexEntryUpdate)IndexEntryUpdate.add((long)2L, (SchemaDescriptorSupplier)descriptor, (Value[])new Value[]{someValue}));
        }
    }

    private IndexDescriptor descriptorUnique() {
        return this.completeConfiguration(IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withIndexType(IndexType.RANGE).withName("constraint").materialise(1L));
    }

    @Override
    IndexDescriptor descriptor() {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withIndexType(IndexType.RANGE).withName("index").materialise(1L));
    }

    @Override
    IndexDescriptor otherDescriptor() {
        return this.completeConfiguration(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withIndexType(IndexType.RANGE).withName("otherIndex").materialise(2L));
    }

    @Override
    IndexPrototype validPrototype() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withIndexType(IndexType.RANGE).withName("index");
    }

    @Override
    List<IndexPrototype> invalidPrototypes() {
        return List.of(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE)).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{1}, (int[])new int[]{1})).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withIndexType(IndexType.BTREE).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withIndexType(IndexType.POINT).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})).withIndexType(IndexType.TEXT).withName("unsupported"), IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withIndexType(IndexType.LOOKUP).withName("unsupported"));
    }

    @Override
    void setupIndexFolders(FileSystemAbstraction fs) throws IOException {
        Path nativeSchemaIndexStoreDirectory = this.newProvider().directoryStructure().rootDirectory();
        fs.mkdirs(nativeSchemaIndexStoreDirectory);
    }
}

