/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.CommonDatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexPopulatorTests;
import org.neo4j.kernel.impl.index.schema.TokenIndexPopulator;
import org.neo4j.kernel.impl.index.schema.TokenIndexProvider;
import org.neo4j.kernel.impl.index.schema.TokenIndexUtility;
import org.neo4j.kernel.impl.index.schema.TokenScanKey;
import org.neo4j.kernel.impl.index.schema.TokenScanLayout;
import org.neo4j.kernel.impl.index.schema.TokenScanValue;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.test.utils.TestDirectory;

class TokenIndexPopulatorTest
extends IndexPopulatorTests<TokenScanKey, TokenScanValue, TokenScanLayout> {
    TokenIndexPopulatorTest() {
    }

    @Override
    IndexFiles createIndexFiles(FileSystemAbstraction fs, TestDirectory directory, IndexDescriptor indexDescriptor) {
        return new IndexFiles.SingleFile(fs, directory.homePath().resolve(CommonDatabaseFile.LABEL_SCAN_STORE.getName()));
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE), (IndexProviderDescriptor)TokenIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
    }

    @Override
    TokenScanLayout layout() {
        return new TokenScanLayout();
    }

    @Override
    byte failureByte() {
        return 2;
    }

    @Override
    byte populatingByte() {
        return 1;
    }

    @Override
    byte onlineByte() {
        return 0;
    }

    TokenIndexPopulator createPopulator(PageCache pageCache) {
        return this.createPopulator(pageCache, new Monitors(), "");
    }

    private TokenIndexPopulator createPopulator(PageCache pageCache, Monitors monitors, String monitorTag) {
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withMonitors(monitors).withTag(monitorTag).withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new TokenIndexPopulator(context, DatabaseLayout.ofFlat((Path)this.directory.homePath()), this.indexFiles, Config.defaults(), this.indexDescriptor);
    }

    @Test
    void addShouldApplyAllUpdatesOnce() throws Exception {
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        this.populator.create();
        List<TokenIndexEntryUpdate<?>> updates = TokenIndexUtility.generateSomeRandomUpdates((MutableLongObjectMap<long[]>)entityTokens, this.random);
        this.populator.add(updates, CursorContext.NULL);
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        TokenIndexUtility.verifyUpdates((MutableLongObjectMap<long[]>)entityTokens, (TokenScanLayout)this.layout, this::getTree);
    }

    @Test
    void updaterShouldApplyUpdates() throws Exception {
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        this.populator.create();
        List<TokenIndexEntryUpdate<?>> updates = TokenIndexUtility.generateSomeRandomUpdates((MutableLongObjectMap<long[]>)entityTokens, this.random);
        try (IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);){
            for (TokenIndexEntryUpdate<?> update : updates) {
                updater.process(update);
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        TokenIndexUtility.verifyUpdates((MutableLongObjectMap<long[]>)entityTokens, (TokenScanLayout)this.layout, this::getTree);
    }

    @Test
    void updaterMustThrowIfProcessAfterClose() throws Exception {
        this.populator.create();
        IndexUpdater updater = this.populator.newPopulatingUpdater(null_property_accessor, CursorContext.NULL);
        updater.close();
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)this.random.nextInt(), null, (long[])PrimitiveLongCollections.EMPTY_LONG_ARRAY, (long[])TokenIndexUtility.generateRandomTokens(this.random))));
        Assertions.assertThat((Throwable)e).hasMessageContaining("Updater has been closed");
        this.populator.close(true, CursorContext.NULL);
    }

    @Test
    void shouldHandleInterleavedRandomizedUpdates() throws IndexEntryConflictException, IOException {
        int numberOfEntities = 1000;
        long currentScanId = 0L;
        MutableLongObjectMap entityTokens = LongObjectMaps.mutable.empty();
        this.populator.create();
        while (currentScanId < (long)numberOfEntities) {
            ArrayList updates = new ArrayList();
            for (int i = 0; i < 100 && currentScanId < (long)numberOfEntities; ++currentScanId, ++i) {
                TokenIndexUtility.generateRandomUpdate(currentScanId, (MutableLongObjectMap<long[]>)entityTokens, updates, this.random);
            }
            this.populator.add(updates, CursorContext.NULL);
            IndexUpdater updater = this.populator.newPopulatingUpdater(NodePropertyAccessor.EMPTY, CursorContext.NULL);
            try {
                for (int i = 0; i < 100; ++i) {
                    long entityId = this.random.nextLong(currentScanId);
                    long[] beforeTokens = (long[])entityTokens.get(entityId);
                    if (beforeTokens == null) {
                        beforeTokens = PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                    }
                    long[] afterTokens = TokenIndexUtility.generateRandomTokens(this.random);
                    entityTokens.put(entityId, (Object)Arrays.copyOf(afterTokens, afterTokens.length));
                    updater.process((IndexEntryUpdate)IndexEntryUpdate.change((long)entityId, null, (long[])beforeTokens, (long[])afterTokens));
                }
            }
            finally {
                if (updater == null) continue;
                updater.close();
            }
        }
        this.populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
        this.populator.close(true, CursorContext.NULL);
        TokenIndexUtility.verifyUpdates((MutableLongObjectMap<long[]>)entityTokens, (TokenScanLayout)this.layout, this::getTree);
    }

    @Test
    void shouldRelayMonitorCallsToRegisteredGBPTreeMonitorWithoutTag() throws IOException {
        AtomicBoolean checkpointCompletedCall = new AtomicBoolean();
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)TokenIndexPopulatorTest.getCheckpointCompletedListener(checkpointCompletedCall), new String[0]);
        this.populator = this.createPopulator(this.pageCache, monitors, "tag");
        this.populator.create();
        this.populator.close(true, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checkpointCompletedCall.get());
    }

    @Test
    void shouldNotRelayMonitorCallsToRegisteredGBPTreeMonitorWithDifferentTag() throws IOException {
        AtomicBoolean checkpointCompletedCall = new AtomicBoolean();
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)TokenIndexPopulatorTest.getCheckpointCompletedListener(checkpointCompletedCall), new String[]{"differentTag"});
        this.populator = this.createPopulator(this.pageCache, monitors, "tag");
        this.populator.create();
        this.populator.close(true, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)checkpointCompletedCall.get());
    }

    @Test
    void shouldRelayMonitorCallsToRegisteredGBPTreeMonitorWithTag() throws IOException {
        AtomicBoolean checkpointCompletedCall = new AtomicBoolean();
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)TokenIndexPopulatorTest.getCheckpointCompletedListener(checkpointCompletedCall), new String[]{"tag"});
        this.populator = this.createPopulator(this.pageCache, monitors, "tag");
        this.populator.create();
        this.populator.close(true, CursorContext.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)checkpointCompletedCall.get());
    }

    private static GBPTree.Monitor.Adaptor getCheckpointCompletedListener(final AtomicBoolean checkpointCompletedCall) {
        return new GBPTree.Monitor.Adaptor(){

            public void checkpointCompleted() {
                checkpointCompletedCall.set(true);
            }
        };
    }
}

