/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.DbmsRuntimeRepository;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.SecurityAuthorizationHandler;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingProvidersService;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceIds;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.kernel.impl.newapi.DefaultPooledCursors;
import org.neo4j.kernel.impl.newapi.FullAccessNodeCursor;
import org.neo4j.kernel.impl.newapi.FullAccessPropertyCursor;
import org.neo4j.kernel.impl.newapi.IndexTxStateUpdater;
import org.neo4j.kernel.impl.newapi.KernelToken;
import org.neo4j.kernel.impl.newapi.Operations;
import org.neo4j.kernel.impl.newapi.OperationsTest;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;
import org.neo4j.logging.FormattedLogFormat;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.test.InMemoryTokens;
import org.neo4j.token.api.NamedToken;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class PlainOperationsTest
extends OperationsTest {
    @Override
    FormattedLogFormat getFormat() {
        return FormattedLogFormat.PLAIN;
    }

    @Test
    void shouldAcquireEntityWriteLockCreatingRelationship() throws Exception {
        long sourceNode = 1L;
        long targetNode = 3L;
        int relationshipType = 2;
        long rId = this.operations.relationshipCreate(sourceNode, relationshipType, targetNode);
        ((StorageLocks)this.order.verify((Object)this.storageLocks)).acquireRelationshipCreationLock((ReadableTransactionState)this.txState, LockTracer.NONE, sourceNode, targetNode);
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoCreate(rId, relationshipType, sourceNode, targetNode);
    }

    @Test
    void shouldAcquireNodeLocksWhenCreatingRelationshipInOrderOfAscendingId() throws Exception {
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.operations.relationshipCreate(lowId, relationshipLabel, highId);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.creationContext, this.storageLocks});
        ((StorageLocks)lockingOrder.verify((Object)this.storageLocks)).acquireRelationshipCreationLock((ReadableTransactionState)this.txState, LockTracer.NONE, lowId, highId);
        ((CommandCreationContext)lockingOrder.verify((Object)this.creationContext)).reserveRelationship(lowId);
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new CommandCreationContext[]{this.creationContext});
        this.operations.relationshipCreate(highId, relationshipLabel, lowId);
        InOrder lowLockingOrder = Mockito.inOrder((Object[])new Object[]{this.creationContext, this.storageLocks});
        ((StorageLocks)lowLockingOrder.verify((Object)this.storageLocks)).acquireRelationshipCreationLock((ReadableTransactionState)this.txState, LockTracer.NONE, highId, lowId);
        ((CommandCreationContext)lowLockingOrder.verify((Object)this.creationContext)).reserveRelationship(highId);
        lowLockingOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireNodeLocksWhenDeletingRelationshipInOrderOfAscendingId() {
        long relationshipId = 10L;
        long lowId = 3L;
        long highId = 5L;
        int relationshipLabel = 0;
        this.setStoreRelationship(10L, 3L, 5L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        InOrder lockingOrder = Mockito.inOrder((Object[])new Object[]{this.storageLocks});
        ((StorageLocks)lockingOrder.verify((Object)this.storageLocks)).acquireRelationshipDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, 3L, 5L, 10L);
        lockingOrder.verifyNoMoreInteractions();
        Mockito.reset((Object[])new StorageLocks[]{this.storageLocks});
        this.setStoreRelationship(10L, 5L, 3L, relationshipLabel);
        this.operations.relationshipDelete(10L);
        InOrder highLowIdOrder = Mockito.inOrder((Object[])new Object[]{this.storageLocks});
        ((StorageLocks)highLowIdOrder.verify((Object)this.storageLocks)).acquireRelationshipDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, 5L, 3L, 10L);
        highLowIdOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel(456L, 123L);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeAddingLabelToJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        this.operations.nodeAddLabel(123L, 456);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeAddingLabelToNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        int labelId = 456;
        this.operations.nodeAddLabel(123L, labelId);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddLabel((long)labelId, 123L);
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeSettingPropertyOnNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeSettingPropertyOnNode() throws Exception {
        int relatedLabelId = 50;
        int unrelatedLabelId = 51;
        int propertyKeyId = 8;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet tokenSet = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)tokenSet.all()).thenReturn((Object)new long[]{relatedLabelId});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)tokenSet);
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{relatedLabelId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{unrelatedLabelId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeSettingPropertyOnRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.NO_VALUE);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoReplaceProperty(ArgumentMatchers.eq((long)123L), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)propertyKeyId), (Value)ArgumentMatchers.eq((Object)Values.NO_VALUE), (Value)ArgumentMatchers.eq((Object)value));
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedNode() throws Exception {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.nodeDoCreate(123L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.nodeSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoAddProperty(123L, propertyKeyId, value);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeSettingPropertyOnJustCreatedRelationship() throws Exception {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        this.txState.relationshipDoCreate(123L, 42, 43L, 45L);
        int propertyKeyId = 8;
        Value value = Values.of((Object)9);
        this.operations.relationshipSetProperty(123L, propertyKeyId, value);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{123L});
        ((TransactionState)this.order.verify((Object)this.txState)).relationshipDoReplaceProperty(ArgumentMatchers.eq((long)123L), ArgumentMatchers.anyInt(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)propertyKeyId), (Value)ArgumentMatchers.eq((Object)Values.NO_VALUE), (Value)ArgumentMatchers.eq((Object)value));
    }

    @Test
    void shouldAcquireEntityWriteLockBeforeDeletingNode() {
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)TokenSet.NONE);
        this.operations.nodeDelete(123L);
        ((StorageLocks)this.order.verify((Object)this.storageLocks)).acquireNodeDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, 123L);
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    void shouldNotAcquireEntityWriteLockBeforeDeletingJustCreatedNode() {
        this.txState.nodeDoCreate(123L);
        Mockito.when((Object)this.transaction.hasTxStateWithChanges()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        this.operations.nodeDelete(123L);
        ((Locks.Client)Mockito.verify((Object)this.locks, (VerificationMode)Mockito.never())).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{123L});
        ((TransactionState)Mockito.verify((Object)this.txState)).nodeDoDelete(123L);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabelAndProperty() {
        this.allStoreHolder.constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingIndexesByLabelAndProperty() {
        this.allStoreHolder.index((SchemaDescriptor)this.schema);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageReader)Mockito.verify((Object)this.storageReader)).indexGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldNotAcquireSchemaReadLockWhenGettingIndexesByLabelAndPropertyFromSnapshot() {
        this.allStoreHolder.snapshot().index((SchemaDescriptor)this.schema);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).indexGetForSchema((SchemaDescriptor)this.schema);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByLabel() {
        this.allStoreHolder.constraintsGetForLabel(42);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{42L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForLabel(42);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeGettingConstraintsByRelationshipType() {
        this.allStoreHolder.constraintsGetForRelationshipType(42);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{42L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForRelationshipType(42);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingConstraintsByLabel() {
        this.allStoreHolder.snapshot().constraintsGetForLabel(42);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetForLabel(42);
    }

    @Test
    void shouldNotAcquireSchemaReadLockBeforeGettingConstraintsByRelationshipType() {
        this.allStoreHolder.snapshot().constraintsGetForRelationshipType(42);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetForRelationshipType(42);
    }

    @Test
    void shouldAcquireSchemaReadLockBeforeCheckingExistenceConstraints() {
        this.allStoreHolder.constraintExists((ConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema));
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{123L});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintExists((ConstraintDescriptor)ArgumentMatchers.any());
    }

    @Test
    void shouldAcquireSchemaReadLockLazilyBeforeGettingAllConstraints() {
        int labelId = 1;
        int relTypeId = 2;
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{2, 3, 3});
        RelExistenceConstraintDescriptor existenceConstraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{3, 4, 5});
        Mockito.when((Object)this.storageReader.constraintsGetAll()).thenReturn((Object)Iterators.iterator((Object[])new ConstraintDescriptor[]{uniquenessConstraint, existenceConstraint}));
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)uniquenessConstraint)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)existenceConstraint)).thenReturn((Object)true);
        Iterator result = this.allStoreHolder.constraintsGetAll();
        Assertions.assertThat((long)Iterators.count((Iterator)result)).isEqualTo(2L);
        Assertions.assertThat((List)Iterators.asList((Iterator)result)).isEmpty();
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetAll();
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.atLeastOnce())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.atLeastOnce())).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
    }

    @Test
    void shouldNotAcquireSchemaReadLockLazilyBeforeGettingAllConstraintsFromSnapshot() {
        int labelId = 1;
        int relTypeId = 2;
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{2, 3, 3});
        RelExistenceConstraintDescriptor existenceConstraint = ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{3, 4, 5});
        Mockito.when((Object)this.storageReaderSnapshot.constraintsGetAll()).thenReturn((Object)Iterators.iterator((Object[])new ConstraintDescriptor[]{uniquenessConstraint, existenceConstraint}));
        Iterator result = this.allStoreHolder.snapshot().constraintsGetAll();
        Assertions.assertThat((long)Iterators.count((Iterator)result)).isEqualTo(2L);
        Assertions.assertThat((List)Iterators.asList((Iterator)result)).isEmpty();
        ((StorageSchemaReader)Mockito.verify((Object)this.storageReaderSnapshot)).constraintsGetAll();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeRemovingIndexRule() throws Exception {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0})).withName("index").materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(index);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeRemovingIndexRuleBySchema() throws Exception {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0})).withName("index").materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexGetForSchemaAndType(index.schema(), IndexType.BTREE)).thenReturn((Object)index);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(index.schema());
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{0L});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaNameWriteLockBeforeRemovingIndexByName() throws Exception {
        String indexName = "My fancy index";
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{0})).withName(indexName).materialise(0L);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)index);
        Mockito.when((Object)this.indexingService.getIndexProxy(index)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.indexGetForName(indexName)).thenReturn((Object)index);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        this.operations.indexDrop(indexName);
        long indexNameLock = ResourceIds.schemaNameResourceId((String)indexName);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA_NAME, new long[]{indexNameLock});
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeCreatingUniquenessConstraint() throws Exception {
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        this.operations.uniquePropertyConstraintCreate(prototype);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoAdd((IndexBackedConstraintDescriptor)ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema), constraintIndex);
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfConstraintCreationFails() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.uniquePropertyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfNodeKeyConstraintCreationFails() throws Exception {
        NodeKeyConstraintDescriptor constraint = ConstraintDescriptorFactory.nodeKeyForSchema((SchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.nodeKeyConstraintCreate(IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name"));
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfNodePropertyExistenceConstraintCreationFails() throws Exception {
        NodeExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((LabelSchemaDescriptor)this.schema);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int labelId = this.schema.getLabelId();
        int propertyId = this.schema.getPropertyId();
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(labelId)).thenReturn((Object)new NamedToken("Label", labelId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", labelId));
        try {
            this.operations.nodePropertyExistenceConstraintCreate(this.schema, "constraint name");
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)this.schema);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.LABEL, new long[]{labelId});
    }

    @Test
    void shouldReleaseAcquiredSchemaWriteLockIfRelationshipPropertyExistenceConstraintCreationFails() throws Exception {
        RelationTypeSchemaDescriptor descriptor = SchemaDescriptors.forRelType((int)11, (int[])new int[]{13});
        RelExistenceConstraintDescriptor constraint = ConstraintDescriptorFactory.existsForSchema((RelationTypeSchemaDescriptor)descriptor);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        int relTypeId = descriptor.getRelTypeId();
        int propertyId = descriptor.getPropertyId();
        Mockito.when((Object)this.tokenHolders.relationshipTypeTokens().getTokenById(relTypeId)).thenReturn((Object)new NamedToken("Label", relTypeId));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(propertyId)).thenReturn((Object)new NamedToken("prop", relTypeId));
        try {
            this.operations.relationshipPropertyExistenceConstraintCreate(descriptor, "constraint name");
            org.junit.jupiter.api.Assertions.fail((String)"Expected an exception because this schema should already be constrained.");
        }
        catch (AlreadyConstrainedException alreadyConstrainedException) {
            // empty catch block
        }
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
        ((StorageReader)this.order.verify((Object)this.storageReader)).constraintsGetForSchema((SchemaDescriptor)descriptor);
        ((Locks.Client)this.order.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, new long[]{relTypeId});
    }

    @Test
    void shouldAcquireSchemaWriteLockBeforeDroppingConstraint() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint");
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint").materialise(13L);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.indexGetForName("constraint")).thenReturn((Object)index);
        this.operations.constraintDrop((ConstraintDescriptor)constraint);
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{this.schema.getLabelId()});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoDrop((ConstraintDescriptor)constraint);
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void shouldAcquireSchemaNameWriteLockBeforeDroppingConstraintByName() throws Exception {
        UniquenessConstraintDescriptor constraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint");
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint").materialise(13L);
        this.storageReaderWithConstraints((ConstraintDescriptor)constraint);
        Mockito.when((Object)this.storageReader.indexExists(index)).thenReturn((Object)true);
        Mockito.when((Object)this.storageReader.indexGetForName("constraint")).thenReturn((Object)index);
        Mockito.when((Object)this.storageReader.constraintGetForName("constraint")).thenReturn((Object)constraint);
        this.operations.constraintDrop("constraint");
        long nameLock = ResourceIds.schemaNameResourceId((String)"constraint");
        ((Locks.Client)this.order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.SCHEMA_NAME, new long[]{nameLock});
        ((TransactionState)this.order.verify((Object)this.txState)).constraintDoDrop((ConstraintDescriptor)constraint);
        ((TransactionState)this.order.verify((Object)this.txState)).indexDoDrop(index);
    }

    @Test
    void detachDeleteNodeWithoutRelationshipsExclusivelyLockNode() {
        long nodeId = 1L;
        PlainOperationsTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        ((StorageLocks)this.order.verify((Object)this.storageLocks)).acquireNodeDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    void detachDeleteNodeExclusivelyLockNodes() {
        long nodeId = 1L;
        PlainOperationsTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId).outgoing(1L, 2L, 42));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)PrimitiveLongCollections.EMPTY_LONG_ARRAY);
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        this.operations.nodeDetachDelete(nodeId);
        ((StorageLocks)this.order.verify((Object)this.storageLocks)).acquireNodeDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, nodeId);
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)this.order.verify((Object)this.locks, Mockito.never())).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{2L});
        ((TransactionState)this.order.verify((Object)this.txState)).nodeDoDelete(nodeId);
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenDeletingNode() {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, this.creationContext, this.storageLocks});
        ((StorageLocks)order.verify((Object)this.storageLocks)).acquireNodeDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, nodeId);
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{Long.MAX_VALUE});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenDetachDeletingNode() {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 2L;
        PlainOperationsTest.returnRelationships(this.transaction, new TestRelationshipChain(nodeId));
        Mockito.when((Object)this.transaction.ambientNodeCursor()).thenReturn((Object)new StubNodeCursor(false).withNode(nodeId));
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        this.operations.nodeDetachDelete(nodeId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, this.creationContext, this.storageLocks});
        ((StorageLocks)order.verify((Object)this.storageLocks)).acquireNodeDeletionLock((ReadableTransactionState)this.txState, LockTracer.NONE, nodeId);
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{Long.MAX_VALUE});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenRemovingNodeLabel() throws EntityNotFoundException {
        long nodeId = 1L;
        int labelId = 1;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.nodeCursor.hasLabel(labelId)).thenReturn((Object)true);
        this.operations.nodeRemoveLabel(nodeId, labelId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{Long.MAX_VALUE});
        order.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquiredSharedLabelLocksWhenRemovingNodeProperty() throws EntityNotFoundException {
        long nodeId = 1L;
        long labelId1 = 1L;
        long labelId2 = 1L;
        int propertyKeyId = 5;
        Mockito.when((Object)this.nodeCursor.next()).thenReturn((Object)true);
        TokenSet labels = (TokenSet)Mockito.mock(TokenSet.class);
        Mockito.when((Object)labels.all()).thenReturn((Object)new long[]{labelId1, labelId2});
        Mockito.when((Object)this.nodeCursor.labels()).thenReturn((Object)labels);
        Mockito.when((Object)this.propertyCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.propertyCursor.propertyKey()).thenReturn((Object)propertyKeyId);
        Mockito.when((Object)this.propertyCursor.propertyValue()).thenReturn((Object)Values.of((Object)"abc"));
        this.operations.nodeRemoveProperty(nodeId, propertyKeyId);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks});
        ((Locks.Client)order.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{nodeId});
        ((Locks.Client)order.verify((Object)this.locks)).acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{labelId1, labelId2});
        order.verifyNoMoreInteractions();
    }

    @Test
    void mustAssignNameToIndexesThatDoNotHaveUserSuppliedName() throws Exception {
        Mockito.when((Object)this.creationContext.reserveSchema()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(1)).thenReturn((Object)new NamedToken("LabelA", 1));
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(2)).thenReturn((Object)new NamedToken("LabelB", 1));
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(3)).thenReturn((Object)new NamedToken("LabelC", 1));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(1)).thenReturn((Object)new NamedToken("PropA", 1));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(2)).thenReturn((Object)new NamedToken("PropB", 2));
        this.storageReaderWithoutConstraints();
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn(Collections.emptyIterator());
        this.operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1})));
        this.operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{2, 3}, (int[])new int[]{1, 2})).withIndexType(IndexType.FULLTEXT));
        this.operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)3, (int[])new int[]{1})).withIndexProvider(this.operations.indexProviderByName("provider-1.0")));
        Object[] indexDescriptors = (IndexDescriptor[])this.txState.indexChanges().getAdded().stream().sorted(Comparator.comparing(d -> d.schema().getEntityTokenIds()[0])).toArray(IndexDescriptor[]::new);
        ((AbstractIntegerAssert)Assertions.assertThat((int)indexDescriptors.length).as(Arrays.toString(indexDescriptors), new Object[0])).isEqualTo(3);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[0].getId()).as(indexDescriptors[0].toString(), new Object[0])).isEqualTo(1L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[1].getId()).as(indexDescriptors[1].toString(), new Object[0])).isEqualTo(2L);
        ((AbstractLongAssert)Assertions.assertThat((long)indexDescriptors[2].getId()).as(indexDescriptors[2].toString(), new Object[0])).isEqualTo(3L);
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[0].getName()).as(indexDescriptors[0].toString(), new Object[0])).isEqualTo("index_5c81a58e");
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[1].getName()).as(indexDescriptors[1].toString(), new Object[0])).isEqualTo("index_2813986a");
        ((AbstractStringAssert)Assertions.assertThat((String)indexDescriptors[2].getName()).as(indexDescriptors[2].toString(), new Object[0])).isEqualTo("index_edb2dfd3");
    }

    @Test
    void uniqueIndexesMustBeNamedAfterTheirConstraints() throws KernelException {
        Mockito.when((Object)this.creationContext.reserveSchema()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L});
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        String constraintName = "my_constraint";
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.any(), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenAnswer(i -> {
            IndexPrototype prototype = (IndexPrototype)i.getArgument(2);
            Optional name = prototype.getName();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)name.isPresent());
            Assertions.assertThat((String)((String)name.get())).isEqualTo(constraintName);
            return prototype.materialise(2L);
        });
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName(constraintName);
        IndexBackedConstraintDescriptor constraint = this.operations.uniquePropertyConstraintCreate(prototype).asIndexBackedConstraint();
        Assertions.assertThat((long)constraint.ownedIndexId()).isEqualTo(2L);
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingNodeIdInBareCreateMethod() {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        Mockito.when((Object)ktx.securityAuthorizationHandler()).thenReturn((Object)new SecurityAuthorizationHandler((AbstractSecurityLog)CommunitySecurityLog.NULL_LOG));
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        Operations operations = new Operations((AllStoreHolder)Mockito.mock(AllStoreHolder.class), (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, (StorageLocks)Mockito.mock(StorageLocks.class), ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        operations.nodeCreate();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveNode();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingNodeIdInCreateWithLabelsMethod() throws ConstraintValidationException {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        Mockito.when((Object)ktx.securityAuthorizationHandler()).thenReturn((Object)new SecurityAuthorizationHandler((AbstractSecurityLog)CommunitySecurityLog.NULL_LOG));
        Locks.Client lockClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)ktx.lockClient()).thenReturn((Object)lockClient);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        DefaultPooledCursors cursors = (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class);
        Mockito.when((Object)cursors.allocateFullAccessNodeCursor(CursorContext.NULL)).thenReturn((Object)((FullAccessNodeCursor)Mockito.mock(FullAccessNodeCursor.class)));
        Mockito.when((Object)cursors.allocateFullAccessPropertyCursor(CursorContext.NULL, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).thenReturn((Object)((FullAccessPropertyCursor)Mockito.mock(FullAccessPropertyCursor.class)));
        Operations operations = new Operations((AllStoreHolder)Mockito.mock(AllStoreHolder.class), (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, (StorageLocks)Mockito.mock(StorageLocks.class), ktx, (KernelToken)Mockito.mock(KernelToken.class), cursors, (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        operations.initialize(CursorContext.NULL);
        operations.nodeCreateWithLabels(new int[]{1});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveNode();
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingRelationshipId() throws EntityNotFoundException {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        Locks.Client lockClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)ktx.lockClient()).thenReturn((Object)lockClient);
        Mockito.when((Object)ktx.securityContext()).thenReturn((Object)SecurityContext.AUTH_DISABLED);
        Mockito.when((Object)ktx.securityAuthorizationHandler()).thenReturn((Object)new SecurityAuthorizationHandler((AbstractSecurityLog)CommunitySecurityLog.NULL_LOG));
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        AllStoreHolder allStoreHolder = (AllStoreHolder)Mockito.mock(AllStoreHolder.class);
        Mockito.when((Object)allStoreHolder.nodeExists(ArgumentMatchers.anyLong())).thenReturn((Object)true);
        Operations operations = new Operations(allStoreHolder, (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, (StorageLocks)Mockito.mock(StorageLocks.class), ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class), Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        operations.relationshipCreate(0L, 1, 2L);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveRelationship(ArgumentMatchers.anyLong());
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldAcquireTxStateBeforeAllocatingSchemaId() throws KernelException {
        KernelTransactionImplementation ktx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)ktx.txState()).thenReturn((Object)((TransactionState)Mockito.mock(TransactionState.class)));
        Locks.Client lockClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)ktx.lockClient()).thenReturn((Object)lockClient);
        CommandCreationContext commandCreationContext = (CommandCreationContext)Mockito.mock(CommandCreationContext.class);
        IndexingProvidersService indexingProvidersService = (IndexingProvidersService)Mockito.mock(IndexingProvidersService.class);
        Mockito.when((Object)indexingProvidersService.getDefaultProvider()).thenReturn((Object)((IndexProviderDescriptor)Mockito.mock(IndexProviderDescriptor.class)));
        AllStoreHolder allStoreHolder = (AllStoreHolder)Mockito.mock(AllStoreHolder.class);
        Mockito.when((Object)allStoreHolder.index((SchemaDescriptor)ArgumentMatchers.any(), (IndexType)ArgumentMatchers.any())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        Mockito.when((Object)allStoreHolder.indexGetForName((String)ArgumentMatchers.any())).thenReturn((Object)IndexDescriptor.NO_INDEX);
        Mockito.when((Object)allStoreHolder.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn((Object)Iterators.emptyResourceIterator());
        Operations operations = new Operations(allStoreHolder, (StorageReader)Mockito.mock(StorageReader.class), (IndexTxStateUpdater)Mockito.mock(IndexTxStateUpdater.class), commandCreationContext, (StorageLocks)Mockito.mock(StorageLocks.class), ktx, (KernelToken)Mockito.mock(KernelToken.class), (DefaultPooledCursors)Mockito.mock(DefaultPooledCursors.class), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), (ConstraintSemantics)Mockito.mock(ConstraintSemantics.class), indexingProvidersService, Config.defaults(), (MemoryTracker)EmptyMemoryTracker.INSTANCE, () -> KernelVersion.LATEST, (DbmsRuntimeRepository)Mockito.mock(DbmsRuntimeRepository.class));
        operations.indexCreate(IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("name"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{ktx, commandCreationContext});
        ((KernelTransactionImplementation)inOrder.verify((Object)ktx)).txState();
        ((CommandCreationContext)inOrder.verify((Object)commandCreationContext)).reserveSchema();
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnIndexTypeFullText() throws Exception {
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).withIndexType(IndexType.FULLTEXT);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)new InMemoryTokens())).contains(new CharSequence[]{"FULLTEXT"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnFulltextSchemas() throws Exception {
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])this.schema.getEntityTokenIds(), (int[])this.schema.getPropertyIds());
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).contains(new CharSequence[]{"full-text schema"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnRelationshipSchemas() throws Exception {
        Mockito.when((Object)this.tokenHolders.relationshipTypeTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("RelType", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)this.schema.getEntityTokenIds()[0], (int[])this.schema.getPropertyIds());
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).contains(new CharSequence[]{"relationship type schema"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnAnyTokenSchemas() throws Exception {
        AnyTokenSchemaDescriptor schema = SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.NODE);
        IndexPrototype prototype = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).contains(new CharSequence[]{"any token schema"});
    }

    @Test
    void indexedBackedConstraintCreateMustThrowOnNonUniqueIndexPrototypes() throws Exception {
        Mockito.when((Object)this.tokenHolders.labelTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("Label", 123));
        Mockito.when((Object)this.tokenHolders.propertyKeyTokens().getTokenById(ArgumentMatchers.anyInt())).thenReturn((Object)new NamedToken("prop", 456));
        IndexPrototype prototype = IndexPrototype.forSchema((SchemaDescriptor)this.schema).withName("constraint name").withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR);
        IndexDescriptor constraintIndex = prototype.materialise(42L);
        Mockito.when((Object)this.constraintIndexCreator.createUniquenessConstraintIndex((KernelTransactionImplementation)ArgumentMatchers.any(), (IndexBackedConstraintDescriptor)ArgumentMatchers.any(), (IndexPrototype)ArgumentMatchers.eq((Object)prototype), (ConstraintIndexCreator.PropertyExistenceEnforcer)ArgumentMatchers.any())).thenReturn((Object)constraintIndex);
        IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
        Mockito.when((Object)indexProxy.getDescriptor()).thenReturn((Object)constraintIndex);
        Mockito.when((Object)this.indexingService.getIndexProxy(constraintIndex)).thenReturn((Object)indexProxy);
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.storageReader.indexGetForSchema((SchemaDescriptor)this.schema)).thenReturn(Collections.emptyIterator());
        KernelException e = (KernelException)org.junit.jupiter.api.Assertions.assertThrows(KernelException.class, () -> this.operations.uniquePropertyConstraintCreate(prototype));
        ((AbstractStringAssert)Assertions.assertThat((String)e.getUserMessage((TokenNameLookup)this.tokenHolders)).containsIgnoringCase((CharSequence)"index prototype")).containsIgnoringCase((CharSequence)"not unique");
    }

    @Test
    void nodeAddLabelShouldSucceedWriteOnly() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.WRITE_ONLY, true);
    }

    @Test
    void nodeAddLabelShouldSucceedWrite() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.WRITE, true);
    }

    @Test
    void nodeAddLabelShouldSucceedWriteFull() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeAddLabel(1L, 2), (AccessMode)AccessMode.Static.FULL, true);
    }

    @Test
    void nodeRemoveLabelShouldSucceedWriteOnly() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.WRITE_ONLY, true);
    }

    @Test
    void nodeRemoveLabelShouldSucceedWrite() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.WRITE, true);
    }

    @Test
    void nodeRemoveLabelShouldSucceedWriteFull() throws Exception {
        this.runForSecurityLevel(() -> this.operations.nodeRemoveLabel(1L, 3), (AccessMode)AccessMode.Static.FULL, true);
    }

    private static Iterator<ConstraintDescriptor> asIterator(ConstraintDescriptor constraint) {
        return Collections.singletonList(constraint).iterator();
    }

    private void storageReaderWithConstraints(ConstraintDescriptor constraint) {
        Mockito.when((Object)this.storageReader.constraintsGetForSchema(constraint.schema())).thenReturn(PlainOperationsTest.asIterator(constraint));
        Mockito.when((Object)this.storageReader.constraintExists(constraint)).thenReturn((Object)true);
    }

    private void storageReaderWithoutConstraints() {
        Mockito.when((Object)this.storageReader.constraintsGetForSchema((SchemaDescriptor)ArgumentMatchers.any())).thenReturn(Iterables.empty().iterator());
        Mockito.when((Object)this.storageReader.constraintExists((ConstraintDescriptor)ArgumentMatchers.any())).thenReturn((Object)false);
    }

    private void setStoreRelationship(long relationshipId, long sourceNode, long targetNode, int relationshipLabel) {
        Mockito.when((Object)this.relationshipCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)this.relationshipCursor.relationshipReference()).thenReturn((Object)relationshipId);
        Mockito.when((Object)this.relationshipCursor.sourceNodeReference()).thenReturn((Object)sourceNode);
        Mockito.when((Object)this.relationshipCursor.targetNodeReference()).thenReturn((Object)targetNode);
        Mockito.when((Object)this.relationshipCursor.type()).thenReturn((Object)relationshipLabel);
    }
}

