/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DbmsLogEntryWriterFactory;
import org.neo4j.kernel.database.LogEntryWriterFactory;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PositionAwarePhysicalFlushableChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFiles;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;

@ExtendWith(value={LifeExtension.class})
class BatchingTransactionAppenderTest {
    @Inject
    private LifeSupport life;
    private final InMemoryVersionableReadableClosablePositionAwareChannel channel = new InMemoryVersionableReadableClosablePositionAwareChannel();
    private final LogAppendEvent logAppendEvent = LogAppendEvent.NULL;
    private final Health databaseHealth = (Health)Mockito.mock(DatabaseHealth.class);
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
    private final LogFiles logFiles = (LogFiles)Mockito.mock(TransactionLogFiles.class);
    private final TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final TransactionMetadataCache positionCache = new TransactionMetadataCache();

    BatchingTransactionAppenderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.logFiles.getLogFile()).thenReturn((Object)this.logFile);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(1L, -559063315, 1L));
    }

    @Test
    void shouldAppendSingleTransaction() throws Exception {
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter((FlushablePositionAwareChecksumChannel)this.channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        long txId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(txId, -559063315, 0L));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender());
        TransactionRepresentation transaction = BatchingTransactionAppenderTest.transaction(BatchingTransactionAppenderTest.singleTestCommand(), new byte[]{1, 2, 5}, 12345L, 4545L, 12355L);
        appender.append(new TransactionToApply(transaction, CursorContext.NULL, StoreCursors.NULL), this.logAppendEvent);
        LogEntryReader logEntryReader = TestLogEntryReader.logEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.channel, logEntryReader);){
            reader.next();
            TransactionRepresentation tx = reader.get().getTransactionRepresentation();
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])transaction.additionalHeader(), (byte[])tx.additionalHeader());
            org.junit.jupiter.api.Assertions.assertEquals((long)transaction.getTimeStarted(), (long)tx.getTimeStarted());
            org.junit.jupiter.api.Assertions.assertEquals((long)transaction.getTimeCommitted(), (long)tx.getTimeCommitted());
            org.junit.jupiter.api.Assertions.assertEquals((long)transaction.getLatestCommittedTxWhenStarted(), (long)tx.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    void shouldAppendBatchOfTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter((FlushablePositionAwareChecksumChannel)this.channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender());
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)2L, (Object[])new Long[]{3L, 4L});
        TransactionToApply batch = BatchingTransactionAppenderTest.batchOf(BatchingTransactionAppenderTest.transaction(BatchingTransactionAppenderTest.singleTestCommand(), new byte[0], 0L, 1L, 0L), BatchingTransactionAppenderTest.transaction(BatchingTransactionAppenderTest.singleTestCommand(), new byte[0], 0L, 1L, 0L), BatchingTransactionAppenderTest.transaction(BatchingTransactionAppenderTest.singleTestCommand(), new byte[0], 0L, 1L, 0L));
        appender.append(batch, this.logAppendEvent);
        TransactionToApply tx = batch;
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)tx.transactionId());
        tx = tx.next();
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)tx.transactionId());
        tx = tx.next();
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)tx.transactionId());
        org.junit.jupiter.api.Assertions.assertNull((Object)tx.next());
    }

    @Test
    void shouldAppendCommittedTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter((FlushablePositionAwareChecksumChannel)this.channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        long nextTxId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)nextTxId);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(nextTxId, -559063315, 0L));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFiles, this.positionCache, this.transactionIdStore, this.databaseHealth));
        byte[] additionalHeader = new byte[]{1, 2, 5};
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = nextTxId - 5L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(BatchingTransactionAppenderTest.singleTestCommand());
        transactionRepresentation.setHeader(additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted, -1, AuthSubject.ANONYMOUS);
        LogEntryStart start = new LogEntryStart(0L, latestCommittedTxWhenStarted, 0, null, LogPosition.UNSPECIFIED);
        LogEntryCommit commit = new LogEntryCommit(nextTxId, 0L, -559063315);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, commit);
        appender.append(new TransactionToApply((TransactionRepresentation)transactionRepresentation, transaction.getCommitEntry().getTxId(), CursorContext.NULL, StoreCursors.NULL), this.logAppendEvent);
        LogEntryReader logEntryReader = TestLogEntryReader.logEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableClosablePositionAwareChecksumChannel)this.channel, logEntryReader);){
            reader.next();
            TransactionRepresentation result = reader.get().getTransactionRepresentation();
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])additionalHeader, (byte[])result.additionalHeader());
            org.junit.jupiter.api.Assertions.assertEquals((long)12345L, (long)result.getTimeStarted());
            org.junit.jupiter.api.Assertions.assertEquals((long)timeCommitted, (long)result.getTimeCommitted());
            org.junit.jupiter.api.Assertions.assertEquals((long)latestCommittedTxWhenStarted, (long)result.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    void shouldNotAppendCommittedTransactionsWhenTooFarAhead() {
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter((FlushablePositionAwareChecksumChannel)channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender());
        byte[] additionalHeader = new byte[]{1, 2, 5};
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(BatchingTransactionAppenderTest.singleTestCommand());
        transactionRepresentation.setHeader(additionalHeader, 12345L, latestCommittedTxWhenStarted, timeCommitted, -1, AuthSubject.ANONYMOUS);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)latestCommittedTxWhenStarted);
        LogEntryStart start = new LogEntryStart(0L, latestCommittedTxWhenStarted, 0, null, LogPosition.UNSPECIFIED);
        LogEntryCommit commit = new LogEntryCommit(latestCommittedTxWhenStarted + 2L, 0L, -559063315);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, commit);
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> appender.append(new TransactionToApply(transaction.getTransactionRepresentation(), transaction.getCommitEntry().getTxId(), CursorContext.NULL, StoreCursors.NULL), this.logAppendEvent));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"to be applied, but appending it ended up generating an"});
    }

    @Test
    void shouldNotCallTransactionClosedOnFailedAppendedTransaction() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        FlushablePositionAwareChecksumChannel channel = (FlushablePositionAwareChecksumChannel)Mockito.spy((Object)new PositionAwarePhysicalFlushableChecksumChannel((LogVersionedStoreChannel)Mockito.mock(PhysicalLogVersionedStoreChannel.class), (ScopedBuffer)new HeapScopedBuffer(16, (MemoryTracker)EmptyMemoryTracker.INSTANCE)));
        IOException failure = new IOException(failureMessage);
        Mockito.when((Object)channel.putLong(ArgumentMatchers.anyLong())).thenThrow(new Throwable[]{failure});
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter(channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(txId, -559063315, 0L));
        Mockito.reset((Object[])new Health[]{this.databaseHealth});
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender());
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> appender.append(new TransactionToApply(transaction, CursorContext.NULL, StoreCursors.NULL), this.logAppendEvent));
        org.junit.jupiter.api.Assertions.assertSame((Object)failure, (Object)e);
        ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore)).nextCommittingTransactionId();
        ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.never())).transactionClosed(ArgumentMatchers.eq((long)txId), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (CursorContext)ArgumentMatchers.any(CursorContext.class));
        ((Health)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)failure);
    }

    @Test
    void shouldNotCallTransactionClosedOnFailedForceLogToDisk() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        FlushablePositionAwareChecksumChannel channel = (FlushablePositionAwareChecksumChannel)Mockito.spy((Object)new InMemoryClosableChannel());
        IOException failure = new IOException(failureMessage);
        Flushable flushable = (Flushable)Mockito.mock(Flushable.class);
        ((FlushablePositionAwareChecksumChannel)Mockito.doAnswer(invocation -> {
            invocation.callRealMethod();
            return flushable;
        }).when((Object)channel)).prepareForFlush();
        Mockito.when((Object)this.logFile.forceAfterAppend((LogForceEvents)ArgumentMatchers.any())).thenThrow(new Throwable[]{failure});
        Mockito.when((Object)this.logFile.getTransactionLogWriter()).thenReturn((Object)new TransactionLogWriter(channel, (LogEntryWriterFactory)new DbmsLogEntryWriterFactory(() -> KernelVersion.LATEST)));
        TransactionMetadataCache metadataCache = new TransactionMetadataCache();
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransaction()).thenReturn((Object)new TransactionId(txId, -559063315, 0L));
        TransactionAppender appender = (TransactionAppender)this.life.add((Lifecycle)new BatchingTransactionAppender(this.logFiles, metadataCache, transactionIdStore, this.databaseHealth));
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        IOException e = (IOException)org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> appender.append(new TransactionToApply(transaction, CursorContext.NULL, StoreCursors.NULL), this.logAppendEvent));
        org.junit.jupiter.api.Assertions.assertSame((Object)failure, (Object)e);
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore)).nextCommittingTransactionId();
        ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.never())).transactionClosed(ArgumentMatchers.eq((long)txId), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (CursorContext)ArgumentMatchers.any(CursorContext.class));
    }

    @Test
    void shouldKernelPanicIfTransactionIdsMismatch() {
        BatchingTransactionAppender appender = (BatchingTransactionAppender)this.life.add((Lifecycle)this.createTransactionAppender());
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)42L);
        TransactionToApply batch = new TransactionToApply((TransactionRepresentation)Mockito.mock(TransactionRepresentation.class), 43L, CursorContext.NULL, StoreCursors.NULL);
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> appender.append(batch, LogAppendEvent.NULL));
        ((Health)Mockito.verify((Object)this.databaseHealth)).panic((Throwable)e);
    }

    private BatchingTransactionAppender createTransactionAppender() {
        return new BatchingTransactionAppender(this.logFiles, this.positionCache, this.transactionIdStore, this.databaseHealth);
    }

    private static TransactionRepresentation transaction(List<StorageCommand> commands, byte[] additionalHeader, long timeStarted, long latestCommittedTxWhenStarted, long timeCommitted) {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(additionalHeader, timeStarted, latestCommittedTxWhenStarted, timeCommitted, -1, AuthSubject.ANONYMOUS);
        return tx;
    }

    private static List<StorageCommand> singleTestCommand() {
        return Collections.singletonList(new TestCommand());
    }

    private static TransactionToApply batchOf(TransactionRepresentation ... transactions) {
        TransactionToApply first = null;
        TransactionToApply last = null;
        for (TransactionRepresentation transaction : transactions) {
            TransactionToApply tx = new TransactionToApply(transaction, CursorContext.NULL, StoreCursors.NULL);
            if (first == null) {
                first = last = tx;
                continue;
            }
            last.next(tx);
            last = tx;
        }
        return first;
    }
}

