/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionLogQueue;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class TransactionLogQueueIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private DatabaseLayout databaseLayout;
    private ThreadPoolJobScheduler jobScheduler;
    private SimpleLogVersionRepository logVersionRepository;
    private SimpleTransactionIdStore transactionIdStore;
    private TransactionMetadataCache metadataCache;
    private Config config;
    private DatabaseHealth databaseHealth;
    private NullLogProvider logProvider;

    TransactionLogQueueIT() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.logVersionRepository = new SimpleLogVersionRepository();
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logProvider = NullLogProvider.getInstance();
        this.metadataCache = new TransactionMetadataCache();
        this.config = Config.defaults();
        this.databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, this.logProvider.getLog(DatabaseHealth.class));
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
        this.jobScheduler.close();
    }

    @Test
    void processMessagesByTheTransactionQueue() throws IOException, ExecutionException, InterruptedException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        TransactionLogQueue logQueue = this.createLogQueue(logFiles);
        this.life.add((Lifecycle)logQueue);
        long committedTransactionId = this.transactionIdStore.getLastCommittedTransactionId();
        for (int i = 0; i < 100; ++i) {
            TransactionToApply transaction = TransactionLogQueueIT.createTransaction();
            org.junit.jupiter.api.Assertions.assertEquals((long)(++committedTransactionId), (Long)((Long)logQueue.submit(transaction, LogAppendEvent.NULL).get()));
        }
    }

    @Test
    void doNotProcessMessagesAfterShutdown() throws IOException, ExecutionException, InterruptedException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        TransactionLogQueue logQueue = this.createLogQueue(logFiles);
        this.life.add((Lifecycle)logQueue);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> (Long)logQueue.submit(TransactionLogQueueIT.createTransaction(), LogAppendEvent.NULL).get());
        logQueue.shutdown();
        Assertions.assertThatThrownBy(() -> logQueue.submit(TransactionLogQueueIT.createTransaction(), LogAppendEvent.NULL).get()).hasRootCauseInstanceOf(DatabaseShutdownException.class);
    }

    @Test
    void stillProcessMessagesAfterStop() throws Exception {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        TransactionLogQueue logQueue = this.createLogQueue(logFiles);
        this.life.add((Lifecycle)logQueue);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> (Long)logQueue.submit(TransactionLogQueueIT.createTransaction(), LogAppendEvent.NULL).get());
        logQueue.stop();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> (Long)logQueue.submit(TransactionLogQueueIT.createTransaction(), LogAppendEvent.NULL).get());
    }

    private static TransactionToApply createTransaction() {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(List.of(new TestCommand()));
        tx.setHeader(ArrayUtils.EMPTY_BYTE_ARRAY, 1L, 2L, 3L, 4, AuthSubject.ANONYMOUS);
        return new TransactionToApply((TransactionRepresentation)tx, CursorContext.NULL, StoreCursors.NULL);
    }

    private TransactionLogQueue createLogQueue(LogFiles logFiles) {
        return new TransactionLogQueue(logFiles, (TransactionIdStore)this.transactionIdStore, (Health)this.databaseHealth, this.metadataCache, this.config, (JobScheduler)this.jobScheduler, (LogProvider)this.logProvider);
    }

    private LogFiles buildLogFiles(SimpleLogVersionRepository logVersionRepository, SimpleTransactionIdStore transactionIdStore) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)logVersionRepository).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
    }
}

