/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.github.jamm.MemoryMeter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.util.collection.HeapTrackingOrderedAppendMap;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;

class HeapTrackingOrderedAppendMapTest {
    private final MemoryMeter meter = new MemoryMeter();
    private final MemoryTracker memoryTracker = new LocalMemoryTracker();
    private final HeapTrackingOrderedAppendMap<LongValue, LongValue> table = HeapTrackingOrderedAppendMap.createOrderedMap((MemoryTracker)this.memoryTracker);

    HeapTrackingOrderedAppendMapTest() {
    }

    @AfterEach
    void tearDown() {
        this.table.close();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.estimatedHeapMemory(), (String)"Leaking memory");
    }

    @Test
    void emptySize() {
        long actual = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actual, (long)this.memoryTracker.estimatedHeapMemory());
    }

    @Test
    void countInternalStructure() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        LongValue key1 = Values.longValue((long)1L);
        LongValue key2 = Values.longValue((long)2L);
        LongValue key3 = Values.longValue((long)3L);
        LongValue value1 = Values.longValue((long)11L);
        LongValue value2 = Values.longValue((long)12L);
        LongValue value3 = Values.longValue((long)13L);
        this.table.getIfAbsentPutWithMemoryTracker((Object)key1, (Function & Serializable)scopedMemoryTracker -> {
            scopedMemoryTracker.allocateHeap(key1.estimatedHeapUsage() + value1.estimatedHeapUsage());
            return value1;
        });
        this.table.getIfAbsentPutWithMemoryTracker((Object)key2, (Function & Serializable)scopedMemoryTracker -> {
            scopedMemoryTracker.allocateHeap(key2.estimatedHeapUsage() + value2.estimatedHeapUsage());
            return value2;
        });
        this.table.getIfAbsentPutWithMemoryTracker((Object)key3, (Function & Serializable)scopedMemoryTracker -> {
            scopedMemoryTracker.allocateHeap(key3.estimatedHeapUsage() + value3.estimatedHeapUsage());
            return value3;
        });
        Assertions.assertEquals((Object)value1, (Object)this.table.getIfAbsentPutWithMemoryTracker((Object)key1, (Function & Serializable)scopedMemoryTracker -> (LongValue)Assertions.fail()));
        Assertions.assertEquals((Object)value2, (Object)this.table.getIfAbsentPutWithMemoryTracker((Object)key2, (Function & Serializable)scopedMemoryTracker -> (LongValue)Assertions.fail()));
        Assertions.assertEquals((Object)value3, (Object)this.table.getIfAbsentPutWithMemoryTracker((Object)key3, (Function & Serializable)scopedMemoryTracker -> (LongValue)Assertions.fail()));
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)actualSize, (long)(this.memoryTracker.estimatedHeapMemory() - externalAllocation));
        Iterator iterator = this.table.autoClosingEntryIterator();
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)value1, ((Map.Entry)iterator.next()).getValue());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)value2, ((Map.Entry)iterator.next()).getValue());
        Assertions.assertTrue((boolean)iterator.hasNext());
        Assertions.assertEquals((Object)value3, ((Map.Entry)iterator.next()).getValue());
        Assertions.assertFalse((boolean)iterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, iterator::next);
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }

    @Test
    void closeShouldReleaseEverything() {
        long externalAllocation = 113L;
        this.memoryTracker.allocateHeap(externalAllocation);
        LongValue key1 = Values.longValue((long)1L);
        LongValue value1 = Values.longValue((long)11L);
        this.table.getIfAbsentPutWithMemoryTracker((Object)key1, (Function & Serializable)scopedMemoryTracker -> {
            scopedMemoryTracker.allocateHeap(key1.estimatedHeapUsage() + value1.estimatedHeapUsage());
            return value1;
        });
        long actualSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertEquals((long)(actualSize + externalAllocation), (long)this.memoryTracker.estimatedHeapMemory());
        this.table.close();
        Assertions.assertEquals((long)externalAllocation, (long)this.memoryTracker.estimatedHeapMemory());
        this.memoryTracker.releaseHeap(externalAllocation);
    }

    @Test
    void shouldNotUseMoreMemoryThanLinkedHashMap() {
        long actualLhmSize;
        Random random = new Random(1337L);
        LinkedHashMap<Object, Object> lhm = new LinkedHashMap<Object, Object>();
        ScopedMemoryTracker lhmMemoryTracker = new ScopedMemoryTracker((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int nEntries = 49000;
        for (int i = 0; i < nEntries; ++i) {
            long keyLong = random.nextLong();
            LongValue key = Values.longValue((long)keyLong);
            LongValue value = Values.longValue((long)i);
            this.table.getIfAbsentPutWithMemoryTracker2((Object)key, (Function2 & Serializable)(k, scopedMemoryTracker) -> {
                scopedMemoryTracker.allocateHeap(k.estimatedHeapUsage() + value.estimatedHeapUsage());
                return value;
            });
            lhm.computeIfAbsent(key, k -> {
                lhmMemoryTracker.allocateHeap(key.estimatedHeapUsage() + value.estimatedHeapUsage());
                return value;
            });
        }
        long actualTableSize = this.meter.measureDeep(this.table) - this.meter.measureDeep((Object)this.memoryTracker);
        Assertions.assertTrue((actualTableSize <= (actualLhmSize = this.meter.measureDeep(lhm)) ? 1 : 0) != 0, (String)"Used more memory than a LinkedHashMap.");
        Assertions.assertTrue(((double)Math.abs(actualTableSize - this.memoryTracker.estimatedHeapMemory()) < (double)actualTableSize * 0.1 ? 1 : 0) != 0, (String)String.format("Mis-estimation of %s%% exceeds 10%%. Actual heap usage=%s. Estimated heap usage=%s.", Math.round((double)Math.abs(actualTableSize - this.memoryTracker.estimatedHeapMemory()) / (double)actualTableSize * 100.0), actualTableSize, this.memoryTracker.estimatedHeapMemory()));
        Iterator tableIter = this.table.autoClosingEntryIterator();
        Iterator lhmIter = lhm.entrySet().iterator();
        while (lhmIter.hasNext()) {
            Assertions.assertTrue((boolean)tableIter.hasNext());
            Assertions.assertEquals(lhmIter.next(), tableIter.next());
        }
        Assertions.assertFalse((boolean)tableIter.hasNext());
    }
}

