/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapCollectionsFactory;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryLimitExceededException;
import org.neo4j.memory.MemoryTracker;

class OffHeapCollectionsFactoryTest {
    OffHeapCollectionsFactoryTest() {
    }

    @Test
    void shouldNotLeakNativeMemoryWhenAllocatingCloseToLimit() {
        LocalMemoryTracker memoryTracker = new LocalMemoryTracker();
        OffHeapCollectionsFactory factory = new OffHeapCollectionsFactory((OffHeapBlockAllocator)new CachingOffHeapBlockAllocator());
        memoryTracker.setLimit(ByteUnit.kibiBytes((long)512L) + 1L);
        Assertions.assertThatThrownBy(() -> factory.newValuesMap((MemoryTracker)memoryTracker)).isInstanceOf(MemoryLimitExceededException.class);
        factory.release();
        Assertions.assertThat((long)memoryTracker.usedNativeMemory()).isZero();
    }
}

