/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.index.EntityRange;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.NativeAllEntriesTokenScanReaderTest;
import org.neo4j.kernel.impl.index.schema.TokenScanValueIndexProgressor;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
public class TokenScanValueIndexProgressorTest {
    @Inject
    private RandomSupport random;

    @Test
    void shouldNotProgressOnEmptyCursor() {
        MyClient client = new MyClient();
        TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(NativeAllEntriesTokenScanReaderTest.EMPTY_CURSOR, (IndexProgressor.EntityTokenClient)client, IndexOrder.ASCENDING, EntityRange.FULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)progressor.next());
        Assertions.assertThat(client.observedIds).isEmpty();
    }

    @Test
    void shouldProgressAscendingThroughBitSet() {
        List<NativeAllEntriesTokenScanReaderTest.Labels> labels = NativeAllEntriesTokenScanReaderTest.randomData(this.random);
        for (NativeAllEntriesTokenScanReaderTest.Labels label : labels) {
            long[] nodeIds = label.getNodeIds();
            MyClient client = new MyClient();
            TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(label.cursor(), (IndexProgressor.EntityTokenClient)client, IndexOrder.ASCENDING, EntityRange.FULL);
            while (progressor.next()) {
            }
            Assertions.assertThat(client.observedIds).containsExactly((Object[])((Long[])LongStream.of(nodeIds).boxed().toArray(Long[]::new)));
        }
    }

    @Test
    void shouldProgressDescendingThroughBitSet() {
        List<NativeAllEntriesTokenScanReaderTest.Labels> labels = NativeAllEntriesTokenScanReaderTest.randomData(this.random);
        for (NativeAllEntriesTokenScanReaderTest.Labels label : labels) {
            long[] nodeIds = label.getNodeIds();
            MyClient client = new MyClient();
            TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(label.descendingCursor(), (IndexProgressor.EntityTokenClient)client, IndexOrder.DESCENDING, EntityRange.FULL);
            while (progressor.next()) {
            }
            Assertions.assertThat(client.observedIds).containsExactly((Object[])((Long[])LongStream.of(nodeIds).boxed().sorted(Collections.reverseOrder()).toArray(Long[]::new)));
        }
    }

    @Test
    void shouldRespectRequestedRange() {
        NativeAllEntriesTokenScanReaderTest.Labels label = NativeAllEntriesTokenScanReaderTest.labels(1, 20L, 39L, 40L, 41L, 60L, 80L, 99L, 100L, 101L, 120L);
        MyClient client = new MyClient();
        TokenScanValueIndexProgressor progressor = new TokenScanValueIndexProgressor(label.cursor(), (IndexProgressor.EntityTokenClient)client, IndexOrder.ASCENDING, new EntityRange(40L, 100L));
        while (progressor.next()) {
        }
        Assertions.assertThat(client.observedIds).containsExactlyInAnyOrder((Object[])new Long[]{40L, 41L, 60L, 80L, 99L});
    }

    static class MyClient
    implements IndexProgressor.EntityTokenClient {
        final List<Long> observedIds = new ArrayList<Long>();

        MyClient() {
        }

        public void initialize(IndexProgressor progressor, int token, IndexOrder order) {
        }

        public void initialize(IndexProgressor progressor, int token, LongIterator added, LongSet removed, AccessMode accessMode) {
        }

        public boolean acceptEntity(long reference, TokenSet tokens) {
            this.observedIds.add(reference);
            return true;
        }
    }
}

