/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.impl.newapi.EntityWithPropertyValues;
import org.neo4j.kernel.impl.newapi.SortedMergeJoin;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class SortedMergeJoinTest {
    SortedMergeJoinTest() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithEmptyLists(IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorksOneWay(Collections.emptyList(), Collections.emptyList(), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithAList(IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorks(Arrays.asList(SortedMergeJoinTest.node(1L, "a"), SortedMergeJoinTest.node(3L, "aa"), SortedMergeJoinTest.node(5L, "c"), SortedMergeJoinTest.node(7L, "g")), Collections.emptyList(), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWith2Lists(IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorks(Arrays.asList(SortedMergeJoinTest.node(1L, "a"), SortedMergeJoinTest.node(3L, "aa"), SortedMergeJoinTest.node(5L, "c"), SortedMergeJoinTest.node(7L, "g")), Arrays.asList(SortedMergeJoinTest.node(2L, "b"), SortedMergeJoinTest.node(4L, "ba"), SortedMergeJoinTest.node(6L, "ca"), SortedMergeJoinTest.node(8L, "d")), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithSameElements(IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorks(Arrays.asList(SortedMergeJoinTest.node(1L, "a"), SortedMergeJoinTest.node(3L, "b"), SortedMergeJoinTest.node(5L, "c")), Arrays.asList(SortedMergeJoinTest.node(2L, "aa"), SortedMergeJoinTest.node(3L, "b"), SortedMergeJoinTest.node(6L, "ca")), indexOrder);
    }

    @ParameterizedTest
    @EnumSource(value=IndexOrder.class, names={"ASCENDING", "DESCENDING"})
    void shouldWorkWithCompositeValues(IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorks(Arrays.asList(SortedMergeJoinTest.node(1L, "a", "a"), SortedMergeJoinTest.node(3L, "b", "a"), SortedMergeJoinTest.node(5L, "b", "b"), SortedMergeJoinTest.node(7L, "c", "d")), Arrays.asList(SortedMergeJoinTest.node(2L, "a", "b"), SortedMergeJoinTest.node(5L, "b", "b"), SortedMergeJoinTest.node(6L, "c", "e")), indexOrder);
    }

    private static void assertThatItWorks(List<EntityWithPropertyValues> listA, List<EntityWithPropertyValues> listB, IndexOrder indexOrder) {
        SortedMergeJoinTest.assertThatItWorksOneWay(listA, listB, indexOrder);
        SortedMergeJoinTest.assertThatItWorksOneWay(listB, listA, indexOrder);
    }

    private static void assertThatItWorksOneWay(List<EntityWithPropertyValues> listA, List<EntityWithPropertyValues> listB, IndexOrder indexOrder) {
        SortedMergeJoin sortedMergeJoin = new SortedMergeJoin();
        sortedMergeJoin.initialize(indexOrder);
        Comparator comparator = indexOrder == IndexOrder.ASCENDING ? (a, b) -> ValueTuple.COMPARATOR.compare(ValueTuple.of((Value[])a.getValues()), ValueTuple.of((Value[])b.getValues())) : (a, b) -> ValueTuple.COMPARATOR.compare(ValueTuple.of((Value[])b.getValues()), ValueTuple.of((Value[])a.getValues()));
        listA.sort(comparator);
        listB.sort(comparator);
        List<EntityWithPropertyValues> result = SortedMergeJoinTest.process(sortedMergeJoin, listA.iterator(), listB.iterator());
        ArrayList<EntityWithPropertyValues> expected = new ArrayList<EntityWithPropertyValues>();
        expected.addAll(listA);
        expected.addAll(listB);
        expected.sort(comparator);
        Assertions.assertThat(result).isEqualTo(expected);
    }

    private static List<EntityWithPropertyValues> process(SortedMergeJoin sortedMergeJoin, Iterator<EntityWithPropertyValues> iteratorA, Iterator<EntityWithPropertyValues> iteratorB) {
        Collector collector = new Collector();
        do {
            if (iteratorA.hasNext() && sortedMergeJoin.needsA()) {
                EntityWithPropertyValues a = iteratorA.next();
                sortedMergeJoin.setA(a.getEntityId(), a.getValues());
            }
            if (!iteratorB.hasNext() || !sortedMergeJoin.needsB()) continue;
            EntityWithPropertyValues b = iteratorB.next();
            sortedMergeJoin.setB(b.getEntityId(), b.getValues());
        } while (sortedMergeJoin.next((SortedMergeJoin.Sink)collector));
        return collector.result;
    }

    private static EntityWithPropertyValues node(long id, Object ... values) {
        return new EntityWithPropertyValues(id, (Value[])Stream.of(values).map(Values::of).toArray(Value[]::new));
    }

    static class Collector
    implements SortedMergeJoin.Sink {
        final List<EntityWithPropertyValues> result = new ArrayList<EntityWithPropertyValues>();

        Collector() {
        }

        public void acceptSortedMergeJoin(long nodeId, Value[] values) {
            this.result.add(new EntityWithPropertyValues(nodeId, values));
        }
    }
}

