/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.test.Race;

class DatabaseConfigTest {
    DatabaseConfigTest() {
    }

    @Test
    void shouldHandleRegisterDynamicUpdateListenersConcurrently() throws Throwable {
        NamedDatabaseId namedDatabaseId = DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID());
        DatabaseConfig dbConfig = new DatabaseConfig(Collections.emptyMap(), Config.defaults(), namedDatabaseId);
        Setting setting = GraphDatabaseSettings.transaction_tracing_level;
        int threads = 100;
        Listener[] listeners = new Listener[threads];
        for (int i = 0; i < threads; ++i) {
            listeners[i] = new Listener();
        }
        Race race = new Race();
        int i = 0;
        while (i < threads) {
            int slot = i++;
            race.addContestant(() -> dbConfig.addListener(setting, (SettingChangeListener)listeners[slot]), 1);
        }
        race.go();
        dbConfig.setDynamic(setting, (Object)GraphDatabaseSettings.TransactionTracingLevel.DISABLED, this.getClass().getSimpleName());
        for (i = 0; i < threads; ++i) {
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listeners[i].callCount);
        }
    }

    @Test
    void shouldBeAbleToBuildConfigFromDatabaseConfig() {
        Config globalConfig = Config.defaults((Setting)GraphDatabaseSettings.default_database, (Object)"foo");
        DatabaseConfig dbConfig = new DatabaseConfig(Map.of(), globalConfig, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID()));
        Config newConfig = Config.newBuilder().fromConfig((Config)dbConfig).build();
        Assertions.assertThat((String)((String)newConfig.get(GraphDatabaseSettings.default_database))).isEqualTo("foo");
    }

    @Test
    void shouldUnregisterDatabaseConfigListenersOnShutdown() {
        Config globalConfig = (Config)Mockito.mock(Config.class);
        LifeSupport life = new LifeSupport();
        DatabaseConfig databaseConfig = (DatabaseConfig)life.add((Lifecycle)new DatabaseConfig(Map.of(), globalConfig, DatabaseIdFactory.from((String)"neo4j", (UUID)UUID.randomUUID())));
        life.init();
        SettingChangeListener listener = (SettingChangeListener)Mockito.mock(SettingChangeListener.class);
        databaseConfig.addListener(GraphDatabaseSettings.read_only_database_default, listener);
        ((Config)Mockito.verify((Object)globalConfig)).addListener(GraphDatabaseSettings.read_only_database_default, listener);
        life.shutdown();
        ((Config)Mockito.verify((Object)globalConfig)).removeListener(GraphDatabaseSettings.read_only_database_default, listener);
    }

    private static class Listener
    implements SettingChangeListener<GraphDatabaseSettings.TransactionTracingLevel> {
        private int callCount;

        private Listener() {
        }

        public void accept(GraphDatabaseSettings.TransactionTracingLevel from, GraphDatabaseSettings.TransactionTracingLevel to) {
            ++this.callCount;
        }
    }
}

