/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.index;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.api.schema.SchemaTestUtil;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;

class SchemaIndexDescriptorFactoryTest {
    private static final int LABEL_ID = 0;

    SchemaIndexDescriptorFactoryTest() {
    }

    @Test
    void shouldCreateIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)desc.isUnique());
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateUniqueIndexDescriptors() {
        IndexDescriptor desc = TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)desc.isUnique());
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateIndexDescriptorsFromSchema() {
        IndexDescriptor desc = TestIndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)desc.isUnique());
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
        desc = TestIndexDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)desc.isUnique());
        Assertions.assertThat((Object)desc.schema()).isEqualTo((Object)SchemaDescriptors.forLabel((int)0, (int[])new int[]{1}));
    }

    @Test
    void shouldCreateEqualDescriptors() {
        IndexDescriptor desc1 = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        IndexDescriptor desc2 = TestIndexDescriptorFactory.forLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1.schema(), desc2.schema());
        SchemaTestUtil.assertEquality(desc1.isUnique(), desc2.isUnique());
        desc1 = TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        desc2 = TestIndexDescriptorFactory.uniqueForLabel((int)0, (int[])new int[]{1});
        SchemaTestUtil.assertEquality(desc1.schema(), desc2.schema());
        SchemaTestUtil.assertEquality(desc1.isUnique(), desc2.isUnique());
    }

    @Test
    void shouldGiveNiceUserDescriptions() {
        IndexDescriptor forLabel = TestIndexDescriptorFactory.forLabel((int)1, (int[])new int[]{2});
        long forLabelId = forLabel.getId();
        IndexDescriptor uniqueForLabel = TestIndexDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{4});
        String providerName = forLabel.getIndexProvider().name();
        long uniqueForLabelId = uniqueForLabel.getId();
        Assertions.assertThat((String)forLabel.userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("Index( id=" + forLabelId + ", name='index_" + forLabelId + "', type='GENERAL BTREE', schema=(:Label1 {property2}), indexProvider='" + providerName + "' )");
        Assertions.assertThat((String)uniqueForLabel.userDescription(SchemaTestUtil.SIMPLE_NAME_LOOKUP)).isEqualTo("Index( id=" + uniqueForLabelId + ", name='index_" + uniqueForLabelId + "', type='UNIQUE BTREE', schema=(:Label2 {property4}), indexProvider='" + providerName + "' )");
    }
}

