/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.LongPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.kernel.impl.api.index.IndexMap;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.TestIndexProviderDescriptor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.RecoveryCondition;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

class IndexSamplingControllerTest {
    private final IndexSamplingConfig samplingConfig = (IndexSamplingConfig)Mockito.mock(IndexSamplingConfig.class);
    private final IndexSamplingJobFactory jobFactory = (IndexSamplingJobFactory)Mockito.mock(IndexSamplingJobFactory.class);
    private final LongPredicate samplingUpdatePredicate = id -> true;
    private final IndexSamplingJobTracker tracker = (IndexSamplingJobTracker)Mockito.mock(IndexSamplingJobTracker.class, (Answer)Mockito.RETURNS_MOCKS);
    private final JobScheduler scheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final IndexMapSnapshotProvider snapshotProvider = (IndexMapSnapshotProvider)Mockito.mock(IndexMapSnapshotProvider.class);
    private final IndexMap indexMap = new IndexMap();
    private final long indexId = 2L;
    private final long anotherIndexId = 3L;
    private final IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexProxy anotherIndexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexDescriptor descriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)3, (int[])new int[]{4}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index_2").materialise(2L);
    private final IndexDescriptor anotherDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)5, (int[])new int[]{6}), (IndexProviderDescriptor)TestIndexProviderDescriptor.PROVIDER_DESCRIPTOR).withName("index_3").materialise(3L);
    private final IndexSamplingJob job = (IndexSamplingJob)Mockito.mock(IndexSamplingJob.class);
    private final IndexSamplingJob anotherJob = (IndexSamplingJob)Mockito.mock(IndexSamplingJob.class);
    private AssertableLogProvider logProvider;

    IndexSamplingControllerTest() {
    }

    @BeforeEach
    void setupLogProvider() {
        Mockito.when((Object)this.samplingConfig.backgroundSampling()).thenReturn((Object)true);
        Mockito.when((Object)this.indexProxy.getDescriptor()).thenReturn((Object)this.descriptor);
        Mockito.when((Object)this.anotherIndexProxy.getDescriptor()).thenReturn((Object)this.anotherDescriptor);
        Mockito.when((Object)this.snapshotProvider.indexMapSnapshot()).thenReturn((Object)this.indexMap);
        Mockito.when((Object)this.jobFactory.create(2L, this.indexProxy)).thenReturn((Object)this.job);
        Mockito.when((Object)this.jobFactory.create(3L, this.anotherIndexProxy)).thenReturn((Object)this.anotherJob);
        this.indexMap.putIndexProxy(this.indexProxy);
        this.logProvider = new AssertableLogProvider();
    }

    @Test
    void shouldStartASamplingJobForEachIndexInTheDB() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.sampleIndexes(IndexSamplingMode.backgroundRebuildUpdated());
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    void shouldNotStartAJobIfTheIndexIsNotOnline() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        controller.sampleIndexes(IndexSamplingMode.backgroundRebuildUpdated());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    void shouldSampleAllTheIndexes() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        controller.sampleIndexes(IndexSamplingMode.backgroundRebuildUpdated());
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(3L, this.anotherIndexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.anotherJob);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    void shouldSampleAllTheOnlineIndexes() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.POPULATING);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        controller.sampleIndexes(IndexSamplingMode.backgroundRebuildUpdated());
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    void shouldForegroundSampleAllTheIndexes() throws InterruptedException, ExecutionException, TimeoutException {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        JobHandle anotherJobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        Mockito.when((Object)this.tracker.scheduleSamplingJob(this.job)).thenReturn((Object)jobHandle);
        Mockito.when((Object)this.tracker.scheduleSamplingJob(this.anotherJob)).thenReturn((Object)anotherJobHandle);
        IndexSamplingMode mode = IndexSamplingMode.foregroundRebuildUpdated((long)60L);
        controller.sampleIndexes(mode);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(3L, this.anotherIndexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.anotherJob);
        ((JobHandle)Mockito.verify((Object)jobHandle)).waitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        ((JobHandle)Mockito.verify((Object)anotherJobHandle)).waitTermination(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker, jobHandle, anotherJobHandle});
    }

    @Test
    void shouldThrowIfJobTimesOut() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        JobHandle<Object> jobHandle = new JobHandle<Object>(){

            public void cancel() {
            }

            public void waitTermination() {
                Assertions.fail((String)"We should never use this wait for foreground sampling.");
            }

            public void waitTermination(long timeout, TimeUnit unit) throws TimeoutException {
                throw new TimeoutException("I'm sorry, so slow.");
            }

            public Object get() {
                Assertions.fail((String)"We should never use this wait for foreground sampling.");
                return null;
            }
        };
        Mockito.when((Object)this.tracker.scheduleSamplingJob(this.job)).thenReturn((Object)jobHandle);
        IndexSamplingMode mode = IndexSamplingMode.foregroundRebuildUpdated((long)1L);
        RuntimeException e = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> controller.sampleIndexes(mode));
        LogAssertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Could not finish index sampling within the given time limit, 1 milliseconds."});
    }

    @Test
    void shouldRecoverOnlineIndex() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.recoverIndexSamples();
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    void shouldNotRecoverOfflineIndex() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.FAILED);
        controller.recoverIndexSamples();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    void shouldNotRecoverOnlineIndexIfNotNeeded() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.recoverIndexSamples();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.job, this.tracker});
    }

    @Test
    void shouldSampleIndex() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(false), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        controller.sampleIndex(2L, IndexSamplingMode.backgroundRebuildUpdated());
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory)).create(2L, this.indexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((IndexSamplingJobFactory)Mockito.verify((Object)this.jobFactory, (VerificationMode)Mockito.never())).create(3L, this.anotherIndexProxy);
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker, (VerificationMode)Mockito.never())).scheduleSamplingJob(this.anotherJob);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jobFactory, this.tracker});
    }

    @Test
    void shouldLogRecoveryIndexSamples() {
        RecoveryCondition predicate = descriptor -> descriptor.equals((Object)this.indexProxy.getDescriptor());
        IndexSamplingController controller = this.newSamplingController(predicate, (LogProvider)this.logProvider, Config.defaults((Setting)GraphDatabaseInternalSettings.log_recover_index_samples, (Object)true));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.anotherIndexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        this.indexMap.putIndexProxy(this.anotherIndexProxy);
        controller.recoverIndexSamples();
        LogAssertions.assertThat((AssertableLogProvider)this.logProvider).containsMessages(new String[]{"Index requires sampling, id=2, name=index_2.", "Index does not require sampling, id=3, name=index_3."});
    }

    @Test
    void triggerAsyncSamplesByDefault() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.jobFactory.create(2L, this.indexProxy)).thenReturn((Object)this.job);
        Mockito.when((Object)this.tracker.scheduleSamplingJob((IndexSamplingJob)ArgumentMatchers.any(IndexSamplingJob.class))).thenReturn((Object)((JobHandle)Mockito.mock(JobHandle.class)));
        controller.recoverIndexSamples();
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
    }

    @Test
    void shouldNotTriggerAsyncSamplesIfNotToggled() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider, Config.defaults((Setting)GraphDatabaseInternalSettings.async_recover_index_samples, (Object)false));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        controller.recoverIndexSamples();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.tracker});
    }

    @Test
    void waitForAsyncIndexSamples() throws ExecutionException, InterruptedException {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.jobFactory.create(2L, this.indexProxy)).thenReturn((Object)this.job);
        JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        Mockito.when((Object)this.tracker.scheduleSamplingJob((IndexSamplingJob)ArgumentMatchers.any(IndexSamplingJob.class))).thenReturn((Object)jobHandle);
        controller.recoverIndexSamples();
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        ((JobHandle)Mockito.verify((Object)jobHandle)).waitTermination();
    }

    @Test
    void shouldNotWaitForAsyncIndexSamplesIfConfigured() {
        IndexSamplingController controller = this.newSamplingController(IndexSamplingControllerTest.always(true), (LogProvider)this.logProvider, Config.defaults((Setting)GraphDatabaseInternalSettings.async_recover_index_samples_wait, (Object)false));
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        Mockito.when((Object)this.jobFactory.create(2L, this.indexProxy)).thenReturn((Object)this.job);
        JobHandle jobHandle = (JobHandle)Mockito.mock(JobHandle.class);
        Mockito.when((Object)this.tracker.scheduleSamplingJob((IndexSamplingJob)ArgumentMatchers.any(IndexSamplingJob.class))).thenReturn((Object)jobHandle);
        controller.recoverIndexSamples();
        ((IndexSamplingJobTracker)Mockito.verify((Object)this.tracker)).scheduleSamplingJob(this.job);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{jobHandle});
    }

    private static RecoveryCondition always(boolean ans) {
        return new Always(ans);
    }

    private IndexSamplingController newSamplingController(RecoveryCondition recoveryPredicate, LogProvider logProvider) {
        return this.newSamplingController(recoveryPredicate, logProvider, Config.defaults());
    }

    private IndexSamplingController newSamplingController(RecoveryCondition recoveryPredicate, LogProvider logProvider, Config config) {
        return new IndexSamplingController(this.samplingConfig, this.jobFactory, this.samplingUpdatePredicate, this.tracker, this.snapshotProvider, this.scheduler, recoveryPredicate, logProvider, config, "Test DB");
    }

    private static class Always
    implements RecoveryCondition {
        private final boolean answer;

        Always(boolean answer) {
            this.answer = answer;
        }

        public boolean test(IndexDescriptor descriptor) {
            return this.answer;
        }
    }
}

