/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipDataAccessor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.core.RelationshipEntity;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.storageengine.api.PropertySelection;

class RelationshipEntityTest {
    RelationshipEntityTest() {
    }

    @Test
    void shouldUseCursorForReadingPropertiesIfPresentAndCorrectlyLocated() {
        InternalTransaction internalTransaction = this.mockedInternalTransaction();
        long id = 1L;
        RelationshipTraversalCursor relationshipTraversalCursor = (RelationshipTraversalCursor)Mockito.mock(RelationshipTraversalCursor.class);
        Mockito.when((Object)relationshipTraversalCursor.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)relationshipTraversalCursor.relationshipReference()).thenReturn((Object)id);
        RelationshipEntity relationship = new RelationshipEntity(internalTransaction, id, 2L, 3, 4L, (RelationshipDataAccessor)relationshipTraversalCursor);
        relationship.getAllProperties((PropertyCursor)Mockito.mock(PropertyCursor.class));
        ((RelationshipTraversalCursor)Mockito.verify((Object)relationshipTraversalCursor)).properties((PropertyCursor)ArgumentMatchers.any(), (PropertySelection)ArgumentMatchers.any());
        ((KernelTransaction)Mockito.verify((Object)internalTransaction.kernelTransaction(), (VerificationMode)Mockito.never())).ambientRelationshipCursor();
    }

    @Test
    void shouldNotUseCursorForReadingPropertiesIfPresentButNotCorrectlyLocated() {
        InternalTransaction internalTransaction = this.mockedInternalTransaction();
        long id = 1L;
        RelationshipTraversalCursor relationshipTraversalCursor = (RelationshipTraversalCursor)Mockito.mock(RelationshipTraversalCursor.class);
        Mockito.when((Object)relationshipTraversalCursor.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)relationshipTraversalCursor.relationshipReference()).thenReturn((Object)(id + 1L));
        RelationshipEntity relationship = new RelationshipEntity(internalTransaction, id, 2L, 3, 4L, (RelationshipDataAccessor)relationshipTraversalCursor);
        relationship.getAllProperties((PropertyCursor)Mockito.mock(PropertyCursor.class));
        ((RelationshipTraversalCursor)Mockito.verify((Object)relationshipTraversalCursor, (VerificationMode)Mockito.never())).properties((PropertyCursor)ArgumentMatchers.any());
        ((KernelTransaction)Mockito.verify((Object)internalTransaction.kernelTransaction())).ambientRelationshipCursor();
    }

    @Test
    void shouldNotUseCursorForReadingPropertiesIfClosed() {
        InternalTransaction internalTransaction = this.mockedInternalTransaction();
        long id = 1L;
        RelationshipTraversalCursor relationshipTraversalCursor = (RelationshipTraversalCursor)Mockito.mock(RelationshipTraversalCursor.class);
        Mockito.when((Object)relationshipTraversalCursor.isClosed()).thenReturn((Object)true);
        Mockito.when((Object)relationshipTraversalCursor.relationshipReference()).thenReturn((Object)id);
        RelationshipEntity relationship = new RelationshipEntity(internalTransaction, id, 2L, 3, 4L, (RelationshipDataAccessor)relationshipTraversalCursor);
        relationship.getAllProperties((PropertyCursor)Mockito.mock(PropertyCursor.class));
        ((RelationshipTraversalCursor)Mockito.verify((Object)relationshipTraversalCursor, (VerificationMode)Mockito.never())).properties((PropertyCursor)ArgumentMatchers.any());
        ((KernelTransaction)Mockito.verify((Object)internalTransaction.kernelTransaction())).ambientRelationshipCursor();
    }

    @Test
    void shouldNotUseCursorForReadingPropertiesIfNotPresent() {
        InternalTransaction internalTransaction = this.mockedInternalTransaction();
        long id = 1L;
        RelationshipEntity relationship = new RelationshipEntity(internalTransaction, id, 2L, 3, 4L);
        relationship.getAllProperties((PropertyCursor)Mockito.mock(PropertyCursor.class));
        ((KernelTransaction)Mockito.verify((Object)internalTransaction.kernelTransaction())).ambientRelationshipCursor();
    }

    private InternalTransaction mockedInternalTransaction() {
        InternalTransaction internalTransaction = (InternalTransaction)Mockito.mock(InternalTransaction.class);
        KernelTransaction kernelTransaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
        Read dataRead = (Read)Mockito.mock(Read.class);
        RelationshipScanCursor ambientRelationshipScanCursor = (RelationshipScanCursor)Mockito.mock(RelationshipScanCursor.class);
        Mockito.when((Object)ambientRelationshipScanCursor.next()).thenReturn((Object)true);
        Mockito.when((Object)kernelTransaction.dataRead()).thenReturn((Object)dataRead);
        Mockito.when((Object)kernelTransaction.tokenRead()).thenReturn((Object)((TokenRead)Mockito.mock(TokenRead.class)));
        Mockito.when((Object)kernelTransaction.ambientRelationshipCursor()).thenReturn((Object)ambientRelationshipScanCursor);
        Mockito.when((Object)internalTransaction.kernelTransaction()).thenReturn((Object)kernelTransaction);
        return internalTransaction;
    }
}

