/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulatorTest;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexEntryTestUtil;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.test.Race;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

abstract class GenericBlockBasedIndexPopulatorTest<KEY extends GenericKey<KEY>>
extends BlockBasedIndexPopulatorTest<KEY> {
    GenericBlockBasedIndexPopulatorTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ValueSource(booleans={true, false})
    @ParameterizedTest
    void shouldAcceptUpdatedMaxSizeValue(boolean updateBeforeScanCompleted) throws Throwable {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap();
            Layout layout = this.layout();
            TextValue value = IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(layout, size);
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value});
            Race.ThrowingRunnable updateAction = () -> GenericBlockBasedIndexPopulatorTest.lambda$shouldAcceptUpdatedMaxSizeValue$0(populator, (IndexEntryUpdate)update);
            if (updateBeforeScanCompleted) {
                updateAction.run();
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            } else {
                populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
                updateAction.run();
            }
            try (Seeker seek = this.seek(populator.tree, layout);){
                Assertions.assertTrue((boolean)seek.next());
                Assertions.assertEquals((Object)value, (Object)((GenericKey)seek.key()).asValues()[0]);
                Assertions.assertFalse((boolean)seek.next());
            }
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAcceptBatchAddedMaxSizeValue() throws IndexEntryConflictException, IOException {
        ByteBufferFactory bufferFactory = new ByteBufferFactory(UnsafeDirectByteBufferAllocator::new, SUFFICIENTLY_LARGE_BUFFER_SIZE);
        BlockBasedIndexPopulator populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            int size = populator.tree.keyValueSizeCap();
            Layout layout = this.layout();
            TextValue value = IndexEntryTestUtil.generateStringValueResultingInIndexEntrySize(layout, size);
            List<ValueIndexEntryUpdate> data = Collections.singletonList(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.INDEX_DESCRIPTOR, (Value[])new Value[]{value}));
            populator.add(data, CursorContext.NULL);
            populator.scanCompleted(PhaseTracker.nullInstance, this.populationWorkScheduler, CursorContext.NULL);
            try (Seeker seek = this.seek(populator.tree, layout);){
                Assertions.assertTrue((boolean)seek.next());
                Assertions.assertEquals((Object)value, (Object)((GenericKey)seek.key()).asValues()[0]);
                Assertions.assertFalse((boolean)seek.next());
            }
        }
        finally {
            populator.close(true, CursorContext.NULL);
        }
    }

    @Override
    protected Value supportedValue(int i) {
        return Values.stringValue((String)("Value" + i));
    }

    private static /* synthetic */ void lambda$shouldAcceptUpdatedMaxSizeValue$0(BlockBasedIndexPopulator populator, IndexEntryUpdate update) throws Throwable {
        try (IndexUpdater updater = populator.newPopulatingUpdater(CursorContext.NULL);){
            updater.process(update);
        }
    }
}

