/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;
import org.neo4j.values.storable.Values;

abstract class GenericNativeIndexAccessorTests<KEY extends NativeIndexKey<KEY>>
extends NativeIndexAccessorTests<KEY> {
    GenericNativeIndexAccessorTests() {
    }

    abstract IndexCapability indexCapability();

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndExclusiveEnd() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), true, GenericNativeIndexAccessorTests.valueOf(updates[updates.length - 1]), false));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(GenericNativeIndexAccessorTests.extractEntityIds(Arrays.copyOf(updates, updates.length - 1), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithInclusiveStartAndInclusiveEnd() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), true, GenericNativeIndexAccessorTests.valueOf(updates[updates.length - 1]), true));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(GenericNativeIndexAccessorTests.extractEntityIds(updates, Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndExclusiveEnd() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), false, GenericNativeIndexAccessorTests.valueOf(updates[updates.length - 1]), false));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(GenericNativeIndexAccessorTests.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length - 1), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnMatchingEntriesForRangePredicateWithExclusiveStartAndInclusiveEnd() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), false, GenericNativeIndexAccessorTests.valueOf(updates[updates.length - 1]), true));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(GenericNativeIndexAccessorTests.extractEntityIds(Arrays.copyOfRange(updates, 1, updates.length), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnNoEntriesForRangePredicateOutsideAnyMatch() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        ValueCreatorUtil.sort(updates);
        this.processAll(updates[0], updates[1], updates[updates.length - 1], updates[updates.length - 2]);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[2]), true, GenericNativeIndexAccessorTests.valueOf(updates[updates.length - 3]), true));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(PrimitiveLongCollections.EMPTY_LONG_ARRAY, (LongIterator)result);
        }
    }

    @Test
    void mustHandleNestedQueries() throws Exception {
        ArrayList<Long> outerResult;
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        PropertyIndexQuery outerQuery = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[2]), true, GenericNativeIndexAccessorTests.valueOf(updates[3]), true);
        PropertyIndexQuery innerQuery = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), true, GenericNativeIndexAccessorTests.valueOf(updates[1]), true);
        long[] expectedOuter = new long[]{GenericNativeIndexAccessorTests.entityIdOf(updates[2]), GenericNativeIndexAccessorTests.entityIdOf(updates[3])};
        long[] expectedInner = new long[]{GenericNativeIndexAccessorTests.entityIdOf(updates[0]), GenericNativeIndexAccessorTests.entityIdOf(updates[1])};
        try (NodeValueIterator outerIter = GenericNativeIndexAccessorTests.query(reader, outerQuery);){
            outerResult = new ArrayList<Long>();
            while (outerIter.hasNext()) {
                outerResult.add(outerIter.next());
                NodeValueIterator innerIter = GenericNativeIndexAccessorTests.query(reader, innerQuery);
                try {
                    GenericNativeIndexAccessorTests.assertEntityIdHits(expectedInner, (LongIterator)innerIter);
                }
                finally {
                    if (innerIter == null) continue;
                    innerIter.close();
                }
            }
        }
        GenericNativeIndexAccessorTests.assertEntityIdHits(expectedOuter, outerResult);
    }

    @Test
    void mustHandleMultipleNestedQueries() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        PropertyIndexQuery query1 = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[4]), true, GenericNativeIndexAccessorTests.valueOf(updates[5]), true);
        PropertyIndexQuery query2 = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[2]), true, GenericNativeIndexAccessorTests.valueOf(updates[3]), true);
        PropertyIndexQuery query3 = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), true, GenericNativeIndexAccessorTests.valueOf(updates[1]), true);
        long[] expected1 = new long[]{GenericNativeIndexAccessorTests.entityIdOf(updates[4]), GenericNativeIndexAccessorTests.entityIdOf(updates[5])};
        long[] expected2 = new long[]{GenericNativeIndexAccessorTests.entityIdOf(updates[2]), GenericNativeIndexAccessorTests.entityIdOf(updates[3])};
        long[] expected3 = new long[]{GenericNativeIndexAccessorTests.entityIdOf(updates[0]), GenericNativeIndexAccessorTests.entityIdOf(updates[1])};
        ArrayList<Long> result1 = new ArrayList<Long>();
        try (NodeValueIterator iter1 = GenericNativeIndexAccessorTests.query(reader, query1);){
            while (iter1.hasNext()) {
                result1.add(iter1.next());
                ArrayList<Long> result2 = new ArrayList<Long>();
                try (NodeValueIterator iter2 = GenericNativeIndexAccessorTests.query(reader, query2);){
                    while (iter2.hasNext()) {
                        result2.add(iter2.next());
                        ArrayList<Long> result3 = new ArrayList<Long>();
                        try (NodeValueIterator iter3 = GenericNativeIndexAccessorTests.query(reader, query3);){
                            while (iter3.hasNext()) {
                                result3.add(iter3.next());
                            }
                        }
                        GenericNativeIndexAccessorTests.assertEntityIdHits(expected3, result3);
                    }
                }
                GenericNativeIndexAccessorTests.assertEntityIdHits(expected2, result2);
            }
        }
        GenericNativeIndexAccessorTests.assertEntityIdHits(expected1, result1);
    }

    @Test
    void shouldNotSeeFilteredEntries() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(this.supportedTypesExcludingNonOrderable());
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator iter = new NodeValueIterator();){
            PropertyIndexQuery.ExactPredicate filter = PropertyIndexQuery.exact((int)0, (Object)GenericNativeIndexAccessorTests.valueOf(updates[1]));
            PropertyIndexQuery rangeQuery = ValueCreatorUtil.rangeQuery(GenericNativeIndexAccessorTests.valueOf(updates[0]), true, GenericNativeIndexAccessorTests.valueOf(updates[2]), true);
            IndexProgressor.EntityValueClient filterClient = GenericNativeIndexAccessorTests.filterClient(iter, (PropertyIndexQuery)filter);
            reader.query(filterClient, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.unconstrained(), new PropertyIndexQuery[]{rangeQuery});
            Assertions.assertTrue((boolean)iter.hasNext());
            Assertions.assertEquals((long)GenericNativeIndexAccessorTests.entityIdOf(updates[1]), (long)iter.next());
            Assertions.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    void respectIndexOrder() throws Exception {
        int nUpdates = 10000;
        ValueType[] types = this.supportedTypesExcludingNonOrderable();
        Iterator<ValueIndexEntryUpdate<IndexDescriptor>> randomUpdateGenerator = this.valueCreatorUtil.randomUpdateGenerator(this.random, types);
        ValueIndexEntryUpdate[] someUpdates = new ValueIndexEntryUpdate[nUpdates];
        for (int i = 0; i < nUpdates; ++i) {
            someUpdates[i] = randomUpdateGenerator.next();
        }
        this.processAll(someUpdates);
        Object[] allValues = ValueCreatorUtil.extractValuesFromUpdates(someUpdates);
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            ValueGroup valueGroup = ((Value)this.random.among(allValues)).valueGroup();
            PropertyIndexQuery.RangePredicate supportedQuery = PropertyIndexQuery.range((int)0, (ValueGroup)valueGroup);
            IndexOrderCapability supportedOrders = this.indexCapability().orderCapability(new ValueCategory[]{valueGroup.category()});
            if (supportedOrders.supportsAsc()) {
                GenericNativeIndexAccessorTests.expectIndexOrder((Value[])allValues, valueGroup, reader, IndexOrder.ASCENDING, supportedQuery);
            }
            if (supportedOrders.supportsDesc()) {
                GenericNativeIndexAccessorTests.expectIndexOrder((Value[])allValues, valueGroup, reader, IndexOrder.DESCENDING, supportedQuery);
            }
        }
    }

    @Test
    void shouldReturnAllEntriesForExistsPredicate() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleType();
        this.processAll(updates);
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, (PropertyIndexQuery)PropertyIndexQuery.exists((int)0));){
            GenericNativeIndexAccessorTests.assertEntityIdHits(GenericNativeIndexAccessorTests.extractEntityIds(updates, Predicates.alwaysTrue()), (LongIterator)result);
        }
    }

    @Test
    void shouldReturnNoEntriesForExistsPredicateForEmptyIndex() throws Exception {
        ValueIndexReader reader = this.accessor.newValueReader();
        try (NodeValueIterator result = GenericNativeIndexAccessorTests.query(reader, (PropertyIndexQuery)PropertyIndexQuery.exists((int)0));){
            long[] actual = PrimitiveLongCollections.asArray((LongIterator)result);
            Assertions.assertEquals((int)0, (int)actual.length);
        }
    }

    private ValueType[] supportedTypesExcludingNonOrderable() {
        return RandomValues.excluding((ValueType[])this.valueCreatorUtil.supportedTypes(), t -> t.valueGroup == ValueGroup.GEOMETRY || t.valueGroup == ValueGroup.GEOMETRY_ARRAY || t == ValueType.STRING || t == ValueType.STRING_ARRAY);
    }

    private static long entityIdOf(ValueIndexEntryUpdate<IndexDescriptor> update) {
        return update.getEntityId();
    }

    private static void expectIndexOrder(Value[] allValues, ValueGroup valueGroup, ValueIndexReader reader, IndexOrder supportedOrder, PropertyIndexQuery.RangePredicate<?> supportedQuery) throws IndexNotApplicableKernelException {
        Value[] expectedValues = (Value[])Arrays.stream(allValues).filter(v -> v.valueGroup() == valueGroup).toArray(Value[]::new);
        if (supportedOrder == IndexOrder.ASCENDING) {
            Arrays.sort(expectedValues, Values.COMPARATOR);
        } else if (supportedOrder == IndexOrder.DESCENDING) {
            Arrays.sort(expectedValues, Values.COMPARATOR.reversed());
        }
        SimpleEntityValueClient client = new SimpleEntityValueClient();
        reader.query((IndexProgressor.EntityValueClient)client, QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.READ, IndexQueryConstraints.constrained((IndexOrder)supportedOrder, (boolean)true), new PropertyIndexQuery[]{supportedQuery});
        int i = 0;
        while (client.next()) {
            Assertions.assertEquals((Object)expectedValues[i++], (Object)client.values[0], (String)"values in order");
        }
        Assertions.assertEquals((int)i, (int)expectedValues.length, (String)"found all values");
    }

    protected static Value valueOf(ValueIndexEntryUpdate<IndexDescriptor> update) {
        return update.values()[0];
    }

    private static IndexProgressor.EntityValueClient filterClient(final NodeValueIterator iter, final PropertyIndexQuery filter) {
        return new IndexProgressor.EntityValueClient(){

            public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, AccessMode accessMode, boolean indexIncludesTransactionState, IndexQueryConstraints constraints, PropertyIndexQuery ... query) {
                iter.initialize(descriptor, progressor, accessMode, indexIncludesTransactionState, constraints, query);
            }

            public boolean acceptEntity(long reference, float score, Value ... values) {
                if (values.length > 1) {
                    return false;
                }
                return filter.acceptsValue(values[0]) && iter.acceptEntity(reference, score, values);
            }

            public boolean needsValues() {
                return true;
            }
        };
    }

    private static void assertEntityIdHits(long[] expected, Collection<Long> result) {
        long[] actual = new long[result.size()];
        int index = 0;
        for (Long aLong : result) {
            actual[index++] = aLong;
        }
        GenericNativeIndexAccessorTests.assertSameContent(expected, actual);
    }
}

