/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.function.Predicates;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessorTests;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.schema.SimpleEntityValueClient;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ValueType;

class NativeIndexAccessorTest
extends GenericNativeIndexAccessorTests<BtreeKey> {
    private static final IndexSpecificSpaceFillingCurveSettings SPACE_FILLING_CURVE_SETTINGS = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    private static final StandardConfiguration CONFIGURATION = new StandardConfiguration();
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)42, (int[])new int[]{666})).withIndexType(IndexType.BTREE).withIndexProvider(GenericNativeIndexProvider.DESCRIPTOR).withName("index").materialise(0L);
    private static final ValueType[] SUPPORTED_TYPES = ValueType.values();
    private static final GenericLayout LAYOUT = new GenericLayout(1, SPACE_FILLING_CURVE_SETTINGS);
    private static final IndexCapability INDEX_CAPABILITY = GenericNativeIndexProvider.CAPABILITY;

    NativeIndexAccessorTest() {
    }

    NativeIndexAccessor<BtreeKey> createAccessor(PageCache pageCache) {
        RecoveryCleanupWorkCollector cleanup = RecoveryCleanupWorkCollector.immediate();
        DatabaseIndexContext context = DatabaseIndexContext.builder((PageCache)pageCache, (FileSystemAbstraction)this.fs, (String)"neo4j").withReadOnlyChecker(DatabaseReadOnlyChecker.writable()).build();
        return new GenericNativeIndexAccessor(context, this.indexFiles, (IndexLayout)this.layout, cleanup, INDEX_DESCRIPTOR, SPACE_FILLING_CURVE_SETTINGS, (SpaceFillingCurveConfiguration)CONFIGURATION, this.tokenNameLookup);
    }

    @Override
    IndexCapability indexCapability() {
        return INDEX_CAPABILITY;
    }

    @Override
    boolean supportsGeometryRangeQueries() {
        return true;
    }

    @Override
    ValueCreatorUtil<BtreeKey> createValueCreatorUtil() {
        return new ValueCreatorUtil<BtreeKey>(INDEX_DESCRIPTOR, SUPPORTED_TYPES, 0.1);
    }

    @Override
    IndexDescriptor indexDescriptor() {
        return INDEX_DESCRIPTOR;
    }

    @Override
    GenericLayout layout() {
        return LAYOUT;
    }

    @Test
    void throwForUnsupportedIndexOrder() {
        try (ValueIndexReader reader = this.accessor.newValueReader();){
            IndexOrder unsupportedOrder = IndexOrder.DESCENDING;
            PropertyIndexQuery.ExactPredicate unsupportedQuery = PropertyIndexQuery.exact((int)0, (Object)PointValue.MAX_VALUE);
            UnsupportedOperationException e = (UnsupportedOperationException)org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> reader.query((IndexProgressor.EntityValueClient)new SimpleEntityValueClient(), QueryContext.NULL_CONTEXT, (AccessMode)AccessMode.Static.ACCESS, IndexQueryConstraints.constrained((IndexOrder)unsupportedOrder, (boolean)false), new PropertyIndexQuery[]{unsupportedQuery}));
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"unsupported order"})).contains(new CharSequence[]{unsupportedOrder.toString()})).contains(new CharSequence[]{unsupportedQuery.toString()});
        }
    }

    @Test
    void shouldReturnMatchingEntriesForPointArrayRangePredicate() throws Exception {
        ValueIndexEntryUpdate<IndexDescriptor>[] updates = this.someUpdatesSingleTypeNoDuplicates(ValueType.CARTESIAN_POINT_ARRAY);
        this.processAll(updates);
        ValueCreatorUtil.sort(updates);
        int fromInclusive = 2;
        int toExclusive = updates.length - 1;
        try (ValueIndexReader reader = this.accessor.newValueReader();
             NodeValueIterator result = NativeIndexAccessorTest.query(reader, ValueCreatorUtil.rangeQuery(NativeIndexAccessorTest.valueOf(updates[2]), true, NativeIndexAccessorTest.valueOf(updates[toExclusive]), false));){
            NativeIndexAccessorTest.assertEntityIdHits(NativeIndexAccessorTest.extractEntityIds(Arrays.copyOfRange(updates, 2, toExclusive), Predicates.alwaysTrue()), (LongIterator)result);
        }
    }
}

