/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.BtreeKey;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.RangeBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.RangeKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

class NativeIndexPopulatorTestCases {
    private static final Config config = Config.defaults();
    static final IndexSpecificSpaceFillingCurveSettings spaceFillingCurveSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)config);
    private static final StandardConfiguration configuration = new StandardConfiguration();

    NativeIndexPopulatorTestCases() {
    }

    static PopulatorFactory<BtreeKey> genericBlockBasedPopulatorFactory() {
        return (nativeIndexContext, storeFile, layout, descriptor, tokenNameLookup) -> new GenericBlockBasedIndexPopulator(nativeIndexContext, storeFile, layout, descriptor, spaceFillingCurveSettings, (SpaceFillingCurveConfiguration)configuration, false, ByteBufferFactory.heapBufferFactory((int)10240), config, (MemoryTracker)EmptyMemoryTracker.INSTANCE, tokenNameLookup);
    }

    static PopulatorFactory<RangeKey> rangeBlockBasedPopulatorFactory() {
        return (nativeIndexContext, storeFile, layout, descriptor, tokenNameLookup) -> new RangeBlockBasedIndexPopulator(nativeIndexContext, storeFile, layout, descriptor, false, ByteBufferFactory.heapBufferFactory((int)10240), config, (MemoryTracker)EmptyMemoryTracker.INSTANCE, tokenNameLookup);
    }

    @FunctionalInterface
    public static interface PopulatorFactory<KEY extends NativeIndexKey<KEY>> {
        public NativeIndexPopulator<KEY> create(DatabaseIndexContext var1, IndexFiles var2, IndexLayout<KEY> var3, IndexDescriptor var4, TokenNameLookup var5) throws IOException;
    }
}

