/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.index.schema.WorkSyncedIndexPopulator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Race;

class WorkSyncedIndexPopulatorTest {
    WorkSyncedIndexPopulatorTest() {
    }

    @Test
    void callsToDelegatingPopulatorAddShouldNotBeConcurrent() throws Throwable {
        WorkSyncedIndexPopulator populator = new WorkSyncedIndexPopulator((IndexPopulator)new NotThreadSafePopulator());
        Race race = new Race();
        race.addContestants(10, Race.throwing(() -> populator.add(Collections.singleton((IndexEntryUpdate)Mockito.mock(IndexEntryUpdate.class)), CursorContext.NULL)));
        race.go();
    }

    static class NotThreadSafePopulator
    extends IndexPopulator.Adapter {
        private final AtomicBoolean flag = new AtomicBoolean();

        NotThreadSafePopulator() {
        }

        public void add(Collection<? extends IndexEntryUpdate<?>> updates, CursorContext cursorContext) {
            Assertions.assertTrue((boolean)this.flag.compareAndSet(false, true), (String)"Only one instance can flip flag at a time");
            Assertions.assertTrue((boolean)this.flag.compareAndSet(true, false), (String)"Only one instance can flip flag back at a time");
        }
    }
}

