/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.locking.LockingCompatibilityTestSuite;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.lock.AcquireLockTimeoutException;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.time.Clocks;

@ActorsExtension
@TestDirectoryExtension
public abstract class LockCompatibilityTestSupport {
    @Inject
    public Actor threadA;
    @Inject
    public Actor threadB;
    @Inject
    public Actor threadC;
    @Inject
    public TestDirectory testDir;
    protected final LockingCompatibilityTestSuite suite;
    protected Locks locks;
    protected Locks.Client clientA;
    protected Locks.Client clientB;
    protected Locks.Client clientC;
    private final Map<Locks.Client, Actor> clientToThreadMap = new HashMap<Locks.Client, Actor>();

    public LockCompatibilityTestSupport(LockingCompatibilityTestSuite suite) {
        this.suite = suite;
    }

    @BeforeEach
    public void before() {
        this.locks = this.suite.createLockManager(Config.defaults(), Clocks.nanoClock());
        this.clientA = this.locks.newClient();
        this.clientB = this.locks.newClient();
        this.clientC = this.locks.newClient();
        this.clientA.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 1L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientB.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 2L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientC.initialize((LeaseClient)LeaseService.NoLeaseClient.INSTANCE, 3L, (MemoryTracker)EmptyMemoryTracker.INSTANCE, Config.defaults());
        this.clientToThreadMap.put(this.clientA, this.threadA);
        this.clientToThreadMap.put(this.clientB, this.threadB);
        this.clientToThreadMap.put(this.clientC, this.threadC);
    }

    @AfterEach
    public void after() {
        this.clientA.close();
        this.clientB.close();
        this.clientC.close();
        this.locks.close();
        this.clientToThreadMap.clear();
    }

    protected LockCommand acquireExclusive(Locks.Client client, final LockTracer tracer, final ResourceType resourceType, final long key) {
        return new LockCommand(this.clientToThreadMap.get(client), client){

            @Override
            public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                client.acquireExclusive(tracer, resourceType, new long[]{key});
            }
        };
    }

    protected LockCommand acquireShared(Locks.Client client, final LockTracer tracer, final ResourceType resourceType, final long key) {
        return new LockCommand(this.clientToThreadMap.get(client), client){

            @Override
            public void doWork(Locks.Client client) throws AcquireLockTimeoutException {
                client.acquireShared(tracer, resourceType, new long[]{key});
            }
        };
    }

    protected LockCommand release(Locks.Client client, final ResourceType resourceType, final long key) {
        return new LockCommand(this.clientToThreadMap.get(client), client){

            @Override
            public void doWork(Locks.Client client) {
                client.releaseExclusive(resourceType, new long[]{key});
            }
        };
    }

    static void assertNotWaiting(Future<Void> lock) {
        Assertions.assertDoesNotThrow(() -> (Void)lock.get(5L, TimeUnit.SECONDS), (String)"Waiting for lock timed out!");
    }

    void assertWaiting(Locks.Client client, Future<Void> lock) {
        Assertions.assertThrows(TimeoutException.class, () -> lock.get(10L, TimeUnit.MILLISECONDS));
        Assertions.assertDoesNotThrow(() -> this.clientToThreadMap.get(client).untilWaiting());
    }

    public static abstract class LockCommand
    implements Runnable {
        private final Actor thread;
        private final Locks.Client client;

        LockCommand(Actor thread, Locks.Client client) {
            this.thread = thread;
            this.client = client;
        }

        public Future<Void> call() {
            return this.thread.submit((Runnable)this);
        }

        Future<Void> callAndAssertWaiting() {
            Future<Void> otherThreadLock = this.call();
            try {
                this.thread.untilWaiting();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            Assertions.assertFalse((boolean)otherThreadLock.isDone(), (String)"Should not have acquired lock.");
            return otherThreadLock;
        }

        @Override
        public void run() {
            this.doWork(this.client);
        }

        abstract void doWork(Locks.Client var1) throws AcquireLockTimeoutException;

        public Locks.Client client() {
            return this.client;
        }
    }
}

