/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.net.URL;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.URLAccessRules;

class FileURLAccessRuleTest {
    FileURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenFileURLContainsAuthority() {
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)Config.defaults(), new URL("file://foo/bar/baz")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL may not contain an authority section (i.e. it should be 'file:///')");
    }

    @Test
    void shouldThrowWhenFileURLContainsQuery() {
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)Config.defaults(), new URL("file:///bar/baz?q=foo")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL may not contain a query component");
    }

    @Test
    void shouldThrowWhenFileAccessIsDisabled() throws Exception {
        URL url = new URL("file:///bar/baz.csv");
        Config config = Config.defaults((Setting)GraphDatabaseSettings.allow_file_urls, (Object)false);
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("configuration property 'dbms.security.allow_csv_import_from_file_urls' is false");
    }

    @Test
    void shouldThrowWhenRelativePathIsOutsideImportDirectory() {
        Assumptions.assumeFalse((boolean)Path.of("/", new String[0]).relativize(Path.of("/../baz.csv", new String[0])).toString().equals("baz.csv"));
        Path importDir = Path.of("/tmp/neo4jtest", new String[0]).toAbsolutePath();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.load_csv_file_url_root, (Object)importDir);
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.fileAccess().validate((Configuration)config, new URL("file:///../baz.csv")));
        Assertions.assertThat((String)error.getMessage()).isEqualTo("file URL points outside configured import directory");
    }

    @Test
    void shouldAdjustURLToWithinImportDirectory() throws Exception {
        URL url = Path.of("/bar/baz.csv", new String[0]).toUri().toURL();
        Config config = Config.defaults((Setting)GraphDatabaseSettings.load_csv_file_url_root, (Object)Path.of("/var/lib/neo4j/import", new String[0]));
        URL accessURL = URLAccessRules.fileAccess().validate((Configuration)config, url);
        URL expected = Path.of("/var/lib/neo4j/import/bar/baz.csv", new String[0]).toUri().toURL();
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)accessURL);
    }
}

