/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import inet.ipaddr.IPAddressString;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.security.URLAccessValidationError;
import org.neo4j.kernel.impl.security.URLAccessRules;

class WebURLAccessRuleTest {
    WebURLAccessRuleTest() {
    }

    @Test
    void shouldThrowWhenUrlIsWithinBlockedRange() throws MalformedURLException {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.0/8");
        IPAddressString blockedIpv6Range = new IPAddressString("0:0:0:0:0:0:0:1/8");
        List<String> urlAddresses = List.of("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range, blockedIpv6Range));
            URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
            Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"});
        }
    }

    @Test
    void validationShouldPassWhenUrlIsNotWithinBlockedRange() throws MalformedURLException, URLAccessValidationError {
        List<String> urlAddresses = List.of("http://localhost/test.csv", "https://localhost/test.csv", "ftp://localhost/test.csv", "http://[::1]/test.csv");
        for (String urlAddress : urlAddresses) {
            URL url = new URL(urlAddress);
            Config config = Config.defaults();
            URL result = URLAccessRules.webAccess().validate((Configuration)config, url);
            assert (result == url);
        }
    }

    @Test
    void shouldWorkWithNonRangeIps() throws MalformedURLException {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.1");
        URL url = new URL("http://localhost/test.csv");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"blocked via the configuration property unsupported.dbms.cypher_ip_blocklist"});
    }

    @Test
    void shouldFailForInvalidIps() throws Exception {
        IPAddressString blockedIpv4Range = new IPAddressString("127.0.0.1");
        URL url = new URL("http://always.invalid/test.csv");
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.cypher_ip_blocklist, List.of(blockedIpv4Range));
        URLAccessValidationError error = (URLAccessValidationError)org.junit.jupiter.api.Assertions.assertThrows(URLAccessValidationError.class, () -> URLAccessRules.webAccess().validate((Configuration)config, url));
        Assertions.assertThat((String)error.getMessage()).contains(new CharSequence[]{"Unable to verify access to always.invalid"});
    }
}

