/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.QueueTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionLogQueue;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.tracing.AppendTransactionEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.Health;
import org.neo4j.monitoring.PanicEventGenerator;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@Neo4jLayoutExtension
@ExtendWith(value={LifeExtension.class})
class QueueTransactionAppenderTestIT {
    @Inject
    private FileSystemAbstraction fileSystem;
    @Inject
    private LifeSupport life;
    @Inject
    private DatabaseLayout databaseLayout;
    private ThreadPoolJobScheduler jobScheduler;
    private SimpleLogVersionRepository logVersionRepository;
    private SimpleTransactionIdStore transactionIdStore;
    private TransactionMetadataCache metadataCache;
    private Config config;
    private DatabaseHealth databaseHealth;
    private NullLogProvider logProvider;

    QueueTransactionAppenderTestIT() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        this.logVersionRepository = new SimpleLogVersionRepository();
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logProvider = NullLogProvider.getInstance();
        this.metadataCache = new TransactionMetadataCache();
        this.config = Config.defaults();
        this.databaseHealth = new DatabaseHealth(PanicEventGenerator.NO_OP, this.logProvider.getLog(DatabaseHealth.class));
    }

    @AfterEach
    void tearDown() {
        this.life.shutdown();
        this.jobScheduler.close();
    }

    @Test
    void sequentialProcessingOfTransaction() throws IOException, ExecutionException, InterruptedException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        long txId = this.transactionIdStore.getLastCommittedTransactionId();
        for (int i = 0; i < 10; ++i) {
            TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
            org.junit.jupiter.api.Assertions.assertEquals((long)(++txId), (long)transactionAppender.append(transactionToApply, LogAppendEvent.NULL));
        }
    }

    @Test
    void failToProcessTransactionOnShutdownAppender() throws IOException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> transactionAppender.append(transactionToApply, LogAppendEvent.NULL));
        this.life.shutdown();
        Assertions.assertThatThrownBy(() -> transactionAppender.append(transactionToApply, LogAppendEvent.NULL)).hasRootCauseInstanceOf(DatabaseShutdownException.class);
    }

    @Test
    void failToProcessTransactionOnNotStartedAppender() throws IOException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
        Assertions.assertThatThrownBy(() -> transactionAppender.append(transactionToApply, LogAppendEvent.NULL)).hasRootCauseInstanceOf(DatabaseShutdownException.class);
    }

    @Test
    void publishTransactionAsCommittedOnProcessing() throws IOException, ExecutionException, InterruptedException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        long initialLastCommittedTxId = this.transactionIdStore.getLastCommittedTransactionId();
        long initialLastClosedTxId = this.transactionIdStore.getLastClosedTransactionId();
        int numberOfTransactions = 10;
        for (int i = 0; i < numberOfTransactions; ++i) {
            TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
            transactionAppender.append(transactionToApply, LogAppendEvent.NULL);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)(initialLastCommittedTxId + (long)numberOfTransactions), (long)this.transactionIdStore.getLastCommittedTransactionId());
        org.junit.jupiter.api.Assertions.assertEquals((long)initialLastClosedTxId, (long)this.transactionIdStore.getLastClosedTransactionId());
    }

    @Test
    void failToProcessTransactionOnNonHealthyDatabase() throws IOException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        RuntimeException panicException = new RuntimeException("Don't panic, the answer is known!");
        this.databaseHealth.panic((Throwable)panicException);
        TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
        Assertions.assertThatThrownBy(() -> transactionAppender.append(transactionToApply, LogAppendEvent.NULL)).hasRootCause((Throwable)panicException);
    }

    @Test
    void processTransactionWithProperEvents() throws IOException, ExecutionException, InterruptedException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
        RecordingLogAppendEvent logAppendEvent = new RecordingLogAppendEvent();
        transactionAppender.append(transactionToApply, (LogAppendEvent)logAppendEvent);
        Assertions.assertThat(logAppendEvent.getEvents()).containsExactly((Object[])new EventType[]{EventType.BEGIN_APPEND, EventType.FILE_APPEND, EventType.CLOSE_APPEND, EventType.ROTATED_FALSE, EventType.LOG_FORCE});
    }

    @Test
    void failureOnProcessingUpdatesDatabaseHealth() throws IOException {
        LogFiles logFiles = this.buildLogFiles(this.logVersionRepository, this.transactionIdStore);
        this.life.add((Lifecycle)logFiles);
        QueueTransactionAppender transactionAppender = this.createAppender(logFiles);
        this.life.add((Lifecycle)transactionAppender);
        final RuntimeException criticalException = new RuntimeException("The greatest teacher, failure is.");
        TransactionToApply transactionToApply = QueueTransactionAppenderTestIT.createTransaction();
        Assertions.assertThatThrownBy(() -> transactionAppender.append(transactionToApply, (LogAppendEvent)new LogAppendEvent.Empty(){

            public LogForceEvent beginLogForce() {
                throw criticalException;
            }
        })).getRootCause().hasMessageContaining("failure is.");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.databaseHealth.isHealthy());
        Assertions.assertThat((Throwable)this.databaseHealth.cause()).isSameAs((Object)criticalException);
        Assertions.assertThatThrownBy(() -> transactionAppender.append(transactionToApply, LogAppendEvent.NULL)).getRootCause().hasMessageContaining("failure is.");
    }

    private QueueTransactionAppender createAppender(LogFiles logFiles) {
        TransactionLogQueue logQueue = new TransactionLogQueue(logFiles, (TransactionIdStore)this.transactionIdStore, (Health)this.databaseHealth, this.metadataCache, this.config, (JobScheduler)this.jobScheduler, (LogProvider)this.logProvider);
        return new QueueTransactionAppender(logQueue);
    }

    private static TransactionToApply createTransaction() {
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(List.of(new TestCommand()));
        tx.setHeader(ArrayUtils.EMPTY_BYTE_ARRAY, 1L, 2L, 3L, 4, AuthSubject.ANONYMOUS);
        return new TransactionToApply((TransactionRepresentation)tx, CursorContext.NULL, StoreCursors.NULL);
    }

    private LogFiles buildLogFiles(SimpleLogVersionRepository logVersionRepository, SimpleTransactionIdStore transactionIdStore) throws IOException {
        return LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fileSystem).withLogVersionRepository((LogVersionRepository)logVersionRepository).withRotationThreshold(ByteUnit.mebiBytes((long)1L)).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
    }

    private static class RecordingTransactionAppendEvent
    implements AppendTransactionEvent {
        private final Queue<EventType> events;

        RecordingTransactionAppendEvent(Queue<EventType> events) {
            this.events = events;
        }

        public void close() {
            this.events.add(EventType.CLOSE_APPEND);
        }
    }

    private static class RecordingLogAppendEvent
    implements LogAppendEvent {
        private final Queue<EventType> events = new LinkedBlockingQueue<EventType>();

        private RecordingLogAppendEvent() {
        }

        public void appendToLogFile(LogPosition logPositionBeforeAppend, LogPosition logPositionAfterAppend) {
            this.events.add(EventType.FILE_APPEND);
        }

        public void close() {
            this.events.add(EventType.CLOSE);
        }

        public void setLogRotated(boolean logRotated) {
            EventType event = logRotated ? EventType.ROTATED_TRUE : EventType.ROTATED_FALSE;
            this.events.add(event);
        }

        public AppendTransactionEvent beginAppendTransaction(int appendItems) {
            this.events.add(EventType.BEGIN_APPEND);
            return new RecordingTransactionAppendEvent(this.events);
        }

        public LogForceWaitEvent beginLogForceWait() {
            this.events.add(EventType.LOG_FORCE_WAIT);
            return LogForceWaitEvent.NULL;
        }

        public LogForceEvent beginLogForce() {
            this.events.add(EventType.LOG_FORCE);
            return LogForceEvent.NULL;
        }

        public LogRotateEvent beginLogRotate() {
            this.events.add(EventType.ROTATE);
            return LogRotateEvent.NULL;
        }

        public Queue<EventType> getEvents() {
            return this.events;
        }
    }

    private static enum EventType {
        FILE_APPEND,
        ROTATE,
        ROTATED_TRUE,
        ROTATED_FALSE,
        BEGIN_APPEND,
        CLOSE_APPEND,
        LOG_FORCE_WAIT,
        LOG_FORCE,
        CLOSE;

    }
}

